/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.sparse;

import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseListMutatedException;
import org.jetbrains.annotations.Nullable;

public abstract class N_SparseList {
    private final int sizeMax;

    public N_SparseList(int sizeMax) {
        this.sizeMax = sizeMax;
    }

    public abstract String getOptimizeInfo();

    public int getSizeMax() {
        return this.sizeMax;
    }

    public abstract int getSize();

    @Nullable
    public int[] get(int index) {
        this.assertIndexValue(index);
        return this.doGet(index);
    }

    @Nullable
    protected abstract int[] doGet(int var1);

    public void set(int index, int[] value) throws N_SparseListMutatedException {
        this.assertIndexValue(index);
        this.doSet(index, value);
    }

    protected abstract void doSet(int var1, int[] var2) throws N_SparseListMutatedException;

    private void assertIndexValue(int index) {
        if (index < 0 || index >= this.sizeMax) {
            throw new ArrayIndexOutOfBoundsException(index + " (sizeMax:" + this.sizeMax + ")");
        }
    }

    public abstract N_SparseList copyTo(N_CancellingContext var1, N_SparseList var2);

    public abstract void compact(N_CancellingContext var1, boolean var2);

    public abstract N_SparseList optimize(N_CancellingContext var1, String var2, String var3);
}

