/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.sparse;

import crazydev.common.system.CdVirtualMachine;
import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.facts.sparse.N_PaginatedSparseList;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseList;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseListOptimizer;

public class N_PaginatedSparseListOptimizer
extends N_SparseListOptimizer {
    private final int bits;
    private final int mask;
    private final int[] pages;

    public N_PaginatedSparseListOptimizer(int sizeMax, int size, int bits) {
        super(sizeMax, size);
        this.bits = bits;
        this.mask = (1 << bits) - 1;
        this.pages = new int[N_PaginatedSparseListOptimizer.computePageCount(sizeMax, bits)];
        for (int pp = 0; pp < this.pages.length; ++pp) {
            this.pages[pp] = -1;
        }
    }

    private static int computePageCount(int sizeMax, int bits) {
        int indexMax = sizeMax - 1;
        int pageIndexMax = indexMax >> bits;
        return pageIndexMax + 1;
    }

    @Override
    public void addIndex(int index) {
        int pageIndex = index >> this.bits;
        int pageOffset = index & this.mask;
        this.pages[pageIndex] = Math.max(this.pages[pageIndex], pageOffset);
    }

    @Override
    public long computeCost() {
        long cost = CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + CdVirtualMachine.NUM_BYTES_OBJECT_REF * this.pages.length;
        for (int pp = 0; pp < this.pages.length; ++pp) {
            int offsetMax = this.pages[pp];
            if (offsetMax == -1) continue;
            int pageItemCount = offsetMax + 1;
            cost += (long)(CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + CdVirtualMachine.NUM_BYTES_OBJECT_REF * pageItemCount);
        }
        return cost;
    }

    public static long computeCost(int[][][] bitmapPages) {
        long cost = CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + CdVirtualMachine.NUM_BYTES_OBJECT_REF * bitmapPages.length;
        for (int pp = 0; pp < bitmapPages.length; ++pp) {
            int[][] page = bitmapPages[pp];
            if (page == null) continue;
            int pageItemCount = page.length;
            cost += (long)(CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + CdVirtualMachine.NUM_BYTES_OBJECT_REF * pageItemCount);
        }
        return cost;
    }

    @Override
    public N_SparseList optimize(N_CancellingContext context, N_SparseList other) {
        N_PaginatedSparseList others_;
        if (other instanceof N_PaginatedSparseList && this.bits == (others_ = (N_PaginatedSparseList)other).getBits()) {
            return other;
        }
        N_SparseList optimized = new N_PaginatedSparseList(this.sizeMax, this.bits);
        optimized = other.copyTo(context, optimized);
        return optimized;
    }
}

