/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.roaring.mmap;

import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsContainer;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsSizeOf;
import crazydev.iccube.cluster.node.facts.N_FactPageLevelStats;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageImmutableContainersI;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringBuffer;
import crazydev.iccube.cluster.node.facts.roaring.N_RoaringMappableContainer;
import crazydev.iccube.cluster.node.facts.roaring.mmap.N_FactPageFileImmutableContainers;
import crazydev.iccube.cluster.node.facts.roaring.mmap.N_FactPageRoaringBitmapFileConfiguration;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.Nullable;

public class N_FactPageRoaringBitmapFileGutsContainer
extends N_FactPageBitmapGutsContainer<N_FactPageFileImmutableContainers> {
    private static long SHALLOW_SIZE_OF = -1L;
    private final N_FactPageRoaringBitmapFileConfiguration configuration;
    @Nullable
    private Mode mode;

    public N_FactPageRoaringBitmapFileGutsContainer(S_SchemaDef schemaDef, N_MeasureGroup measureGroup, String nameForStats, N_FactPageRoaringBitmapFileConfiguration configuration) {
        super(schemaDef, measureGroup, nameForStats, (N_FactPageImmutableContainersI[])new N_FactPageFileImmutableContainers[schemaDef.getIndexingHierarchyArraySize()]);
        this.configuration = configuration;
        this.mode = null;
        OlapLoggers.BUILDER.info((Object)("[facts] file guts-container [" + nameForStats + "] created w/ configuration " + configuration.toStringForLogs()));
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public void cleanupResources(OlapFileCleaner fileCleaner) {
        for (N_FactPageFileImmutableContainers hierarchy : (N_FactPageFileImmutableContainers[])this.iContainers) {
            if (hierarchy == null) continue;
            hierarchy.cleanupResource(fileCleaner);
        }
        File f = this.configuration.getContainer();
        if (!CdVFileSystemUtils.deleteQuietly((File)f)) {
            OlapLoggers.BUILDER.warn((Object)("[facts] file guts-container [" + this.nameForStats + "] could not delete [" + f.getAbsolutePath() + "]"));
            fileCleaner.register(f);
        }
    }

    @Override
    public N_FactPageBitmapGutsSizeOf sizeOf() {
        N_FactPageBitmapGutsSizeOf so = super.sizeOf();
        long size = 0L;
        for (N_FactPageFileImmutableContainers hierarchy : (N_FactPageFileImmutableContainers[])this.iContainers) {
            if (hierarchy == null) continue;
            size += hierarchy.fileSizeOf();
        }
        so.files = size;
        return so;
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    protected void onBuildCompleted() {
        this.switchToReadingMode();
    }

    @Override
    @Nullable
    protected N_FactPageImmutableContainersI getImmutableContainersForRead(int hierarchyIdx) {
        if (this.mode != Mode.READING) {
            throw new RuntimeException("internal error : file guts-container [" + this.nameForStats + "] unexpected mode [" + String.valueOf((Object)this.mode) + "]");
        }
        return super.getImmutableContainersForRead(hierarchyIdx);
    }

    @Override
    public void getGutsForStats(N_FactPageLevelStats stats, int hierarchyIndex, int memberIndex) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void duplicateImmutableContainers(N_PointableRoaringBuffer highLow, int toHierarchyIdx, int toMemberIdx) {
        N_FactPageFileImmutableContainers i = ((N_FactPageFileImmutableContainers[])this.iContainers)[toHierarchyIdx];
        if (i != null) {
            i.openForAppending(StandardOpenOption.APPEND);
        }
        try {
            super.duplicateImmutableContainers(highLow, toHierarchyIdx, toMemberIdx);
        }
        finally {
            i = ((N_FactPageFileImmutableContainers[])this.iContainers)[toHierarchyIdx];
            i.memoryMapForReading();
        }
    }

    @Override
    public int toImmutableContainer(boolean forDuplicate, int hierarchyIdx, int memberIdx, N_RoaringMappableContainer container) {
        if (!forDuplicate) {
            this.switchToBuildingMode();
        }
        return super.toImmutableContainer(forDuplicate, hierarchyIdx, memberIdx, container);
    }

    @Override
    protected N_FactPageFileImmutableContainers createImmutableContainer(int hierarchyIdx) {
        return new N_FactPageFileImmutableContainers(this.schemaDef, this.nameForStats, hierarchyIdx, this.configuration, true);
    }

    @Override
    protected void onRestoreCompleted() {
        super.onRestoreCompleted();
        this.switchToReadingMode();
    }

    @Override
    protected void restoreImmutableContainers(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.iContainers = new N_FactPageFileImmutableContainers[in.readInt()];
        for (int hh = 0; hh < ((N_FactPageFileImmutableContainers[])this.iContainers).length; ++hh) {
            if (context.isCancelling()) {
                return;
            }
            int marker = in.readInt();
            if (marker == -1) continue;
            N_FactPageFileImmutableContainers n_FactPageFileImmutableContainers = new N_FactPageFileImmutableContainers(this.schemaDef, this.nameForStats, hh, this.configuration, true);
            ((N_FactPageFileImmutableContainers[])this.iContainers)[hh] = n_FactPageFileImmutableContainers;
            N_FactPageFileImmutableContainers hierarchy = n_FactPageFileImmutableContainers;
            hierarchy.restore(context, in);
        }
    }

    private void switchToBuildingMode() {
        if (this.mode == Mode.BUILDING) {
            return;
        }
        OlapLoggers.BUILDER.info((Object)("[facts] file guts-container [" + this.nameForStats + "] BUILDING"));
        for (N_FactPageFileImmutableContainers hierarchy : (N_FactPageFileImmutableContainers[])this.iContainers) {
            if (hierarchy == null) continue;
            hierarchy.openForAppending(StandardOpenOption.CREATE);
        }
        this.mode = Mode.BUILDING;
    }

    private void switchToReadingMode() {
        if (this.mode == Mode.READING) {
            return;
        }
        OlapLoggers.BUILDER.info((Object)("[facts] file guts-container [" + this.nameForStats + "] READING"));
        for (N_FactPageFileImmutableContainers hierarchy : (N_FactPageFileImmutableContainers[])this.iContainers) {
            if (hierarchy == null) continue;
            hierarchy.memoryMapForReading();
        }
        this.mode = Mode.READING;
    }

    static enum Mode {
        BUILDING,
        READING;

    }
}

