/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.roaring;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageImmutableContainersI;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.MappeableContainer;

public class N_RoaringMappableContainer {
    private static long SHALLOW_SIZE_OF = -1L;
    private char key;
    @Nullable
    private MappeableContainer container;

    public N_RoaringMappableContainer() {
    }

    public N_RoaringMappableContainer(@Nullable MappeableContainer container, char key) {
        this.container = container;
        this.key = key;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += this.container != null ? this.container.sizeOf() : 0L;
    }

    public boolean isEmpty() {
        return this.container == null;
    }

    public char getKey() {
        return this.key;
    }

    public void setKey(char key) {
        this.key = key;
    }

    @Nullable
    public MappeableContainer getContainer() {
        return this.container;
    }

    public void setContainer(@Nullable MappeableContainer container) {
        this.container = container;
    }

    public MappeableContainer getContainerEx() {
        if (this.container == null) {
            throw new RuntimeException("internal error : unexpected missing container");
        }
        return this.container;
    }

    public N_RoaringMappableContainer runOptimize() {
        this.container = this.container != null ? this.container.runOptimize() : null;
        return this;
    }

    public N_RoaringMappableContainer clone() {
        return new N_RoaringMappableContainer(this.container != null ? this.container.clone() : null, this.key);
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        if (this.container == null) {
            throw new RuntimeException("internal error : unexpected missing container");
        }
        out.writeByte(this.container.getType().ordinal());
        out.writeChar(this.key);
        byte[] bits = new byte[this.container.getArraySizeInBytes(false)];
        ByteBuffer bb = ByteBuffer.wrap(bits);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.container.writeArray(bb, false);
        out.writeInt(bits.length);
        out.writeBytes(bits);
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int ordinal = in.read();
        this.key = in.readChar();
        byte[] bits = new byte[in.readInt()];
        in.readBytes(bits);
        ByteBuffer bb = ByteBuffer.wrap(bits);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.container = MappeableContainer.build(ordinal, bb);
    }

    public static byte[] serialize(MappeableContainer container) {
        MappeableContainer.Type type = container.getType();
        int len = container.getArraySizeInBytes(false);
        int bufferSize = 3 + len;
        ByteBuffer bb = ByteBuffer.allocate(bufferSize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putChar((char)bufferSize);
        bb.put((byte)type.ordinal());
        container.writeArray(bb, false);
        return bb.array();
    }

    public static MappeableContainer deserialize(N_FactPageImmutableContainersI container, int magicNumber) {
        return container.getMappeableContainer(magicNumber);
    }

    public static int deserializeSerializedSizeInBytesAtIndexForStats(N_FactPageImmutableContainersI container, int magicNumber) {
        return container.serializedSizeInBytesAtIndexForStats(magicNumber);
    }
}

