/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.roaring;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageImmutableContainersI;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringBufferI;
import crazydev.iccube.cluster.node.facts.roaring.N_RoaringMappableContainer;
import crazydev.iccube.cluster.node.facts.roaring.N_RoaringMetaUtils;
import org.roaringbitmap.buffer.MappeableContainer;

public class N_PointableRoaringBufferIM
extends N_PointableRoaringBufferI {
    private static long SHALLOW_SIZE_OF = -1L;
    private final N_RoaringMappableContainer mContainer;

    N_PointableRoaringBufferIM(N_FactPageImmutableContainersI iContainers, byte[] buffer, int bufferOffset, int size, N_RoaringMappableContainer mContainer) {
        super(iContainers, buffer, bufferOffset, size + 1);
        this.mContainer = mContainer;
    }

    @Override
    public long sizeOf() {
        long size = 0L;
        return size += SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    protected char getKey(int index) {
        if (index == this.size - 1) {
            return this.mContainer.getKey();
        }
        return super.getKey(index);
    }

    @Override
    public MappeableContainer getContainerAtIndex(int index) {
        if (index == this.size - 1) {
            return this.mContainer.getContainerEx();
        }
        int magicNumber = N_RoaringMetaUtils.getMagic(this.buffer, this.bufferOffset, this.size - 1, index);
        return N_RoaringMappableContainer.deserialize(this.iContainers, magicNumber);
    }

    @Override
    public int getSerializedSizeInBytesAtIndexForStats(int index) {
        if (index == this.size - 1) {
            MappeableContainer c = this.mContainer.getContainerEx();
            return c.serializedSizeInBytes();
        }
        int magicNumber = N_RoaringMetaUtils.getMagic(this.buffer, this.bufferOffset, this.size - 1, index);
        return N_RoaringMappableContainer.deserializeSerializedSizeInBytesAtIndexForStats(this.iContainers, magicNumber);
    }
}

