/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.roaring;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.PointableRoaringArray;

public abstract class N_PointableRoaringBuffer
implements PointableRoaringArray {
    protected final int size;

    N_PointableRoaringBuffer(int size) {
        this.size = size;
    }

    protected abstract char getKey(int var1);

    @Override
    public int advanceUntil(char x, int pos) {
        int upper;
        int lower = pos + 1;
        if (lower >= this.size || this.getKey(lower) >= x) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < this.size && this.getKey(lower + spansize) < x) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < this.size ? lower + spansize : this.size - 1;
        if (this.getKey(upper) == x) {
            return upper;
        }
        if (this.getKey(upper) < x) {
            return this.size;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (this.getKey(mid) == x) {
                return mid;
            }
            if (this.getKey(mid) < x) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    @Override
    public PointableRoaringArray clone() {
        throw new RuntimeException();
    }

    @Override
    public boolean containsForContainerAtIndex(int i, char x) {
        return false;
    }

    @Override
    public int getCardinality(int i) {
        return this.getContainerAtIndex(i).getCardinality();
    }

    @Override
    public Boolean validate() {
        return null;
    }

    @Override
    public int getContainerIndex(char x) {
        return N_PointableRoaringBuffer.hybridUnsignedBinarySearch(this::getKey, 0, this.size, x);
    }

    @Override
    public abstract MappeableContainer getContainerAtIndex(int var1);

    public abstract int getSerializedSizeInBytesAtIndexForStats(int var1);

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return this.getContainerPointer(0);
    }

    @Override
    public MappeableContainerPointer getContainerPointer(final int startIndex) {
        return new MappeableContainerPointer(){
            int k;
            final /* synthetic */ N_PointableRoaringBuffer this$0;
            {
                N_PointableRoaringBuffer n_PointableRoaringBuffer = this$0;
                Objects.requireNonNull(n_PointableRoaringBuffer);
                this.this$0 = n_PointableRoaringBuffer;
                this.k = startIndex;
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return this.key() - o.key();
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return this.getContainer().getCardinality();
            }

            @Override
            @Nullable
            public MappeableContainer getContainer() {
                if (this.k >= this.this$0.size) {
                    return null;
                }
                return this.this$0.getContainerAtIndex(this.k);
            }

            @Override
            public int getSerializedSizeInBytesForStats() {
                if (this.k >= this.this$0.size) {
                    return 0;
                }
                return this.this$0.getSerializedSizeInBytesAtIndexForStats(this.k);
            }

            @Override
            public boolean hasContainer() {
                return 0 <= this.k && this.k < this.this$0.size;
            }

            @Override
            public boolean isBitmapContainer() {
                return this.getContainer() instanceof MappeableBitmapContainer;
            }

            @Override
            public boolean isRunContainer() {
                return this.getContainer() instanceof MappeableRunContainer;
            }

            @Override
            public char key() {
                return this.this$0.getKey(this.k);
            }

            @Override
            public void previous() {
                --this.k;
            }
        };
    }

    @Override
    public int getIndex(char x) {
        if (this.size == 0 || this.getKey(this.size - 1) == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    private int binarySearch(int begin, int end, char key) {
        return N_PointableRoaringBuffer.hybridUnsignedBinarySearch(this::getKey, begin, end, key);
    }

    @Override
    public char getKeyAtIndex(int i) {
        return this.getKey(i);
    }

    @Override
    public boolean hasRunCompression() {
        throw new RuntimeException();
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        throw new RuntimeException();
    }

    @Override
    public int serializedSizeInBytes(boolean isForBitmapSerialize) {
        int size = 0;
        MappeableContainerPointer cp = this.getContainerPointer();
        while (cp.hasContainer()) {
            MappeableContainer container = cp.getContainer();
            if (container != null) {
                size += container.serializedSizeInBytes();
            }
            cp.advance();
        }
        return size;
    }

    @Override
    public int serializedSizeInBytesForStats() {
        int size = 0;
        MappeableContainerPointer cp = this.getContainerPointer();
        while (cp.hasContainer()) {
            size += cp.getSerializedSizeInBytesForStats();
            cp.advance();
        }
        return size;
    }

    @Override
    public int size() {
        return this.size;
    }

    public abstract long sizeOf();

    private static int hybridUnsignedBinarySearch(CharBufferGetter array, int begin, int end, char k) {
        int x;
        if (end > 0 && array.get(end - 1) < k) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low + 32 <= high) {
            int middleIndex = low + high >>> 1;
            char middleValue = array.get(middleIndex);
            if (middleValue < k) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > k) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            char val = array.get(x);
            if (val < k) continue;
            if (val != k) break;
            return x;
        }
        return -(x + 1);
    }

    @FunctionalInterface
    protected static interface CharBufferGetter {
        public char get(int var1);
    }
}

