/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.roaring;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.collection.CdPair;
import crazydev.common.collection.TCharArrayList;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdArrayUtils;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringArrayDataReaderI;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringBufferI;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringBufferIM;
import crazydev.iccube.cluster.node.facts.roaring.N_RoaringMetaUtils;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.common.CdCompressedIntIntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.Nullable;

public class N_FactPageRoaringMetaContainerReader {
    private static long SHALLOW_SIZE_OF = -1L;
    private final S_SchemaDef schemaDef;
    private final int hierarchyIdx;
    private CdCompressedIntIntMap bufferPositions;
    private byte[] buffer;

    public N_FactPageRoaringMetaContainerReader(S_SchemaDef schemaDef, int hierarchyIdx) {
        this.schemaDef = schemaDef;
        this.hierarchyIdx = hierarchyIdx;
    }

    public N_FactPageRoaringMetaContainerReader(S_SchemaDef schemaDef, int hierarchyIdx, CdCompressedIntIntMap bufferPositions, byte[] bytes) {
        this.schemaDef = schemaDef;
        this.hierarchyIdx = hierarchyIdx;
        this.bufferPositions = bufferPositions;
        this.buffer = bytes;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += this.bufferPositions.sizeOf();
        return size += CdRamUsageEstimator.sizeOf((byte[])this.buffer);
    }

    public int memberCount() {
        return this.bufferPositions.getMaxIndex();
    }

    public int bitMapCount() {
        return this.bufferPositions.getMaxIndex();
    }

    public int nonNullSize() {
        return this.bufferPositions.nonNullSize();
    }

    public boolean hasMemberMetaForRead(int memberIdx) {
        return this.bufferPositions.getValue(memberIdx) != 0;
    }

    public N_PointableRoaringArrayDataReaderI getMemberMetaForRead(int memberIdx) {
        int startPos = this.bufferPositions.getValue(memberIdx);
        if (startPos == 0) {
            return null;
        }
        char size = this.getSize(startPos);
        return (iContainers, mContainer) -> {
            if (mContainer == null) {
                return new N_PointableRoaringBufferI(iContainers, this.buffer, startPos, size);
            }
            return new N_PointableRoaringBufferIM(iContainers, this.buffer, startPos, size, mContainer);
        };
    }

    public char getSize(int startPos) {
        return N_RoaringMetaUtils.getSize(this.buffer, startPos);
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.bufferPositions.save(context, out);
        out.writeInt(this.buffer.length);
        out.writeBytes(this.buffer);
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.bufferPositions = CdCompressedIntIntMap.restore(context, in, this.schemaDef, this.hierarchyIdx);
        this.buffer = new byte[in.readInt()];
        in.readBytes(this.buffer);
    }

    public static Int2ObjectOpenHashMap<CdPair<TCharArrayList, IntArrayList>> transform(Int2ObjectOpenHashMap<CdPaginatedIntList> clean) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] keys = clean.keySet().toIntArray();
        Arrays.sort(keys);
        for (int key : keys) {
            CdPaginatedIntList chain = (CdPaginatedIntList)clean.get(key);
            for (int i = 0; i < chain.size(); ++i) {
                int memberIdx = chain.getInt(i);
                int magicNumber = chain.getInt(++i);
                if (!map.containsKey(memberIdx)) {
                    map.put(memberIdx, (Object)new CdPair((Object)new TCharArrayList(), (Object)new IntArrayList()));
                }
                CdPair res = (CdPair)map.get(memberIdx);
                ((TCharArrayList)res.fst).add((char)key);
                ((IntArrayList)res.snd).add(magicNumber);
            }
        }
        return map;
    }

    public static N_FactPageRoaringMetaContainerReader build(S_SchemaDef schemaDef, int hierarchyIdx, Int2ObjectOpenHashMap<CdPair<TCharArrayList, IntArrayList>> metaData, int _minMemberIDX, int _maxMemberIdx, @Nullable N_FactPageRoaringMetaContainerReader existingReader) {
        if (metaData.isEmpty()) {
            return existingReader == null ? N_FactPageRoaringMetaContainerReader.emptyReader(schemaDef, hierarchyIdx) : existingReader;
        }
        int minMemberIDX = Math.min(_minMemberIDX, existingReader == null ? Integer.MAX_VALUE : existingReader.bufferPositions.getMinIndex());
        int maxMemberIdx = Math.max(_maxMemberIdx, existingReader == null ? Integer.MIN_VALUE : existingReader.bufferPositions.getMaxIndex());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int[] startingPos = new int[maxMemberIdx + 1];
        baos.write(33);
        if (existingReader != null) {
            existingReader.forEach(memberIdx -> {
                if (!metaData.containsKey(memberIdx)) {
                    int initSize = baos.size();
                    if (existingReader.write(baos, memberIdx)) {
                        startingPos[memberIdx - minMemberIDX] = initSize;
                    }
                }
                return true;
            });
        }
        metaData.forEach((memberIdx, pair) -> {
            int magicNumber;
            char key;
            int i;
            TCharArrayList keys = (TCharArrayList)pair.fst;
            IntArrayList magicNumbers = (IntArrayList)pair.snd;
            int size = keys.size();
            N_PointableRoaringBufferI roaringBuffer = null;
            if (existingReader != null) {
                N_PointableRoaringArrayDataReaderI b = existingReader.getMemberMetaForRead((int)memberIdx);
                roaringBuffer = b == null ? null : (N_PointableRoaringBufferI)b.create(null, null);
            }
            startingPos[memberIdx.intValue() - minMemberIDX] = baos.size();
            int roaringSize = roaringBuffer == null ? 0 : roaringBuffer.size();
            N_FactPageRoaringMetaContainerReader.writeChar(baos, roaringSize + size);
            for (i = 0; i < roaringSize; ++i) {
                key = roaringBuffer.getKey(i);
                N_FactPageRoaringMetaContainerReader.writeChar(baos, key);
            }
            for (i = 0; i < keys.size(); ++i) {
                key = keys.get(i);
                N_FactPageRoaringMetaContainerReader.writeChar(baos, key);
            }
            for (i = 0; i < roaringSize; ++i) {
                magicNumber = roaringBuffer.getMagicNumber(i);
                N_FactPageRoaringMetaContainerReader.writeInt(baos, magicNumber);
            }
            for (i = 0; i < magicNumbers.size(); ++i) {
                magicNumber = magicNumbers.getInt(i);
                N_FactPageRoaringMetaContainerReader.writeInt(baos, magicNumber);
            }
        });
        return new N_FactPageRoaringMetaContainerReader(schemaDef, hierarchyIdx, CdCompressedIntIntMap.build(hierarchyIdx, startingPos, minMemberIDX), baos.toByteArray());
    }

    private boolean write(ByteArrayOutputStream baos, int memberIdx) {
        int startPos = this.bufferPositions.getValue(memberIdx);
        if (startPos == 0) {
            return false;
        }
        char size = this.getSize(startPos);
        int bufferSize = N_RoaringMetaUtils.getSize(size);
        baos.write(this.buffer, startPos, bufferSize);
        return true;
    }

    private void forEach(IntPredicate callback) {
        int maxIndex = this.bufferPositions.getMaxIndex();
        for (int i = this.bufferPositions.getMinIndex(); i <= maxIndex; ++i) {
            if (callback.test(i)) continue;
            return;
        }
    }

    private static N_FactPageRoaringMetaContainerReader emptyReader(S_SchemaDef schemaDef, int hierarchyIdx) {
        return new N_FactPageRoaringMetaContainerReader(schemaDef, hierarchyIdx, CdCompressedIntIntMap.EMPTY, CdArrayUtils.EMPTY_BYTE_ELEMENTDATA);
    }

    private static void writeInt(ByteArrayOutputStream baos, int value) {
        baos.write(value & 0xFF);
        baos.write(value >> 8 & 0xFF);
        baos.write(value >> 16 & 0xFF);
        baos.write(value >> 24 & 0xFF);
    }

    private static void writeChar(ByteArrayOutputStream baos, int value) {
        baos.write(value & 0xFF);
        baos.write(value >> 8 & 0xFF);
    }

    public String toString() {
        return "h:" + this.hierarchyIdx;
    }
}

