/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.facts.N_AggregatorHelper;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class N_RegularTupleAggregatorHelper
extends N_AggregatorHelper {
    private final N_MdxRequestContext context;
    private final GFContext dtContext;
    private final S_FactTupleDef tupleDef;
    private final S_MeasureRef measureRef;
    private final S_MeasureDef measureDef;
    private final OlapMeasureMember measure;
    @Nullable
    private final S_TupleDimensionalityDef overwrittenHierarchies;
    @Nullable
    private final S_VisualTotalsDef visualTotals;
    @Nullable
    private final List<S_RequestSubCubeDef> subCubes;

    public N_RegularTupleAggregatorHelper(N_MdxRequestContext context, GFContext dtContext, N_MeasureGroup measureGroup, S_FactTupleDef tupleDef, OlapMeasureMember measure, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        super(measureGroup);
        this.context = context;
        this.dtContext = dtContext;
        this.tupleDef = tupleDef;
        this.measure = measure;
        this.measureRef = measure.getClusterRefs()[0];
        this.measureDef = measureGroup.resolveMeasure(this.measureRef);
        this.overwrittenHierarchies = overwrittenHierarchies;
        this.visualTotals = visualTotals;
        this.subCubes = subCubes;
    }

    @Override
    public boolean isDrillthroughActive() {
        return this.context.isDrillthroughActive();
    }

    @Override
    public OlapAggregationType getAggregationType() {
        return this.measure.getHierarchyAggregationType();
    }

    @Override
    public String getMeasureName() {
        return this.measureDef.getName();
    }

    @Override
    public boolean hasNulls() {
        boolean hasNulls = this.measureGroup.hasNulls(this.measureRef);
        return hasNulls;
    }

    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter() {
        return this.measureGroup.getFastNonEmptyFilter(this.context, this.dtContext, this.tupleDef, this.measure, OlapAggregationType.NO_EMPTY, this.measureDef, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
    }

    @Override
    public OlapScalarEntity aggregate(OlapAggregationType aggregationType) {
        OlapScalarEntity res = this.measureGroup.aggregateTuple(this.context, this.dtContext, this.tupleDef, this.measure, aggregationType, this.measureDef, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
        return res;
    }

    @Override
    public long cardinality() {
        long cardinality = this.measureGroup.cardinality(this.context, this.tupleDef, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
        return cardinality;
    }

    @Override
    public boolean isNoEmpty() {
        boolean noEmpty = this.measureGroup.isNoEmpty(this.context, this.tupleDef, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
        return noEmpty;
    }

    @Override
    public OlapScalarEntity toEmptyZeroIfNeeded(OlapScalarEntity scalar) {
        OlapScalarEntity res = this.measureDef.toEmptyZeroIfNeeded(scalar);
        return res;
    }
}

