/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.common.collection.CdSingleItemList;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.context.N_FactPageAggregationHelper;
import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.context.N_SetEvaluatorContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.node.schema.N_FastCj_Cache;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextKind;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsAggregationProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.multicolumn.OlapFactMultiColumnAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapVisitor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class N_RegularMeasureGroup
extends N_MeasureGroup {
    private final AtomicReference<N_FactPage> factPage = new AtomicReference();

    protected N_RegularMeasureGroup(S_BuildSchemaContextKind buildMode, S_SchemaDef schemaDef, S_CubeDef cubeDef, S_MeasureGroupDef measureGroupDef) {
        super(buildMode, schemaDef, cubeDef, measureGroupDef);
    }

    @Override
    public void cleanupResources(OlapFileCleaner fileCleaner) {
        N_FactPage factPage = this.factPage.get();
        if (factPage != null) {
            factPage.cleanupResources(fileCleaner);
        }
    }

    @Override
    public void savePartitionsContent(N_BackupContext context, OlapEngineBackupConfiguration configuration, File dir) throws IOException {
        N_FactPage partition = this.factPage.get();
        if (partition != null) {
            partition.save(context, configuration, dir);
        }
    }

    @Override
    protected N_FactPage getFactPage(int backupID, String nameForStats) {
        N_FactPage factPage = this.factPage.get();
        if (factPage != null && factPage.getBackupID() == backupID) {
            if (!factPage.getNameForStats().equals(nameForStats)) {
                throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent fact page when restoring partitions [" + this.getName() + "] [" + backupID + "] [" + nameForStats + "] : expected [" + factPage.getNameForStats() + "]");
            }
            return factPage;
        }
        throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page when restoring partitions [" + this.getName() + "] [" + backupID + "] [" + nameForStats + "]");
    }

    @Override
    public void clearOnIncrLoadFullReload(OlapFileCleaner fileCleaner) {
        OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.cubeDef.getSchemaName() + "] cube [" + this.cubeDef.getName() + "] facts [" + this.getMeasureGroupName() + "] clear-on-incr-load-full-reload  (node:regular)"));
        N_FactPage page = this.factPage.get();
        if (page != null) {
            page.cleanupResources(fileCleaner);
        }
        this.factPage.set(null);
    }

    @Override
    public void unloadPartitions(OlapFileCleaner fileCleaner, List<S_FactPageRef> partitionRefs) {
        throw new RuntimeException("internal error: [" + this.getName() + "] (unload-partitions) inconsistent usage of regular measure group [" + this.getName() + "]");
    }

    @Override
    public void unloadMeasureGroup(OlapFileCleaner fileCleaner) {
        N_FactPage factPage_ = this.factPage.get();
        if (factPage_ != null) {
            OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.cubeDef.getSchemaName() + "] cube [" + this.cubeDef.getName() + "] facts [" + this.getMeasureGroupName() + "] unloading"));
            factPage_.cleanupResources(fileCleaner);
            this.factPage.set(null);
        } else {
            OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.cubeDef.getSchemaName() + "] cube [" + this.cubeDef.getName() + "] facts [" + this.getMeasureGroupName() + "] unloading IGNORED"));
        }
    }

    @Override
    public void adoptPartitions(OlapFileCleaner fileCleaner, N_MeasureGroup loadedMeasureGroup, @Nullable S_FactPageRef partition, S_FactPageRef loadedPartition) {
        if (!(loadedMeasureGroup instanceof N_RegularMeasureGroup)) {
            throw new RuntimeException("internal error: [" + this.getName() + "] (adopt-partitions) inconsistent usage (" + this.getClass().getSimpleName() + "/" + loadedMeasureGroup.getClass().getSimpleName() + ")");
        }
        this.doAdoptPartitions(fileCleaner, (N_RegularMeasureGroup)loadedMeasureGroup, partition, loadedPartition);
    }

    private void doAdoptPartitions(OlapFileCleaner fileCleaner, N_RegularMeasureGroup loadedMeasureGroup, @Nullable S_FactPageRef partition, S_FactPageRef loadedPartition) {
        N_FactPage loadedFactPage = loadedMeasureGroup.factPage.get();
        this.preValidateAdoptPartition(partition, this.factPage.get(), loadedPartition, loadedFactPage);
        N_FactPage factPage_ = this.factPage.get();
        if (factPage_ != null) {
            factPage_.cleanupResources(fileCleaner);
        }
        this.factPage.set(loadedFactPage);
        loadedMeasureGroup.factPage.set(null);
    }

    @Override
    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info, S_FactPageRef partitionRef) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page [" + this.getName() + "] [" + String.valueOf(partitionRef) + "]");
        }
        factPage.getInformationForPerformanceTests(info);
    }

    @Override
    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies, S_FactPageRef partitionRef) throws IOException {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page [" + this.getName() + "] [" + String.valueOf(partitionRef) + "]");
        }
        factPage.dumpIndex(out, hierarchies);
    }

    @Override
    public void createPartitionStats(OlapStatsContext context, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, S_FactPageRef partitionRef, Set<OlapDimension> dimensions__) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page [" + this.getName() + "] [" + String.valueOf(partitionRef) + "]");
        }
        factPage.createStats(context, statsPerLevel, partitionsStats, dimensions__);
    }

    @Override
    public void createIncrLoadPartitionStats(List<OlapFactsPartitionStats> partitionsStats, S_FactPageRef partitionRef) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page [" + this.getName() + "] [" + String.valueOf(partitionRef) + "]");
        }
        factPage.createIncrLoadStats(partitionsStats);
    }

    @Override
    public void onSchemaPartitionsLoaded() {
        N_FactPage factPage = this.factPage.get();
        if (factPage != null) {
            OlapLoggers.BUILDER.error((Object)("[partition] remaining loaded partition [" + this.schemaDef.getName() + "] [" + this.cubeDef.getName() + "] [" + this.measureGroupDef.getName() + "] [" + factPage.getName() + "]"));
            throw new RuntimeException("internal error: (R) remaining loaded partitions for schema [" + this.schemaDef.getName() + "] (check log files for more details)");
        }
    }

    @Override
    public void onSchemaPartitionsLoadedOnError(OlapFileCleaner fileCleaner) {
        this.cleanupResources(fileCleaner);
        this.factPage.set(null);
    }

    @Override
    public N_FactPage createFactPage(N_BuildFactContext context, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef, boolean empty, int backupID, String nameForStats) {
        N_FactPage factPage = this.factPage.get();
        if (factPage != null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent (1) facts page [" + this.getName() + " / " + String.valueOf(factPage.getRef()) + "]");
        }
        S_CubeDef cubeDef = this.schemaDef.resolveCube(cubeRef);
        S_MeasureGroupDef measureGroupDef = cubeDef.getMeasureGroup(measureGroupRef);
        factPage = new N_FactPage(context, this, factPageRef, this.getFactsColumnListFactory(), this.getFactsBitmapContainerFactory(), backupID, nameForStats, null, this.schemaDef, cubeDef, measureGroupDef, empty);
        this.factPage.set(factPage);
        return factPage;
    }

    @Override
    public N_FactPage getFactPage(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent (2) facts page [" + this.getName() + "]");
        }
        if (factPageRef != factPage.getRef()) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent (3) facts page [" + this.getName() + "] [" + String.valueOf(factPageRef) + "] [" + String.valueOf(factPage.getRef()) + "]");
        }
        return factPage;
    }

    @Override
    public N_FactPage getM2MFactPage() {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing facts page [" + this.getName() + "]");
        }
        return factPage;
    }

    @Override
    protected void doOnDimensionChanged(N_BuildSchemaContext context, S_HollowUpdate hollowUpdate) {
        N_FactPage factPage = this.factPage.get();
        if (factPage != null) {
            factPage.onDimensionChanged(context, this, this.schemaDef, hollowUpdate);
        }
    }

    @Override
    public void onTableRowsProcessingCompleted(N_BuildSchemaContext context, S_FactPageRef factPageRef) {
        OlapLoggers.BUILDER.info((Object)("[facts] table rows processing completed for partition [" + String.valueOf(factPageRef) + "] for facts [" + this.getName() + "] for schema [" + this.getSchemaName() + "]"));
        N_FactPage factPage = this.factPage.get();
        if (factPage != null) {
            factPage.onTableRowsProcessingCompleted(context);
        }
    }

    @Override
    protected void doOnProcessFactsCompleted(N_BuildSchemaContext context) {
        boolean restoring = context.isRestoring();
        OlapLoggers.BUILDER.info((Object)("[facts] process completed [" + this.getName() + "] for schema [" + this.getSchemaName() + "] [restoring:" + restoring + "]"));
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return;
        }
        if (!restoring) {
            this.performDistinctCountProcessing(context, (List<N_FactPage>)new CdSingleItemList((Object)factPage));
        }
    }

    @Override
    protected void doOnIncrLoadProcessFactsCompleted(N_BuildSchemaContext context) {
    }

    @Override
    public OlapScalarEntityFactColumn[] factsColumnForTests__() {
        N_FactPage factPage = this.factPage.get();
        return factPage.getAllColumns();
    }

    @Override
    public boolean measureHasNullsInFactColumns(OlapMeasureMember measure) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return false;
        }
        return factPage.measureHasNullsInFactColumns(measure);
    }

    @Override
    public String sizeInRows() {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return "0";
        }
        return CdStringUtils.formatNice((long)factPage.sizeInRows());
    }

    @Override
    public int sizeInRowsEx() {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return 0;
        }
        return factPage.sizeInRows();
    }

    @Override
    public int partitionCount() {
        return 1;
    }

    @Override
    public boolean hasNulls() {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return false;
        }
        boolean res = factPage.hasNulls();
        return res;
    }

    @Override
    public boolean hasNulls(S_MeasureRef measureRef) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return false;
        }
        boolean res = factPage.hasNulls(measureRef);
        return res;
    }

    @Override
    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(N_MdxRequestContext context, GFContext dtContext, S_FactTupleDef tupleDef, OlapMeasureMember measure, OlapAggregationType aggregationType, S_MeasureDef measureDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return member -> false;
        }
        return factPage.getFastNonEmptyFilter(context, dtContext, tupleDef, measure, aggregationType, measureDef, overwrittenHierarchies, visualTotals, subCubes);
    }

    @Override
    public OlapScalarEntity aggregateTuple(N_MdxRequestContext context, GFContext dtContext, S_FactTupleDef tupleDef, OlapMeasureMember measure, OlapAggregationType aggregationType, S_MeasureDef measureDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapFactsAggregationProcessor processor = N_RegularMeasureGroup.getProcessor(context, dtContext, measure, measureDef, aggregationType, factPage);
        OlapFactsBitmapVisitor bitmap = factPage.createBitmapVisitor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        processor.processingPartitionedFactPage(factPage);
        bitmap.apply(processor);
        OlapScalarEntity res = processor.asScalarEntity();
        return res;
    }

    @Override
    public OlapScalarEntity aggregateTuple(N_MdxRequestContext context, GFContext gfContext, S_FactTupleDef tupleDef, OlapMeasureVectorMember measure, S_MeasureRef[] measureRefs, S_MeasureDef[] measureDefs, OlapAggregationType[] aggregationTypes, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapScalarEntityFactColumn[] columns = factPage.getColumns(measureDefs);
        OlapFactMultiColumnAggregator aggregator = OlapScalarEntityFactColumn.createMultiColumnAggregator(columns, aggregationTypes);
        N_FactPageAggregationHelper dtContext = gfContext.factPageAggregationHelper();
        OlapFactsAggregationProcessor processor = dtContext.createMultiColumnAggrProcessor(factPage, aggregator, columns);
        OlapFactsBitmapVisitor bitmap = factPage.createBitmapVisitor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        processor.processingPartitionedFactPage(factPage);
        bitmap.apply(processor);
        OlapScalarEntity res = processor.asScalarEntity();
        return res;
    }

    @Override
    public OlapScalarEntity aggregateSetTuple(GFContext gfContext, N_SetEvaluatorContext context, S_FactTupleDef tupleDef, OlapAggregationType aggregationType) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapFactsAggregationProcessor processor = N_RegularMeasureGroup.getProcessor(context.getRequestContext(), gfContext, context.getMeasure(), context.getMeasureDef(), aggregationType, factPage);
        N_SetEvaluatorContext.FactPageBitmap factPageBitmap = context.getFactPageBitmap(0);
        OlapFactsBitmapVisitor bitmap = factPageBitmap.createSetBitmapVisitor(context, tupleDef);
        processor.processingPartitionedFactPage(factPageBitmap.factPage);
        bitmap.apply(processor);
        OlapScalarEntity res = processor.asScalarEntity();
        return res;
    }

    private static OlapFactsAggregationProcessor getProcessor(N_MdxRequestContext context, GFContext gfContext, OlapMeasureMember measure, S_MeasureDef measureDef, OlapAggregationType aggregationType, N_FactPage factPage) {
        N_FactPageAggregationHelper dtContext = gfContext.factPageAggregationHelper();
        OlapScalarEntityFactColumn column = factPage.getColumn(measureDef);
        N_MeasureGroup.IFactAggregator aggregator = dtContext.createAggregator(measure, aggregationType, column);
        OlapFactsAggregationProcessor processor = dtContext.createProcessor(gfContext, aggregator, measure, aggregationType, factPage, column);
        return processor;
    }

    @Override
    public long cardinality(N_MdxRequestContext context, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return 0L;
        }
        IFactsBitmapAndTor bitmap = factPage.createGlobalBitmapFor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        if (bitmap.noAdds()) {
            int rowId = factPage.getNumberOfRows();
            return rowId;
        }
        long res = bitmap.cardinality();
        return res;
    }

    @Override
    public boolean isNoEmpty(N_MdxRequestContext context, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return false;
        }
        IFactsBitmapAndTor bitmap = factPage.createGlobalBitmapFor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        if (bitmap.noAdds()) {
            int rowId = factPage.getNumberOfRows();
            boolean res = rowId != 0;
            return res;
        }
        boolean res = bitmap.isNoEmpty();
        return res;
    }

    @Override
    public List<N_SetEvaluatorContext.FactPageBitmap> createSetSeedBitmap(N_MdxRequestContext requestContext, S_FactTupleDef tupleDef, OlapBitSet tupleD, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return Collections.emptyList();
        }
        OlapFactsBitmap bitmap = factPage.createSetSeedBitmap(requestContext, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        return CdSingleItemList.asList((Object)new N_SetEvaluatorContext.FactPageBitmap(tupleD, bitmap, factPage));
    }

    @Override
    public long cardinalitySetTuple(N_SetEvaluatorContext context, S_FactTupleDef tupleDef) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return 0L;
        }
        N_SetEvaluatorContext.FactPageBitmap factPageBitmap = context.getFactPageBitmap(0);
        IFactsBitmapAndTor bitmap = factPageBitmap.createSetBitmap(context, tupleDef);
        if (bitmap.noAdds()) {
            int rowId = factPage.getNumberOfRows();
            return rowId;
        }
        long res = bitmap.cardinality();
        return res;
    }

    @Override
    public boolean isNoEmptySetTuple(N_SetEvaluatorContext context, S_FactTupleDef tupleDef) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return false;
        }
        N_SetEvaluatorContext.FactPageBitmap factPageBitmap = context.getFactPageBitmap(0);
        IFactsBitmapAndTor bitmap = factPageBitmap.createSetBitmap(context, tupleDef);
        if (bitmap.noAdds()) {
            int rowId = factPage.getNumberOfRows();
            boolean res = rowId != 0;
            return res;
        }
        boolean res = bitmap.isNoEmpty();
        return res;
    }

    @Override
    public void fastcrossjoin_preInit(N_FastCrossjoinContext context, OlapTupleDimensionality cjTupleDimensionality) {
        N_FactPage factPage = this.factPage.get();
        if (factPage != null) {
            context.init(factPage, cjTupleDimensionality);
        }
    }

    @Override
    public CjBitmapHelper.CjBitmap fastcrossjoin_init(N_FastCrossjoinContext context, OlapTupleDimensionality cjTupleDimensionality, S_FactTuplesDef tuples, @Nullable CjBitmapHelper.CjBitmap tupleFilter, @Nullable CjBitmapHelper.CjBitmap newReducingBitmap) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return CjBitmapHelper.createBitmapEmptyReadOnly();
        }
        return this.fastcrossjoin_init(context, factPage, cjTupleDimensionality, tuples, tupleFilter, newReducingBitmap);
    }

    @Override
    public CjBitmapHelper.CjTupleListReducer fastcrossjoin_reduce(N_FastCrossjoinContext context, S_NonEmptyBehavior nonEmptyBehavior, boolean isfcjReduce, int setIndex, CjBitmapHelper.CjTupleListReducer tuplesReducer, N_FastCj_Cache filterMembers, @Nullable CjBitmapHelper.CjTupleListReducer newReducingBitmap) {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return CjBitmapHelper.createBitmapEmptyReadOnly();
        }
        return this.fastcrossjoin_reduce(context, nonEmptyBehavior, isfcjReduce, factPage, setIndex, tuplesReducer, filterMembers, newReducingBitmap);
    }

    @Override
    public void fast_crossjoin_addToGlobalFilter(N_FastCrossjoinContext context, S_FactTuplesDef tuples, CjBitmapHelper.CjBitmap bitmap) {
        N_FactPage factPage = this.factPage.get();
        if (factPage != null) {
            this.fast_crossjoin_addToGlobalFilter(context, factPage, tuples, bitmap);
        }
    }

    @Override
    public long getRowCount() {
        N_FactPage factPage = this.factPage.get();
        if (factPage == null) {
            return 0L;
        }
        return factPage.getNumberOfRows();
    }

    @Override
    public void fastcrossjoin_initTable(N_FastCrossjoinContext context) {
        N_FactPage factPage = this.factPage.get();
        if (factPage != null) {
            context.initCjTableContext(factPage);
        }
    }
}

