/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.common.collection.CdArrayList;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.context.N_FactPageAggregationHelper;
import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.context.N_SetEvaluatorContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.facts.N_MultiColumnPartitionedProcessor;
import crazydev.iccube.cluster.node.facts.N_PartitionedBitmap;
import crazydev.iccube.cluster.node.facts.N_PartitionedProcessor;
import crazydev.iccube.cluster.node.facts.N_SingleColumnPartitionedProcessor;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.node.schema.N_FastCj_Cache;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextKind;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsAggregationProcessor;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapVisitor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Nullable;

public class N_PartitionedMeasureGroup
extends N_MeasureGroup {
    private final Map<S_FactPageRef, N_FactPage> factPages = new ConcurrentHashMap<S_FactPageRef, N_FactPage>();
    private final List<N_FactPage> factPages_ = new CopyOnWriteArrayList<N_FactPage>();

    protected N_PartitionedMeasureGroup(S_BuildSchemaContextKind buildMode, S_SchemaDef schemaDef, S_CubeDef cubeDef, S_MeasureGroupDef measureGroupDef) {
        super(buildMode, schemaDef, cubeDef, measureGroupDef);
    }

    @Override
    public void cleanupResources(OlapFileCleaner fileCleaner) {
        for (N_FactPage factPage : this.factPages_) {
            factPage.cleanupResources(fileCleaner);
        }
    }

    @Override
    public void savePartitionsContent(N_BackupContext context, OlapEngineBackupConfiguration configuration, File dir) throws IOException {
        for (N_FactPage partition : this.factPages_) {
            partition.save(context, configuration, dir);
        }
    }

    @Override
    protected N_FactPage getFactPage(int backupID, String nameForStats) {
        for (N_FactPage factPage : this.factPages_) {
            if (factPage.getBackupID() != backupID) continue;
            if (!factPage.getNameForStats().equals(nameForStats)) {
                throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent fact page when restoring partitions [" + this.getName() + "] [" + backupID + "] [" + nameForStats + "] : expected [" + factPage.getNameForStats() + "]");
            }
            return factPage;
        }
        throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page when restoring partitions [" + this.getName() + "] [" + backupID + "] [" + nameForStats + "]");
    }

    @Override
    public void clearOnIncrLoadFullReload(OlapFileCleaner fileCleaner) {
        OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.cubeDef.getSchemaName() + "] cube [" + this.cubeDef.getName() + "] facts [" + this.getMeasureGroupName() + "] clear-on-incr-load-full-reload (node:partitioned)"));
        for (N_FactPage page : this.factPages_) {
            page.cleanupResources(fileCleaner);
        }
        this.factPages_.clear();
        this.factPages.clear();
    }

    @Override
    public void unloadPartitions(OlapFileCleaner fileCleaner, List<S_FactPageRef> partitionRefs) {
        for (S_FactPageRef partitionRef : partitionRefs) {
            N_FactPage factPage = this.factPages.remove(partitionRef);
            if (factPage != null) {
                OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.cubeDef.getSchemaName() + "] cube [" + this.cubeDef.getName() + "] facts [" + this.getMeasureGroupName() + "] unloading partition [" + factPage.getNameForStats() + "]"));
                this.factPages_.remove(factPage);
                factPage.cleanupResources(fileCleaner);
                continue;
            }
            OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.cubeDef.getSchemaName() + "] cube [" + this.cubeDef.getName() + "] facts [" + this.getMeasureGroupName() + "] unloading partition [" + String.valueOf(partitionRef) + "] IGNORED"));
        }
    }

    @Override
    public void unloadMeasureGroup(OlapFileCleaner fileCleaner) {
        if (this.factPages.isEmpty()) {
            OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.cubeDef.getSchemaName() + "] cube [" + this.cubeDef.getName() + "] facts [" + this.getMeasureGroupName() + "] unloading IGNORED"));
            return;
        }
        for (N_FactPage factPage : this.factPages_) {
            OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.cubeDef.getSchemaName() + "] cube [" + this.cubeDef.getName() + "] facts [" + this.getMeasureGroupName() + "] unloading partition [" + factPage.getNameForStats() + "]"));
            this.factPages.remove(factPage.getRef());
            factPage.cleanupResources(fileCleaner);
        }
        this.factPages_.clear();
    }

    @Override
    public void adoptPartitions(OlapFileCleaner fileCleaner, N_MeasureGroup loadedMeasureGroup, @Nullable S_FactPageRef partition, S_FactPageRef loadedPartition) {
        if (!(loadedMeasureGroup instanceof N_PartitionedMeasureGroup)) {
            throw new RuntimeException("internal error: [" + this.getName() + "] (adopt-partitions) inconsistent usage (" + this.getClass().getSimpleName() + "/" + loadedMeasureGroup.getClass().getSimpleName() + ")");
        }
        this.doAdoptPartitions(fileCleaner, (N_PartitionedMeasureGroup)loadedMeasureGroup, partition, loadedPartition);
    }

    private void doAdoptPartitions(OlapFileCleaner fileCleaner, N_PartitionedMeasureGroup loadedMeasureGroup, @Nullable S_FactPageRef partition, S_FactPageRef loadedPartition) {
        N_FactPage factPage = partition != null ? this.factPages.get(partition) : null;
        N_FactPage loadedFactPage = loadedMeasureGroup.factPages.get(loadedPartition);
        this.preValidateAdoptPartition(partition, factPage, loadedPartition, loadedFactPage);
        if (factPage != null) {
            this.factPages.remove(factPage.getRef());
            this.factPages_.remove(factPage);
            factPage.cleanupResources(fileCleaner);
        }
        this.factPages.put(loadedFactPage.getRef(), loadedFactPage);
        this.factPages_.add(loadedFactPage);
        loadedMeasureGroup.factPages.remove(loadedFactPage.getRef());
        loadedMeasureGroup.factPages_.remove(loadedFactPage);
    }

    @Override
    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info, S_FactPageRef partitionRef) {
        N_FactPage factPage = this.factPages.get(partitionRef);
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page [" + this.getName() + "] [" + String.valueOf(partitionRef) + "]");
        }
        factPage.getInformationForPerformanceTests(info);
    }

    @Override
    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies, S_FactPageRef partitionRef) throws IOException {
        N_FactPage factPage = this.factPages.get(partitionRef);
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page [" + this.getName() + "] [" + String.valueOf(partitionRef) + "]");
        }
        factPage.dumpIndex(out, hierarchies);
    }

    @Override
    public void createPartitionStats(OlapStatsContext context, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, S_FactPageRef partitionRef, Set<OlapDimension> dimensions__) {
        N_FactPage factPage = this.factPages.get(partitionRef);
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page [" + this.getName() + "] [" + String.valueOf(partitionRef) + "]");
        }
        factPage.createStats(context, statsPerLevel, partitionsStats, dimensions__);
    }

    @Override
    public void createIncrLoadPartitionStats(List<OlapFactsPartitionStats> partitionsStats, S_FactPageRef partitionRef) {
        N_FactPage factPage = this.factPages.get(partitionRef);
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing fact page [" + this.getName() + "] [" + String.valueOf(partitionRef) + "]");
        }
        factPage.createIncrLoadStats(partitionsStats);
    }

    @Override
    public void onSchemaPartitionsLoaded() {
        if (!this.factPages_.isEmpty()) {
            for (N_FactPage factPage : this.factPages_) {
                OlapLoggers.BUILDER.error((Object)("[partition] remaining loaded partition [" + this.schemaDef.getName() + "] [" + this.cubeDef.getName() + "] [" + this.measureGroupDef.getName() + "] [" + factPage.getName() + "]"));
            }
            throw new RuntimeException("internal error: (P) remaining loaded partitions for schema [" + this.schemaDef.getName() + "] (check log files for more details)");
        }
    }

    @Override
    public void onSchemaPartitionsLoadedOnError(OlapFileCleaner fileCleaner) {
        this.cleanupResources(fileCleaner);
        this.factPages.clear();
        this.factPages_.clear();
    }

    @Override
    public N_FactPage createFactPage(N_BuildFactContext context, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef, boolean empty, int backupID, String nameForStats) {
        N_FactPage factPage = this.factPages.get(factPageRef);
        if (factPage != null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent (1) facts page [" + this.getName() + " / " + String.valueOf(factPageRef) + " / " + String.valueOf(factPage.getRef()) + "]");
        }
        S_CubeDef cubeDef = this.schemaDef.resolveCube(cubeRef);
        S_MeasureGroupDef measureGroupDef = cubeDef.getMeasureGroup(measureGroupRef);
        factPage = new N_FactPage(context, this, factPageRef, this.getFactsColumnListFactory(), this.getFactsBitmapContainerFactory(), backupID, nameForStats, nameForStats, this.schemaDef, cubeDef, measureGroupDef, empty);
        this.factPages.put(factPageRef, factPage);
        this.factPages_.add(factPage);
        return factPage;
    }

    @Override
    public N_FactPage getFactPage(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        N_FactPage factPage = this.factPages.get(factPageRef);
        if (factPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent (2) facts page [" + this.getName() + " / " + String.valueOf(factPageRef) + "]");
        }
        return factPage;
    }

    @Override
    public N_FactPage getM2MFactPage() {
        if (this.factPages_.size() != 1) {
            throw new RuntimeException("internal error: missing only facts page in measure-group [" + this.getName() + "] in schema [" + this.schemaDef.getName() + "]");
        }
        N_FactPage page = this.factPages_.get(0);
        return page;
    }

    @Override
    protected void doOnDimensionChanged(N_BuildSchemaContext context, S_HollowUpdate hollowUpdate) {
        for (N_FactPage page : this.factPages.values()) {
            page.onDimensionChanged(context, this, this.schemaDef, hollowUpdate);
        }
    }

    @Override
    public void onTableRowsProcessingCompleted(N_BuildSchemaContext context, S_FactPageRef factPageRef) {
        OlapLoggers.BUILDER.info((Object)("[facts] table rows processing completed for partition [" + String.valueOf(factPageRef) + "] for facts [" + this.getName() + "] for schema [" + this.getSchemaName() + "]"));
        N_FactPage factPage = this.factPages.get(factPageRef);
        if (factPage != null) {
            factPage.onTableRowsProcessingCompleted(context);
        }
    }

    @Override
    protected void doOnProcessFactsCompleted(N_BuildSchemaContext context) {
        boolean restoring = context.isRestoring();
        OlapLoggers.BUILDER.info((Object)("[facts] process completed [" + this.getName() + "] for schema [" + this.getSchemaName() + "] [restoring:" + restoring + "]"));
        if (!restoring) {
            this.performDistinctCountProcessing(context, this.factPages_);
        }
    }

    @Override
    protected void doOnIncrLoadProcessFactsCompleted(N_BuildSchemaContext context) {
    }

    @Override
    public OlapScalarEntityFactColumn[] factsColumnForTests__() {
        throw new RuntimeException("internal error: cannot retrieve facts column");
    }

    @Override
    public boolean measureHasNullsInFactColumns(OlapMeasureMember measure) {
        int pageCount = this.factPages.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            N_FactPage factPage = this.factPages_.get(ii);
            if (!factPage.measureHasNullsInFactColumns(measure)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String sizeInRows() {
        int sizeInRows = 0;
        int pageCount = this.factPages.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            int partitionSize = this.factPages_.get(ii).sizeInRows();
            sizeInRows += partitionSize;
        }
        return CdStringUtils.formatNice((long)sizeInRows) + " (" + pageCount + ")";
    }

    @Override
    public int sizeInRowsEx() {
        int sizeInRows = 0;
        int pageCount = this.factPages.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            int partitionSize = this.factPages_.get(ii).sizeInRows();
            sizeInRows += partitionSize;
        }
        return sizeInRows;
    }

    @Override
    public int partitionCount() {
        return this.factPages.size();
    }

    @Override
    public boolean hasNulls() {
        int pageCount = this.factPages.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            N_FactPage factPage = this.factPages_.get(ii);
            if (!factPage.hasNulls()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNulls(S_MeasureRef measureRef) {
        int pageCount = this.factPages.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            N_FactPage factPage = this.factPages_.get(ii);
            if (!factPage.hasNulls(measureRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(N_MdxRequestContext context, GFContext dtContext, S_FactTupleDef tupleDef, OlapMeasureMember measure, OlapAggregationType aggregationType, S_MeasureDef measureDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        if (this.factPages_.isEmpty()) {
            return member -> false;
        }
        int pageCount = this.factPages_.size();
        IOlapIteratorFilter[] filters = new IOlapIteratorFilter[pageCount];
        for (int ii = 0; ii < pageCount; ++ii) {
            N_FactPage factPage = this.factPages_.get(ii);
            filters[ii] = factPage.getFastNonEmptyFilter(context, dtContext, tupleDef, measure, aggregationType, measureDef, overwrittenHierarchies, visualTotals, subCubes);
        }
        return member -> {
            for (IOlapIteratorFilter filter : filters) {
                if (!filter.accept(member)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public OlapScalarEntity aggregateTuple(N_MdxRequestContext context, GFContext dtContext, S_FactTupleDef tupleDef, OlapMeasureMember measure, OlapAggregationType aggregationType, S_MeasureDef measureDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        if (this.factPages_.isEmpty()) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapFactsBitmapVisitor[] bitmapVisitors = new OlapFactsBitmapVisitor[this.factPages_.size()];
        int pageCount = this.factPages_.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            OlapFactsBitmapVisitor visitor;
            N_FactPage factPage = this.factPages_.get(ii);
            bitmapVisitors[ii] = visitor = factPage.createBitmapVisitor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        }
        N_PartitionedBitmap bitmap = new N_PartitionedBitmap(bitmapVisitors, this.factPages_);
        N_SingleColumnPartitionedProcessor processor = new N_SingleColumnPartitionedProcessor(context, dtContext, this.factPages_, measure, aggregationType, measureDef);
        bitmap.apply(processor);
        OlapScalarEntity res = ((N_PartitionedProcessor)processor).asScalarEntity();
        return res;
    }

    @Override
    public OlapScalarEntity aggregateSetTuple(GFContext gfContext, N_SetEvaluatorContext context, S_FactTupleDef tupleDef, OlapAggregationType aggregationType) {
        if (this.factPages_.isEmpty()) {
            return OlapEmptyEntity.INSTANCE;
        }
        S_MeasureDef measureDef = context.getMeasureDef();
        N_MeasureGroup.IFactAggregator aggregator = null;
        int count = context.getFactPageBitmapCount();
        for (int i = 0; i < count; ++i) {
            N_SetEvaluatorContext.FactPageBitmap factPageBitmap = context.getFactPageBitmap(i);
            OlapFactsBitmapVisitor partitionBitmap = factPageBitmap.createSetBitmapVisitor(context, tupleDef);
            OlapScalarEntityFactColumn column = factPageBitmap.getColumn(measureDef);
            N_FactPageAggregationHelper dtContext = gfContext.factPageAggregationHelper();
            if (aggregator == null) {
                aggregator = dtContext.createAggregator(context.getMeasure(), aggregationType, column);
            }
            OlapFactsAggregationProcessor processor = dtContext.createProcessor(gfContext, aggregator, context.getMeasure(), aggregationType, factPageBitmap.factPage, column);
            processor.processingPartitionedFactPage(factPageBitmap.factPage);
            partitionBitmap.apply(processor);
        }
        if (aggregator != null) {
            OlapScalarEntity res = aggregator.asScalarEntity();
            return res;
        }
        return OlapEmptyEntity.INSTANCE;
    }

    @Override
    public OlapScalarEntity aggregateTuple(N_MdxRequestContext context, GFContext gfContext, S_FactTupleDef tupleDef, OlapMeasureVectorMember measure, S_MeasureRef[] measureRefs, S_MeasureDef[] measureDefs, OlapAggregationType[] aggregationTypes, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        if (this.factPages_.isEmpty()) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapFactsBitmapVisitor[] bitmapVisitors = new OlapFactsBitmapVisitor[this.factPages_.size()];
        int pageCount = this.factPages_.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            OlapFactsBitmapVisitor visitor;
            N_FactPage factPage = this.factPages_.get(ii);
            bitmapVisitors[ii] = visitor = factPage.createBitmapVisitor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        }
        N_PartitionedBitmap bitmap = new N_PartitionedBitmap(bitmapVisitors, this.factPages_);
        N_MultiColumnPartitionedProcessor processor = new N_MultiColumnPartitionedProcessor(gfContext, this.factPages_, measureDefs, aggregationTypes);
        bitmap.apply(processor);
        OlapScalarEntity res = ((N_PartitionedProcessor)processor).asScalarEntity();
        return res;
    }

    @Override
    public long cardinality(N_MdxRequestContext context, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        if (this.factPages_.isEmpty()) {
            return 0L;
        }
        long cardinality = 0L;
        int pageCount = this.factPages_.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            N_FactPage factPage = this.factPages_.get(ii);
            IFactsBitmapAndTor bitmap = factPage.createGlobalBitmapFor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
            if (bitmap.noAdds()) {
                cardinality += (long)factPage.getNumberOfRows();
                continue;
            }
            cardinality += bitmap.cardinality();
        }
        return cardinality;
    }

    @Override
    public boolean isNoEmpty(N_MdxRequestContext context, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        if (this.factPages_.isEmpty()) {
            return false;
        }
        int pageCount = this.factPages_.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            boolean res;
            int rowId;
            N_FactPage factPage = this.factPages_.get(ii);
            IFactsBitmapAndTor andTor = factPage.createGlobalBitmapFor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
            if (!(andTor.noAdds() ? (rowId = factPage.getNumberOfRows()) != 0 : (res = andTor.isNoEmpty()))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public List<N_SetEvaluatorContext.FactPageBitmap> createSetSeedBitmap(N_MdxRequestContext requestContext, S_FactTupleDef tupleDef, OlapBitSet tupleD, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        if (this.factPages_.isEmpty()) {
            return Collections.emptyList();
        }
        CdArrayList bitmaps = new CdArrayList();
        int pageCount = this.factPages_.size();
        for (int ii = 0; ii < pageCount; ++ii) {
            N_FactPage factPage = this.factPages_.get(ii);
            OlapFactsBitmap bitmap = factPage.createSetSeedBitmap(requestContext, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
            if (bitmap != null && !bitmap.isNoEmpty()) continue;
            bitmaps.add((Object)new N_SetEvaluatorContext.FactPageBitmap(tupleD, bitmap, factPage));
        }
        return bitmaps;
    }

    @Override
    public long cardinalitySetTuple(N_SetEvaluatorContext context, S_FactTupleDef tupleDef) {
        if (this.factPages_.isEmpty()) {
            return 0L;
        }
        long cardinality = 0L;
        int count = context.getFactPageBitmapCount();
        for (int i = 0; i < count; ++i) {
            N_SetEvaluatorContext.FactPageBitmap factPageBitmap = context.getFactPageBitmap(i);
            IFactsBitmapAndTor bitmap = factPageBitmap.createSetBitmap(context, tupleDef);
            if (bitmap.noAdds()) {
                cardinality += (long)factPageBitmap.getNumberOfRows();
                continue;
            }
            cardinality += bitmap.cardinality();
        }
        return cardinality;
    }

    @Override
    public boolean isNoEmptySetTuple(N_SetEvaluatorContext context, S_FactTupleDef tupleDef) {
        if (this.factPages_.isEmpty()) {
            return false;
        }
        int count = context.getFactPageBitmapCount();
        for (int i = 0; i < count; ++i) {
            boolean res;
            int rowId;
            N_SetEvaluatorContext.FactPageBitmap factPageBitmap = context.getFactPageBitmap(i);
            IFactsBitmapAndTor bitmap = factPageBitmap.createSetBitmap(context, tupleDef);
            if (!(bitmap.noAdds() ? (rowId = factPageBitmap.getNumberOfRows()) != 0 : (res = bitmap.isNoEmpty()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fastcrossjoin_preInit(N_FastCrossjoinContext context, OlapTupleDimensionality cjTupleDimensionality) {
        for (N_FactPage factPage : this.factPages_) {
            context.init(factPage, cjTupleDimensionality);
        }
    }

    @Override
    public CjBitmapHelper.CjBitmap fastcrossjoin_init(N_FastCrossjoinContext context, OlapTupleDimensionality cjTupleDimensionality, S_FactTuplesDef tuples, @Nullable CjBitmapHelper.CjBitmap tupleFilter, @Nullable CjBitmapHelper.CjBitmap newReducingBitmap) {
        N_FactPage factPage;
        Iterator<N_FactPage> iterator = this.factPages_.iterator();
        while (iterator.hasNext() && (newReducingBitmap = this.fastcrossjoin_init(context, factPage = iterator.next(), cjTupleDimensionality, tuples, tupleFilter, newReducingBitmap)).cardinality() != (long)tuples.size()) {
        }
        return newReducingBitmap;
    }

    @Override
    public CjBitmapHelper.CjTupleListReducer fastcrossjoin_reduce(N_FastCrossjoinContext context, S_NonEmptyBehavior nonEmptyBehavior, boolean isfcjReduce, int setIndex, CjBitmapHelper.CjTupleListReducer tuplesReducer, @Nullable N_FastCj_Cache filterMembers, @Nullable CjBitmapHelper.CjTupleListReducer newReducingBitmap) {
        for (N_FactPage factPage : this.factPages_) {
            newReducingBitmap = this.fastcrossjoin_reduce(context, nonEmptyBehavior, isfcjReduce, factPage, setIndex, tuplesReducer, filterMembers, newReducingBitmap);
            if (tuplesReducer.cardinality() != newReducingBitmap.cardinality()) continue;
            break;
        }
        return newReducingBitmap;
    }

    @Override
    public void fast_crossjoin_addToGlobalFilter(N_FastCrossjoinContext context, S_FactTuplesDef tuples, CjBitmapHelper.CjBitmap bitmap) {
        for (N_FactPage factPage : this.factPages_) {
            this.fast_crossjoin_addToGlobalFilter(context, factPage, tuples, bitmap);
        }
    }

    @Override
    public void fastcrossjoin_initTable(N_FastCrossjoinContext context) {
        for (N_FactPage factPage : this.factPages_) {
            context.initCjTableContext(factPage);
        }
    }

    @Override
    public long getRowCount() {
        long rowCount = 0L;
        for (N_FactPage factPage : this.factPages_) {
            rowCount += (long)factPage.getNumberOfRows();
        }
        return rowCount;
    }
}

