/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.iccube.cluster.node.context.N_FactPageAggregationHelper;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_PartitionedProcessor;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsAggregationProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.multicolumn.OlapFactMultiColumnAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import java.util.List;

public class N_MultiColumnPartitionedProcessor
extends N_PartitionedProcessor {
    private final S_MeasureDef[] measureDefs;
    private final OlapAggregationType[] aggregationTypes;
    private OlapFactMultiColumnAggregator aggregator;

    public N_MultiColumnPartitionedProcessor(GFContext dtContext, List<N_FactPage> partitions, S_MeasureDef[] measureDefs, OlapAggregationType[] aggregationTypes) {
        super(dtContext, partitions);
        this.measureDefs = measureDefs;
        this.aggregationTypes = aggregationTypes;
    }

    @Override
    public OlapFactsAggregationProcessor createPartitionProcessor(int partitionIdx) {
        N_FactPage partition = (N_FactPage)this.partitions.get(partitionIdx);
        OlapScalarEntityFactColumn[] columns = partition.getColumns(this.measureDefs);
        if (this.aggregator == null) {
            this.aggregator = OlapScalarEntityFactColumn.createMultiColumnAggregator(columns, this.aggregationTypes);
        }
        N_FactPageAggregationHelper dtContext = this.gfContext.factPageAggregationHelper();
        OlapFactsAggregationProcessor processor = dtContext.createMultiColumnAggrProcessor(partition, this.aggregator, columns);
        return processor;
    }

    @Override
    public OlapScalarEntity asScalarEntity() {
        if (this.aggregator != null) {
            OlapScalarEntity res = this.aggregator.asScalarEntity();
            return res;
        }
        return OlapEmptyEntity.INSTANCE;
    }
}

