/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.shared.schema.S_BitSetTupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_DefaultsDef;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapOne;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapZero;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class N_MdxRequestBitmapCache {
    private final N_FactBitmapContainer bitmapContainer;
    private final Map<Key, OlapFactsBitmap> filterBitmap = new ConcurrentHashMap<Key, OlapFactsBitmap>();
    private final Map<S_TupleDimensionality, OlapFactsBitmap> slicerBitmaps = new ConcurrentHashMap<S_TupleDimensionality, OlapFactsBitmap>();
    private final Map<S_TupleDimensionality, OlapFactsBitmap> subSelectBitmaps = new ConcurrentHashMap<S_TupleDimensionality, OlapFactsBitmap>();
    private final Map<S_RequestSubCubeRef, OlapFactsBitmap> clusterCache = new ConcurrentHashMap<S_RequestSubCubeRef, OlapFactsBitmap>();
    @Nullable
    private final S_FactSubCube slicer;
    @Nullable
    private final S_FactSubCube subSelect;
    private final boolean isEmpty;
    private final OlapFactsBitmap permBitmap;
    @Nullable
    private final S_DefaultsDef defaults;
    private final S_TupleDimensionality slicerAndSubDim;
    private S_BitSetTupleDimensionality defaultDim;

    public N_MdxRequestBitmapCache(N_MdxRequestContext mdxRequestContext, N_FactBitmapContainer bitmapContainer) {
        this.bitmapContainer = bitmapContainer;
        this.defaultDim = null;
        this.defaults = this.forContainer(mdxRequestContext.getDefaults(), bitmapContainer);
        this.slicer = mdxRequestContext.getSlicer();
        this.subSelect = mdxRequestContext.getSubSelect();
        this.permBitmap = mdxRequestContext.getOrCreatePermissionBitmap(bitmapContainer);
        boolean bl = this.isEmpty = this.slicer == null && this.subSelect == null && this.defaults == null;
        this.slicerAndSubDim = this.defaults == null ? S_BitSetTupleDimensionality.ZERO : this.union(this.slicer == null ? null : this.slicer.getTupleDimensionality(), this.subSelect == null ? null : this.subSelect.getTupleDimensionality());
    }

    public S_TupleDimensionality getSlicerAndSubDim() {
        return this.slicerAndSubDim;
    }

    private S_TupleDimensionality union(@Nullable S_TupleDimensionality dim1, @Nullable S_TupleDimensionality dim2) {
        if (dim1 == null) {
            return dim2 == null ? S_BitSetTupleDimensionality.ZERO : dim2;
        }
        if (dim2 == null) {
            return dim1;
        }
        return dim1.union(dim2);
    }

    @Nullable
    private S_DefaultsDef forContainer(@Nullable S_DefaultsDef defaults, N_FactBitmapContainer bitmapContainer) {
        S_MemberDef s_memberDef;
        int i;
        if (defaults == null) {
            return null;
        }
        List<S_MemberDef> members = defaults.getMembers();
        int indexingMembers = 0;
        for (i = 0; i < members.size(); ++i) {
            s_memberDef = members.get(i);
            if (!bitmapContainer.isIndexing(s_memberDef)) continue;
            ++indexingMembers;
        }
        if (indexingMembers == 0) {
            return null;
        }
        if (indexingMembers == members.size()) {
            this.defaultDim = defaults.getTupleDimensionality();
        } else {
            this.defaultDim = new S_BitSetTupleDimensionality();
            for (i = 0; i < members.size(); ++i) {
                s_memberDef = members.get(i);
                if (!bitmapContainer.isIndexing(s_memberDef)) continue;
                this.defaultDim.set(s_memberDef.getHierIdx());
            }
        }
        return defaults;
    }

    public void addToTor(N_MdxRequestContext context, IFactsBitmapAndTor andtor, S_TupleDimensionality tupleDimensionality, @Nullable S_TupleDimensionalityDef overwrittenTupleDimensionality) {
        if (this.isEmpty) {
            andtor.add(this.permBitmap);
            return;
        }
        S_TupleDimensionality subSelectTupleDim = overwrittenTupleDimensionality == null ? S_BitSetTupleDimensionality.ZERO : overwrittenTupleDimensionality.getTupleDimensionality();
        S_TupleDimensionality slicerDimensionality = this.intersect(tupleDimensionality, this.slicer);
        subSelectTupleDim = this.intersect(subSelectTupleDim, this.subSelect);
        S_TupleDimensionality defaultDimensionality = this.defaultDim(tupleDimensionality);
        Key key = Key.createKey(slicerDimensionality, subSelectTupleDim, defaultDimensionality);
        OlapFactsBitmap bitmap = this.filterBitmap.computeIfAbsent(key, k -> this.createFilterBitmap(context, (Key)k));
        andtor.add(bitmap);
    }

    @Nullable
    private S_TupleDimensionality defaultDim(S_TupleDimensionality tupleDimensionality) {
        if (this.defaults == null || tupleDimensionality == null) {
            return null;
        }
        S_TupleDimensionality intersect = this.defaultDim.and(this.slicerAndSubDim.union(tupleDimensionality));
        return intersect.cardinality() == this.defaultDim.cardinality() ? null : intersect;
    }

    private OlapFactsBitmap createFilterBitmap(N_MdxRequestContext context, Key key) {
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] create-filter-bitmap started");
        IFactsBitmapAndTor andtor = OlapFactsBitmapAggregation.facts_createBitmapAndTor();
        boolean isEmpty = true;
        S_TupleDimensionality slicerTupleDim = key.slicer;
        S_TupleDimensionality subSelectTupleDim = key.subselect;
        S_TupleDimensionality defaultsTupleDim = key.defaults;
        OlapFactsBitmap slicerbitmap = this.addFilter(context, this.slicerBitmaps, slicerTupleDim, this.slicer);
        OlapFactsBitmap ssbitmap = this.addFilter(context, this.subSelectBitmaps, subSelectTupleDim, this.subSelect);
        if (slicerbitmap != null) {
            isEmpty = false;
            andtor.add(slicerbitmap);
        }
        if (ssbitmap != null) {
            isEmpty = false;
            andtor.add(ssbitmap);
        }
        if (this.permBitmap != null) {
            isEmpty = false;
            andtor.add(this.permBitmap);
        }
        if (defaultsTupleDim != null) {
            List<S_MemberDef> defaultMembers = this.defaults.getMembers();
            for (int i = 0; i < defaultMembers.size(); ++i) {
                OlapFactsBitmap olapBitmap;
                S_MemberDef s_memberDef = defaultMembers.get(i);
                if (defaultsTupleDim.isIn(s_memberDef) || (olapBitmap = this.bitmapContainer.getForRead(s_memberDef)) == null) continue;
                andtor.add(olapBitmap);
                isEmpty = false;
            }
        }
        OlapFactsBitmap bitmap = isEmpty ? OlapFactsBitmapOne.INSTANCE : andtor.facts_asBitmap();
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] create-filter-bitmap completed");
        return bitmap;
    }

    private S_TupleDimensionality intersect(S_TupleDimensionality tupleDim, @Nullable S_FactSubCube subcube) {
        return subcube == null || tupleDim.isEmpty() ? S_BitSetTupleDimensionality.ZERO : tupleDim.and(subcube.getTupleDimensionality());
    }

    @Nullable(value="if the filter does not apply")
    private @Nullable(value="if the filter does not apply") OlapFactsBitmap addFilter(N_MdxRequestContext requestContext, Map<S_TupleDimensionality, OlapFactsBitmap> bitmapCache, S_TupleDimensionality tupleDimensionality, @Nullable S_FactSubCube subCube) {
        if (subCube == null) {
            return null;
        }
        OlapFactsBitmap bitmap = bitmapCache.computeIfAbsent(tupleDimensionality, dim -> {
            OlapBitmapTor tor = subCube.createBitmapTor(requestContext, this.bitmapContainer, tupleDimensionality);
            return tor.isEmpty() ? OlapFactsBitmapOne.INSTANCE : tor.solve();
        });
        return bitmap;
    }

    void addToTor(N_MdxRequestContext context, IFactsBitmapAndTor andtor, @Nullable List<S_RequestSubCubeDef> subCubes) {
        if (subCubes == null) {
            return;
        }
        for (int i = 0; i < subCubes.size(); ++i) {
            S_RequestSubCubeDef factSubCubeDef = subCubes.get(i);
            S_RequestSubCubeRef factSubCubeRef = factSubCubeDef.getRef();
            OlapFactsBitmap bitmap = this.clusterCache.computeIfAbsent(factSubCubeRef, key -> {
                S_FactSubCube factSubCube = factSubCubeDef.getSubCube();
                OlapBitmapTor tor = factSubCube.createBitmapTor(context, this.bitmapContainer, null);
                return tor.isEmpty() ? OlapFactsBitmapZero.INSTANCE : tor.solve();
            });
            andtor.add(bitmap);
        }
    }

    boolean emptyDefaults() {
        return this.defaults == null;
    }

    private static class Key {
        private static Key ZERO = new Key(S_BitSetTupleDimensionality.ZERO, S_BitSetTupleDimensionality.ZERO, null);
        private final S_TupleDimensionality slicer;
        private final S_TupleDimensionality subselect;
        @Nullable
        private final S_TupleDimensionality defaults;

        static Key createKey(S_TupleDimensionality slicer, S_TupleDimensionality subselect, @Nullable S_TupleDimensionality defaults) {
            if (defaults == null && slicer == subselect && subselect == S_BitSetTupleDimensionality.ZERO) {
                return ZERO;
            }
            return new Key(slicer, subselect, defaults);
        }

        private Key(S_TupleDimensionality slicer, S_TupleDimensionality subselect, @Nullable S_TupleDimensionality defaults) {
            this.slicer = slicer;
            this.subselect = subselect;
            this.defaults = defaults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.slicer.equals(key.slicer) && this.subselect.equals(key.subselect) && (this.defaults != null ? this.defaults.equals(key.defaults) : key.defaults == null);
        }

        public int hashCode() {
            int result = this.slicer.hashCode();
            result = 31 * result + this.subselect.hashCode();
            result = 31 * result + (this.defaults != null ? this.defaults.hashCode() : 0);
            return result;
        }
    }
}

