/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.common.utils.CdMutableBoolean;
import crazydev.common.utils.CdMutableInt;
import crazydev.iccube.cluster.node.facts.IBaseFastNoEmpty;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_IFastNoEmpty;
import crazydev.iccube.cluster.node.schema.N_FastCj_Cache;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBuffer;
import crazydev.iccube.olap.index.bitmap.tor.OlapAbstractAndtor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.BitmapFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.buffer.RoaringBufferFastAggregation;

public class N_FastCrossjoinAndTorTupleRoaring
implements N_IFastNoEmpty {
    private final Function<Integer, S_FactTupleDef> bitmapCache;
    private List<OlapScalarEntityFactColumn> measureColumns;
    private final OlapFactsBitmap[] arr;
    private final int startTuplePos;
    private final boolean hasOneBitmap;
    private boolean isZero = false;
    private boolean addAndClearCalled = false;
    private boolean addAndClearIsZero = false;

    N_FastCrossjoinAndTorTupleRoaring(Function<Integer, S_FactTupleDef> bitmapCache, N_FactPage factPage, List<OlapScalarEntityFactColumn> measureColumns, OlapFactsBitmap globalBitmap, @Nullable N_FastCj_Cache tuple, int tupleSize) {
        this.bitmapCache = bitmapCache;
        this.measureColumns = measureColumns;
        CdMutableBoolean hasBitmaps = new CdMutableBoolean(false);
        ArrayList<OlapFactsBitmap> list = new ArrayList<OlapFactsBitmap>();
        if (tuple != null) {
            tuple.getFilterMembers().forEach((memberType, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
                OlapFactsBitmap bitmap;
                if (memberType.isStandard() && (bitmap = factPage.getForRead(hierarchyIndex, memberIndex)) != null) {
                    if (bitmap.isEmpty()) {
                        this.isZero = true;
                    } else {
                        list.add(bitmap);
                    }
                }
                hasBitmaps.value = true;
            });
        }
        if (this.isZero) {
            this.arr = null;
            this.hasOneBitmap = false;
            this.startTuplePos = 0;
            return;
        }
        if (globalBitmap.isOne()) {
            this.hasOneBitmap = true;
        } else {
            this.hasOneBitmap = false;
            list.add(globalBitmap);
        }
        this.arr = new OlapFactsBitmap[list.size() + tupleSize];
        if (list.size() > 1) {
            ImmutableRoaringBitmap[] fixedBitmaps = new ImmutableRoaringBitmap[list.size()];
            for (int ii = 0; ii < list.size(); ++ii) {
                fixedBitmaps[ii] = ((OlapFactsBitmapRoaringBuffer)list.get(ii)).asRoaring();
            }
            MutableRoaringBitmap constant = BitmapFastAggregation.and(fixedBitmaps);
            list.clear();
            list.add(new OlapFactsBitmapRoaringBuffer(constant));
        }
        for (int ii = 0; ii < list.size(); ++ii) {
            this.arr[ii] = (OlapFactsBitmap)list.get(ii);
        }
        this.startTuplePos = list.size();
    }

    @Override
    public boolean isEmpty() {
        return !this.isNoEmpty();
    }

    @Override
    public boolean isNoEmpty() {
        if (this.isZero || this.addAndClearIsZero) {
            return false;
        }
        if (!this.addAndClearCalled && this.hasOneBitmap) {
            return true;
        }
        OlapBitmapCallback noEmptyCallBack = this.measureColumns.isEmpty() ? OlapAbstractAndtor.NoEmptyCallBack.INSTANCE : new IBaseFastNoEmpty.NoEmptyCallBackWithMeasures(this.measureColumns);
        ArrayList<ImmutableRoaringBitmap> bitmaps = new ArrayList<ImmutableRoaringBitmap>(this.arr.length);
        for (int ii = 0; ii < this.arr.length; ++ii) {
            OlapFactsBitmapRoaringBuffer roaring = (OlapFactsBitmapRoaringBuffer)this.arr[ii];
            if (roaring == null) continue;
            bitmaps.add(roaring.asRoaring());
        }
        return !RoaringBufferFastAggregation.and(bitmaps.toArray(new ImmutableRoaringBitmap[0]), noEmptyCallBack);
    }

    @Override
    public void addAndClear(N_FactPage factPage, int tupleIdx) {
        if (this.isZero) {
            return;
        }
        this.addAndClearIsZero = false;
        CdMutableInt pos = new CdMutableInt(this.startTuplePos);
        S_FactTupleDef sFactTupleDef = this.bitmapCache.apply(tupleIdx);
        sFactTupleDef.forEach((memberType, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
            OlapFactsBitmap bitmap;
            this.arr[pos.value] = null;
            boolean added = false;
            if (memberType.isStandard() && (bitmap = factPage.getForRead(hierarchyIndex, memberIndex)) != null) {
                if (bitmap.isZero()) {
                    this.addAndClearIsZero = true;
                } else {
                    this.arr[pos.value] = bitmap;
                }
                added = true;
            }
            if (!added) {
                this.arr[pos.value] = factPage.getAllBitmap();
            }
            ++pos.value;
        });
        this.addAndClearCalled = true;
    }
}

