/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import java.util.HashMap;
import java.util.Map;

public class N_FactPageColumnLookup {
    private final OlapScalarEntityFactColumn[] columns;
    private final Map<String, Integer> factColumnToColIdx = new HashMap<String, Integer>();
    private final Map<String, Integer> measureNameToColIdx = new HashMap<String, Integer>();
    private final String factPageName;

    public N_FactPageColumnLookup(N_FactPage factPage) {
        this.columns = factPage.getAllColumns();
        this.factPageName = factPage.getName();
        factPage.getMeasureGroupDef().getMeasures().forEach(measureDef -> {
            int columnIdx = measureDef.getFactsColumnIndex();
            String name = measureDef.getName();
            String factsColumnName = measureDef.getFactsColumnName();
            this.measureNameToColIdx.put(name, columnIdx);
            this.factColumnToColIdx.put(factsColumnName, columnIdx);
        });
    }

    public int getFromColumnName(String columnName) {
        if (!this.columnNameExists(columnName)) {
            throw new RuntimeException("Missing column [" + columnName + "] in fact " + this.factPageName);
        }
        return this.factColumnToColIdx.get(columnName);
    }

    public boolean columnNameExists(String columnName) {
        return this.factColumnToColIdx.containsKey(columnName);
    }

    public int getFromMeasureName(String measureName) {
        if (!this.measureNameExists(measureName)) {
            throw new RuntimeException("Missing measure [" + measureName + "] in fact " + this.factPageName);
        }
        return this.measureNameToColIdx.get(measureName);
    }

    public boolean measureNameExists(String measureName) {
        return this.measureNameToColIdx.containsKey(measureName);
    }

    public OlapScalarEntityFactColumn[] getAllColumns() {
        return this.columns;
    }

    public OlapScalarEntityFactColumn getColumn(Integer coldIdx) {
        if (coldIdx == null) {
            throw new ArrayIndexOutOfBoundsException("null index");
        }
        return this.columns[coldIdx];
    }
}

