/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.common.collection.CdAction;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsBitmapCount;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsSizeOf;
import crazydev.iccube.cluster.node.facts.N_FactPageLevelStats;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.facts.concise.N_FactPageConciseBitmapGutsContainer;
import crazydev.iccube.cluster.node.facts.roaring.N_FactBitmapBuilder;
import crazydev.iccube.cluster.node.facts.roaring.N_FactBitmapBuilderI;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageImmutableContainersI;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageMutableContainerHolder;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageRoaringMetaContainerReader;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageRoaringMetaContainerWriter;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringArrayDataReaderI;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringArrayDataWriterI;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringBuffer;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringBufferM;
import crazydev.iccube.cluster.node.facts.roaring.N_RoaringMappableContainer;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.concise.OlapConciseBitmap;
import crazydev.iccube.olap.index.bitmap.facts.concise.OlapConciseBitmapArrayGuts;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBuffer;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBufferZero;
import crazydev.iccube.olap.index.bitmap.guts.IOlapBitmapGutsContainer;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelBitmapStats;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableContainer;

public abstract class N_FactPageBitmapGutsContainer<ICONTAINERS extends N_FactPageImmutableContainersI>
implements IOlapBitmapGutsContainer {
    protected static final N_FactPageMutableContainerHolder[] EMPTY_M_CONTAINERS = new N_FactPageMutableContainerHolder[0];
    protected final String nameForStats;
    protected final S_SchemaDef schemaDef;
    protected final N_MeasureGroup measureGroup;
    private final Map<Integer, BitSet> indexingLevels = new ConcurrentHashMap<Integer, BitSet>();
    protected N_FactPageRoaringMetaContainerReader[] metaR;
    protected N_FactPageRoaringMetaContainerWriter[] metaW;
    protected N_FactPageMutableContainerHolder[] mContainers;
    protected ICONTAINERS[] iContainers;
    private boolean restoredFromConvertedBackup;
    private long metaTemporarySize;

    protected N_FactPageBitmapGutsContainer(S_SchemaDef schemaDef, N_MeasureGroup measureGroup, String nameForStats, ICONTAINERS[] iContainers) {
        this.measureGroup = measureGroup;
        this.nameForStats = nameForStats;
        this.schemaDef = schemaDef;
        this.metaR = new N_FactPageRoaringMetaContainerReader[schemaDef.getIndexingHierarchyArraySize()];
        this.mContainers = new N_FactPageMutableContainerHolder[schemaDef.getIndexingHierarchyArraySize()];
        this.iContainers = iContainers;
        this.restoredFromConvertedBackup = false;
    }

    public boolean isFileBased() {
        return false;
    }

    public String getNameForStats() {
        return this.nameForStats;
    }

    public S_SchemaDef getSchemaDef() {
        return this.schemaDef;
    }

    public void cleanupResources(OlapFileCleaner fileCleaner) {
    }

    public N_FactPageBitmapGutsBitmapCount getBitmapCount() {
        int countI = 0;
        for (N_FactPageRoaringMetaContainerReader hierarchy : this.metaR) {
            if (hierarchy == null) continue;
            countI += hierarchy.nonNullSize();
        }
        int countM = 0;
        for (N_FactPageMutableContainerHolder hierarchy : this.mContainers) {
            if (hierarchy == null) continue;
            countM += hierarchy.size();
        }
        return new N_FactPageBitmapGutsBitmapCount(countI, countM, countI + countM);
    }

    public N_FactPageBitmapGutsSizeOf sizeOf() {
        long size;
        long iContainersS = size = this.shallowSizeOf();
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.iContainers);
        for (ICONTAINERS hierarchy : this.iContainers) {
            if (hierarchy == null) continue;
            size += hierarchy.sizeOf();
        }
        iContainersS = size - iContainersS;
        long mContainersS = size;
        if (this.mContainers != EMPTY_M_CONTAINERS) {
            size += CdRamUsageEstimator.shallowSizeOf((Object[])this.mContainers);
            for (N_FactPageMutableContainerHolder hierarchy : this.mContainers) {
                if (hierarchy == null) continue;
                size += hierarchy.sizeOf();
            }
        }
        mContainersS = size - mContainersS;
        if (this.metaW != null) {
            throw new CdShouldNotBeHereProgrammingException(this.nameForStats);
        }
        long metaS = size;
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.metaR);
        int memberCount = 0;
        int bitmapCount = 0;
        for (N_FactPageRoaringMetaContainerReader hierarchy : this.metaR) {
            if (hierarchy == null) continue;
            size += hierarchy.sizeOf();
            memberCount += hierarchy.memberCount();
            bitmapCount += hierarchy.bitMapCount();
        }
        metaS = size - metaS;
        OlapLoggers.BUILDER.info((Object)String.format("[stats] ## %s %s [iContainers: %s] [mContainers: %s] [meta: %s] [total:%s]", this.nameForStats, this.isFileBased() ? "[FILE]" : "[RAM]", CdStringUtils.formatNice((long)iContainersS) + " - " + CdSizeUtils.format((double)iContainersS), CdStringUtils.formatNice((long)mContainersS) + " - " + CdSizeUtils.format((double)mContainersS), CdStringUtils.formatNice((long)metaS) + " - " + CdSizeUtils.format((double)metaS) + " (" + CdStringUtils.formatNice((long)bitmapCount) + " / " + CdStringUtils.formatNice((long)memberCount) + ")", CdStringUtils.formatNice((long)size) + " - " + CdSizeUtils.format((double)size)));
        return new N_FactPageBitmapGutsSizeOf(iContainersS, mContainersS, metaS, size);
    }

    protected abstract long shallowSizeOf();

    public void createLevelStats(OlapFactsLevelsBitmapsStats statsPerLevel, Set<OlapDimension> dimensions__) {
        int tc = Math.min(4, Runtime.getRuntime().availableProcessors());
        try (ExecutorService pool = Executors.newFixedThreadPool(tc);){
            ArrayList<Future<N_FactPageLevelStats>> allStats = new ArrayList<Future<N_FactPageLevelStats>>();
            for (OlapDimension olapDimension : dimensions__) {
                if (!olapDimension.isFactIndexing()) continue;
                for (OlapHierarchy hierarchy : olapDimension.getHierarchies()) {
                    int hierarchyIndex = hierarchy.getTupleDimensionalityIndex();
                    BitSet iLevels = this.indexingLevels.get(hierarchyIndex);
                    List<OlapLevel> levels = hierarchy.getLevels();
                    for (OlapLevel level : levels) {
                        if (iLevels != null && !iLevels.get(level.getDepth())) continue;
                        allStats.add(pool.submit(() -> this.doCreateLevelStats(hierarchyIndex, level)));
                    }
                }
            }
            try {
                for (Future future : allStats) {
                    N_FactPageLevelStats stats = (N_FactPageLevelStats)future.get();
                    if (!stats.isIndexingLevel) continue;
                    OlapLevel level = stats.level;
                    OlapHierarchy hierarchy = level.getHierarchy();
                    OlapDimension dimension = hierarchy.getDimension();
                    String dName = dimension.getName(OlapNameContext.DEFAULT_VALUES);
                    String hName = hierarchy.getName(OlapNameContext.DEFAULT_VALUES);
                    String hNameF = dName + "." + hName;
                    Map<String, OlapFactsLevelBitmapStats> hStats = statsPerLevel.getOrCreateHierarchy(hNameF);
                    String lName = level.getName(OlapNameContext.DEFAULT_VALUES);
                    OlapFactsLevelBitmapStats levelStats = hStats.computeIfAbsent(lName, levelN -> new OlapFactsLevelBitmapStats(hNameF, (String)levelN));
                    levelStats.addForPartition(stats.levelMemberCount, stats.levelBitmapsSerializedSize);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException ex) {
                throw new RuntimeException("internal error : could not create the stats", ex);
            }
        }
    }

    private N_FactPageLevelStats doCreateLevelStats(int hierarchyIndex, OlapLevel level) {
        N_FactPageLevelStats stats = new N_FactPageLevelStats(level);
        level.forEachMemberWithoutAll((CdAction<OlapMember>)((CdAction)member -> {
            OlapMember factMember = member.getFactIndexingMember();
            if (OlapMember.equal(factMember, member)) {
                int memberIndex = member.getUniqueHierarchyMemberIndex();
                this.getGutsForStats(stats, hierarchyIndex, memberIndex);
            }
        }));
        return stats;
    }

    public boolean isRestoredFromConvertedBackup() {
        return this.restoredFromConvertedBackup;
    }

    @Override
    public void compact() {
        long startMS = System.currentTimeMillis();
        OlapLoggers.BUILDER.info((Object)("[facts] guts-container [" + this.nameForStats + "] compact started"));
        if (this.metaW != null) {
            throw new CdShouldNotBeHereProgrammingException(this.nameForStats);
        }
        for (N_FactPageMutableContainerHolder hierarchy : this.mContainers) {
            if (hierarchy == null) continue;
            hierarchy.trimWithoutIncrementalLoad();
        }
        for (N_FactPageMutableContainerHolder hierarchy : this.iContainers) {
            if (hierarchy == null) continue;
            hierarchy.trimAndFreeze();
        }
        OlapLoggers.BUILDER.info((Object)("[facts] guts-container [" + this.nameForStats + "] compact done in " + CdTimeUtils.formatMillisEx((long)startMS)));
    }

    public void onDimensionChanged(N_BuildSchemaContext context, N_MeasureGroup measureGroup, S_SchemaDef schemaDef, S_HollowUpdate hollowUpdate) {
        if (schemaDef.getIndexingHierarchyArraySize() > this.metaR.length) {
            this.metaR = Arrays.copyOf(this.metaR, schemaDef.getIndexingHierarchyArraySize());
            this.mContainers = Arrays.copyOf(this.mContainers, schemaDef.getIndexingHierarchyArraySize());
            this.iContainers = (N_FactPageImmutableContainersI[])Arrays.copyOf(this.iContainers, schemaDef.getIndexingHierarchyArraySize());
        }
        if (this.metaW != null) {
            throw new CdShouldNotBeHereProgrammingException(this.nameForStats);
        }
        for (int ii = 0; ii < hollowUpdate.getMemberCount(); ++ii) {
            int fromHierarchyIndex = hollowUpdate.getFromHierarchyIndex(ii);
            int fromMemberIndex = hollowUpdate.getFromMemberIndex(ii);
            int toHierarchyIndex = hollowUpdate.getToHierarchyIndex(ii);
            int toMemberIndex = hollowUpdate.getToMemberIndex(ii);
            this.duplicate(fromHierarchyIndex, fromMemberIndex, toHierarchyIndex, toMemberIndex);
        }
    }

    public void onLoadCompleted(N_BuildSchemaContext context) {
        long startMS = System.currentTimeMillis();
        OlapLoggers.BUILDER.info((Object)"[facts] guts-container [%s] on-load-completed started".formatted(this.nameForStats));
        long conversionStartMS = System.currentTimeMillis();
        if (context.isWithIncrementalLoad()) {
            this.moveToImmutableOnIncrementalLoadActive();
        } else {
            this.moveToImmutableAll();
        }
        OlapLoggers.BUILDER.info((Object)"[facts] guts-container [%s] immutable conversion done in %s".formatted(this.nameForStats, CdTimeUtils.formatMillisEx((long)conversionStartMS)));
        long compactingStartMS = System.currentTimeMillis();
        this.compactMetaContainer();
        OlapLoggers.BUILDER.info((Object)"[facts] guts-container [%s] compacting meta done in %s".formatted(this.nameForStats, CdTimeUtils.formatMillisEx((long)compactingStartMS)));
        this.onBuildCompleted();
        OlapLoggers.BUILDER.info((Object)"[facts] guts-container [%s] on-load-completed done in %s".formatted(this.nameForStats, CdTimeUtils.formatMillisEx((long)startMS)));
    }

    public void onIncrLoadCompleted(N_CancellingContext context) {
        long startMS = System.currentTimeMillis();
        OlapLoggers.BUILDER.info((Object)"[facts] guts-container [%s] on-incr-load-completed started".formatted(this.nameForStats));
        long conversionStartMS = System.currentTimeMillis();
        this.moveToImmutableOnIncrementalLoadActive();
        OlapLoggers.BUILDER.info((Object)"[facts] guts-container [%s] immutable conversion done in %s".formatted(this.nameForStats, CdTimeUtils.formatMillisEx((long)conversionStartMS)));
        long compactingStartMS = System.currentTimeMillis();
        this.compactMetaContainer();
        OlapLoggers.BUILDER.info((Object)"[facts] guts-container [%s] compacting meta done in %s".formatted(this.nameForStats, CdTimeUtils.formatMillisEx((long)compactingStartMS)));
        this.onBuildCompleted();
        OlapLoggers.BUILDER.info((Object)"[facts] guts-container [%s] on-incr-load-completed done in %s".formatted(this.nameForStats, CdTimeUtils.formatMillisEx((long)startMS)));
    }

    protected void onBuildCompleted() {
    }

    private void moveToImmutableOnIncrementalLoadActive() {
        MutableInt max = new MutableInt(-1);
        this.forEachMutable(container -> {
            if (container.getKey() > max.intValue()) {
                max.setValue((int)container.getKey());
            }
        });
        if (max.intValue() != 0) {
            for (N_FactPageMutableContainerHolder container2 : this.mContainers) {
                if (container2 == null) continue;
                IntArrayList toRemove = new IntArrayList();
                int hierarchyIndex = container2.getHierarchyIndex();
                for (Int2ObjectMap.Entry entry : container2.int2ObjectEntrySet()) {
                    int memberIdx = entry.getIntKey();
                    N_RoaringMappableContainer roaringContainer = (N_RoaringMappableContainer)entry.getValue();
                    if (roaringContainer.getKey() >= max.intValue()) continue;
                    this.moveToImmutable(false, hierarchyIndex, memberIdx, roaringContainer);
                    toRemove.add(memberIdx);
                }
                container2.keySet().removeAll((IntCollection)toRemove);
            }
        }
    }

    private void compactMetaContainer() {
        this.metaTemporarySize = 0L;
        if (this.metaW != null) {
            for (N_FactPageRoaringMetaContainerWriter hierarchy : this.metaW) {
                if (hierarchy == null) continue;
                this.metaTemporarySize += hierarchy.loadingSizeOf();
            }
        }
        OlapLoggers.BUILDER.info((Object)("[facts] guts-container [" + this.nameForStats + "] meta temporary size : " + CdSizeUtils.format((double)this.metaTemporarySize)));
        if (this.metaW == null) {
            return;
        }
        int tc = Math.min(4, Runtime.getRuntime().availableProcessors());
        try (ExecutorService pool = Executors.newFixedThreadPool(tc);){
            int hierIdx;
            Future[] futures = new Future[this.metaW.length];
            for (hierIdx = 0; hierIdx < this.metaW.length; ++hierIdx) {
                N_FactPageRoaringMetaContainerWriter hierarchy = this.metaW[hierIdx];
                if (hierarchy == null) continue;
                N_FactPageRoaringMetaContainerReader existing = this.metaR[hierIdx];
                futures[hierIdx] = pool.submit(() -> hierarchy.toReader(existing));
            }
            try {
                for (hierIdx = 0; hierIdx < this.metaW.length; ++hierIdx) {
                    N_FactPageRoaringMetaContainerReader compacted;
                    Future future = futures[hierIdx];
                    if (future == null) continue;
                    this.metaR[hierIdx] = compacted = (N_FactPageRoaringMetaContainerReader)future.get();
                }
                this.metaW = null;
            }
            catch (InterruptedException | ExecutionException ex) {
                OlapLoggers.BUILDER.error((Object)"[facts] guts-container [%s] compacting meta error".formatted(this.nameForStats), (Throwable)ex);
                throw new RuntimeException("[facts] guts-container [%s] compacting meta error".formatted(this.nameForStats), ex);
            }
        }
    }

    private void forEachMutable(Consumer<N_RoaringMappableContainer> consumer) {
        for (N_FactPageMutableContainerHolder hierarchy : this.mContainers) {
            if (hierarchy == null) continue;
            hierarchy.forEachValue(consumer);
        }
    }

    private void moveToImmutableAll() {
        for (N_FactPageMutableContainerHolder hierarchy : this.mContainers) {
            if (hierarchy == null) continue;
            hierarchy.forEach((memberIdx, container) -> this.moveToImmutable(false, hierarchy.getHierarchyIndex(), (int)memberIdx, (N_RoaringMappableContainer)container));
        }
        this.mContainers = EMPTY_M_CONTAINERS;
    }

    private void moveToImmutable(boolean forDuplicate, int hierIdx, int memberIdx, N_RoaringMappableContainer container) {
        int magicNumber = this.toImmutableContainer(forDuplicate, hierIdx, memberIdx, container.runOptimize());
        N_FactPageRoaringMetaContainerWriter roaringArray = this.setupMetaWriter(hierIdx);
        roaringArray.getForWriteMemberMeta(memberIdx).addImmutableContainer(magicNumber, container.getKey());
    }

    private N_FactPageRoaringMetaContainerWriter setupMetaWriter(int hierIdx) {
        N_FactPageRoaringMetaContainerWriter writer;
        if (this.metaW == null) {
            this.metaW = new N_FactPageRoaringMetaContainerWriter[this.metaR.length];
            this.metaTemporarySize = 0L;
        }
        if ((writer = this.metaW[hierIdx]) == null) {
            this.metaW[hierIdx] = writer = new N_FactPageRoaringMetaContainerWriter(this.schemaDef, hierIdx);
        }
        return writer;
    }

    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info) {
        info.factsBitmapsCount.add(this.getBitmapCount());
        info.factsBitmapsSizeOf.add(this.sizeOf());
    }

    public boolean isIndexingHierarchy(int hierarchyIdx) {
        return hierarchyIdx < this.metaR.length && this.metaR[hierarchyIdx] != null;
    }

    public boolean isNoEmpty(int hierarchyIdx, int memberIdx) {
        N_FactPageRoaringMetaContainerReader rArrays;
        N_FactPageRoaringMetaContainerReader n_FactPageRoaringMetaContainerReader = rArrays = hierarchyIdx >= this.metaR.length ? null : this.metaR[hierarchyIdx];
        if (rArrays == null) {
            return false;
        }
        boolean hasMetaData = rArrays.hasMemberMetaForRead(memberIdx);
        if (!hasMetaData) {
            if (this.mContainers != null && this.mContainers.length > 0) {
                N_FactPageMutableContainerHolder mContainer = hierarchyIdx >= this.mContainers.length ? null : this.mContainers[hierarchyIdx];
                N_RoaringMappableContainer mutableContainer = mContainer == null ? null : (N_RoaringMappableContainer)mContainer.get(memberIdx);
                return mutableContainer != null;
            }
            return false;
        }
        return true;
    }

    @Nullable
    public OlapFactsBitmap getForRead(int hierarchyIdx, int memberIdx) {
        N_FactPageRoaringMetaContainerReader rArrays;
        N_FactPageRoaringMetaContainerReader n_FactPageRoaringMetaContainerReader = rArrays = hierarchyIdx >= this.metaR.length ? null : this.metaR[hierarchyIdx];
        if (rArrays == null) {
            Integer baseIndex = this.schemaDef.getBaseHierarchyIndex(hierarchyIdx);
            if (baseIndex != null && this.metaR[baseIndex] != null) {
                return OlapFactsBitmapRoaringBufferZero.INSTANCE;
            }
            return null;
        }
        N_PointableRoaringArrayDataReaderI rArray = rArrays.getMemberMetaForRead(memberIdx);
        if (rArray == null) {
            if (this.mContainers != null && this.mContainers.length > 0) {
                N_RoaringMappableContainer mutableContainer;
                N_FactPageMutableContainerHolder mContainer = hierarchyIdx >= this.mContainers.length ? null : this.mContainers[hierarchyIdx];
                N_RoaringMappableContainer n_RoaringMappableContainer = mutableContainer = mContainer == null ? null : (N_RoaringMappableContainer)mContainer.get(memberIdx);
                if (mutableContainer != null) {
                    return new OlapFactsBitmapRoaringBuffer(new ImmutableRoaringBitmap(new N_PointableRoaringBufferM(mutableContainer)));
                }
            }
            return OlapFactsBitmapRoaringBufferZero.INSTANCE;
        }
        N_FactPageImmutableContainersI iContainers = this.getImmutableContainersForRead(hierarchyIdx);
        N_FactPageMutableContainerHolder mContainer = hierarchyIdx >= this.mContainers.length ? null : this.mContainers[hierarchyIdx];
        N_RoaringMappableContainer mutableContainer = mContainer == null ? null : (N_RoaringMappableContainer)mContainer.get(memberIdx);
        N_PointableRoaringBuffer highLow = rArray.create(iContainers, mutableContainer);
        return new OlapFactsBitmapRoaringBuffer(new ImmutableRoaringBitmap(highLow));
    }

    @Nullable
    protected N_FactPageImmutableContainersI getImmutableContainersForRead(int hierarchyIdx) {
        return hierarchyIdx >= this.iContainers.length ? null : (N_FactPageImmutableContainersI)this.iContainers[hierarchyIdx];
    }

    @Override
    public void getGutsForStats(N_FactPageLevelStats stats, int hierarchyIndex, int memberIndex) {
        OlapFactsBitmap bitmap = this.getForRead(hierarchyIndex, memberIndex);
        if (bitmap != null) {
            stats.isIndexingLevel = true;
            ++stats.levelMemberCount;
            if (bitmap instanceof OlapFactsBitmapRoaringBuffer) {
                OlapFactsBitmapRoaringBuffer buffer = (OlapFactsBitmapRoaringBuffer)bitmap;
                stats.levelBitmapsSerializedSize += (long)buffer.serializedSizeInBytesForStats();
            }
        }
    }

    public void registerIndexingLevels(int hierarchyIdx, BitSet levels) {
        BitSet hierarchyLevels = this.indexingLevels.computeIfAbsent(hierarchyIdx, idx -> new BitSet());
        hierarchyLevels.or(levels);
    }

    public void appendToMemberBitmap(int hierarchyIdx, int memberIdx, BitSet rows, int rowOffset) {
        if (rows.isEmpty()) {
            throw new RuntimeException("internal error: unexpected empty batch [h:%d][m:%d][r:%d]".formatted(hierarchyIdx, memberIdx, rowOffset));
        }
        N_FactBitmapBuilderI memberBitmap = this.getOrCreateBitmapWriter(-1, hierarchyIdx, memberIdx);
        memberBitmap.facts_appendBits(rows, rowOffset);
    }

    public N_FactBitmapBuilderI getOrCreateBitmapWriter(int tupleIndex, int hierarchyIdx, int memberIdx) {
        N_RoaringMappableContainer mContainer;
        N_FactPageRoaringMetaContainerWriter metaWriter = this.setupMetaWriter(hierarchyIdx);
        N_PointableRoaringArrayDataWriterI bitmapData = metaWriter.getForWriteMemberMeta(memberIdx);
        Function<N_RoaringMappableContainer, Integer> toImmutableContainer = container -> this.toImmutableContainer(false, hierarchyIdx, memberIdx, container.runOptimize());
        N_FactPageMutableContainerHolder mContainersH = this.mContainers[hierarchyIdx];
        if (mContainersH == null) {
            this.mContainers[hierarchyIdx] = mContainersH = new N_FactPageMutableContainerHolder(hierarchyIdx);
        }
        if ((mContainer = (N_RoaringMappableContainer)mContainersH.get(memberIdx)) == null) {
            mContainer = new N_RoaringMappableContainer();
            mContainersH.put(memberIdx, mContainer);
        }
        return new N_FactBitmapBuilder(hierarchyIdx, memberIdx, toImmutableContainer, bitmapData, mContainer);
    }

    public int toImmutableContainer(boolean forDuplicate, int hierarchyIdx, int memberIdx, N_RoaringMappableContainer container) {
        ICONTAINERS iContainer = this.iContainers[hierarchyIdx];
        if (iContainer == null) {
            iContainer = this.iContainers[hierarchyIdx] = this.createImmutableContainer(hierarchyIdx);
        }
        return iContainer.add(N_RoaringMappableContainer.serialize(container.getContainerEx()));
    }

    protected abstract ICONTAINERS createImmutableContainer(int var1);

    @Override
    public void duplicate(int fromHierarchyIdx, int fromMemberIdx, int toHierarchyIdx, int toMemberIdx) {
        N_FactPageMutableContainerHolder fromM;
        N_PointableRoaringArrayDataReaderI fromRoaring;
        N_FactPageRoaringMetaContainerReader fromA = this.metaR[fromHierarchyIdx];
        if (this.metaW != null && this.metaW[toHierarchyIdx] != null && this.metaW[toHierarchyIdx].containsMember(toMemberIdx)) {
            throw new CdShouldNotBeHereProgrammingException(this.nameForStats);
        }
        if (fromA != null && (fromRoaring = fromA.getMemberMetaForRead(fromMemberIdx)) != null) {
            N_FactPageImmutableContainersI iContainers = this.getImmutableContainersForRead(fromHierarchyIdx);
            N_PointableRoaringBuffer highLow = fromRoaring.create(iContainers, null);
            this.duplicateImmutableContainers(highLow, toHierarchyIdx, toMemberIdx);
        }
        if ((fromM = this.mContainers[fromHierarchyIdx]) == null) {
            return;
        }
        N_RoaringMappableContainer fromContainer = (N_RoaringMappableContainer)fromM.get(fromMemberIdx);
        if (fromContainer == null) {
            return;
        }
        N_FactPageMutableContainerHolder toM = this.mContainers[toHierarchyIdx];
        if (toM == null) {
            toM = this.mContainers[toHierarchyIdx] = new N_FactPageMutableContainerHolder(toHierarchyIdx);
        }
        toM.put(toMemberIdx, fromContainer.clone());
    }

    protected void duplicateImmutableContainers(N_PointableRoaringBuffer highLow, int toHierarchyIdx, int toMemberIdx) {
        int count = highLow.size();
        for (int cc = 0; cc < count; ++cc) {
            char key = highLow.getKeyAtIndex(cc);
            MappeableContainer container = highLow.getContainerAtIndex(cc);
            N_RoaringMappableContainer c = new N_RoaringMappableContainer(container, key);
            this.moveToImmutable(true, toHierarchyIdx, toMemberIdx, c);
        }
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(-1);
        this.saveMeta(context, out);
        this.saveMutableContainers(context, out);
        this.saveImmutableContainers(context, out);
    }

    protected void saveMeta(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.metaR.length);
        for (N_FactPageRoaringMetaContainerReader hierarchy : this.metaR) {
            if (context.isCancelling()) {
                return;
            }
            if (hierarchy == null) {
                out.writeInt(-1);
                continue;
            }
            out.writeInt(-2);
            hierarchy.save(context, out);
        }
    }

    protected void saveMutableContainers(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        if (this.mContainers == EMPTY_M_CONTAINERS) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.mContainers.length);
        }
        for (N_FactPageMutableContainerHolder hierarchy : this.mContainers) {
            if (context.isCancelling()) {
                return;
            }
            if (hierarchy == null) {
                out.writeInt(-1);
                continue;
            }
            out.writeInt(hierarchy.size());
            for (Int2ObjectMap.Entry entry : hierarchy.int2ObjectEntrySet()) {
                if (context.isCancelling()) {
                    return;
                }
                try {
                    out.writeInt(entry.getIntKey());
                    ((N_RoaringMappableContainer)entry.getValue()).save(context, out);
                }
                catch (IOException ex) {
                    throw new RuntimeException("IO error while creating the backup", ex);
                }
            }
        }
    }

    protected void saveImmutableContainers(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.iContainers.length);
        for (ICONTAINERS hierarchy : this.iContainers) {
            if (context.isCancelling()) {
                return;
            }
            out.writeInt(hierarchy == null ? -1 : 0);
            if (hierarchy == null) continue;
            hierarchy.save(context, out);
        }
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int marker = in.readInt();
        if (marker != -1) {
            in.readBackInt(marker);
            this.restoreFromConcise(context, in);
            this.moveToImmutableAll();
            this.compactMetaContainer();
            this.onBuildCompleted();
            return;
        }
        this.restoreMeta(context, in);
        this.restoreMutableContainers(context, in);
        this.restoreImmutableContainers(context, in);
        this.onRestoreCompleted();
    }

    protected void onRestoreCompleted() {
    }

    protected void restoreFromConcise(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        OlapLoggers.BACKUP.warn((Object)("[backup] [" + this.measureGroup.getMeasureGroupName() + "] converting index - please redo your backup for faster restoration"));
        this.restoredFromConvertedBackup = true;
        N_FactPageConciseBitmapGutsContainer.restoreAndConvert(context, in, this.measureGroup, this.nameForStats, (hierarchy, member, words) -> {
            OlapConciseBitmapArrayGuts guts = new OlapConciseBitmapArrayGuts(words);
            OlapConciseBitmap concise = new OlapConciseBitmap(guts);
            N_FactBitmapBuilderI roaring = this.getOrCreateBitmapWriter(-1, hierarchy, member);
            concise.apply((startRowId, endRowId) -> {
                for (int bb = startRowId; bb < endRowId; ++bb) {
                    roaring.facts_setBitOnRestore(bb);
                }
                return true;
            });
        });
    }

    protected void restoreMeta(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.metaR = new N_FactPageRoaringMetaContainerReader[in.readInt()];
        for (int hh = 0; hh < this.metaR.length; ++hh) {
            if (context.isCancelling()) {
                return;
            }
            int nullMarker = in.readInt();
            if (nullMarker == -1) continue;
            if (nullMarker != -2) {
                throw new IOException("unexpected null marker [" + nullMarker + "]");
            }
            N_FactPageRoaringMetaContainerReader hierarchy = this.metaR[hh] = new N_FactPageRoaringMetaContainerReader(this.schemaDef, hh);
            hierarchy.restore(context, in);
        }
    }

    protected void restoreMutableContainers(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int singletonMarker = in.readInt();
        this.mContainers = singletonMarker == -1 ? EMPTY_M_CONTAINERS : new N_FactPageMutableContainerHolder[singletonMarker];
        for (int hh = 0; hh < this.mContainers.length; ++hh) {
            if (context.isCancelling()) {
                return;
            }
            int count = in.readInt();
            if (count == -1) continue;
            N_FactPageMutableContainerHolder hierarchy = this.mContainers[hh] = new N_FactPageMutableContainerHolder(hh);
            for (int mm = 0; mm < count; ++mm) {
                if (context.isCancelling()) {
                    return;
                }
                int index = in.readInt();
                N_RoaringMappableContainer container = new N_RoaringMappableContainer();
                container.restore(context, in);
                hierarchy.put(index, container);
            }
        }
    }

    protected abstract void restoreImmutableContainers(N_RestoreContext var1, S_BackupInputStream var2) throws IOException;

    public long getMetaTemporarySize() {
        return this.metaTemporarySize;
    }
}

