/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdPair;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.context.N_OlapContext;
import crazydev.iccube.cluster.node.facts.N_DistinctCountTransformKind;
import crazydev.iccube.cluster.node.facts.N_DistinctCountUniques;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class N_DistinctCountTransformer {
    public static void apply(N_OlapContext context, OlapFileCleaner fileCleaner, String owner, List<N_FactPage> partitions) {
        if (context.isCancelling()) {
            return;
        }
        long start = System.currentTimeMillis();
        Logger logger = context.loggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[distinct-count] " + owner + " :: distinct-count processing started"));
        }
        context.onProgressPhase("distinctCountStarted", new Serializable[0]);
        context.onProgressEvent("distinctCountStarted", new Serializable[0]);
        N_DistinctCountTransformer.doApply(context, fileCleaner, owner, partitions);
        context.onProgressPhase("distinctCountDone", new Serializable[0]);
        context.onProgressEvent("distinctCountDone", new Serializable[0]);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[distinct-count] " + owner + " :: distinct-count processing done [" + CdTimeUtils.formatMillisEx((long)start) + "]"));
        }
    }

    private static void doApply(N_OlapContext context, OlapFileCleaner fileCleaner, String owner, List<N_FactPage> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        Logger logger = context.loggers().builder();
        N_FactPage onePartition = (N_FactPage)CdCollections.firstNotNull(partitions);
        if (onePartition != null) {
            List<Integer> measures = onePartition.getDistinctTransformableColumns();
            for (Integer measureIdx : measures) {
                if (context.isCancelling()) break;
                String measureName = onePartition.getMeasureName(measureIdx);
                long startMS = System.currentTimeMillis();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("[distinct-count] %s :: distinct-count processing measure [%s] started", owner, measureName));
                }
                CdPair sizes = new CdPair((Object)0L, (Object)0L);
                N_DistinctCountUniques uniqueFacts = new N_DistinctCountUniques(logger, owner, measureName);
                for (N_FactPage partition : partitions) {
                    if (context.isCancelling()) break;
                    if (partition == null) continue;
                    partition.addAllDistincts(context, uniqueFacts, measureIdx);
                }
                uniqueFacts.onDone();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("[distinct-count] %s :: distinct-count processing measure [%s] distinct-values done [%s]", owner, measureName, CdTimeUtils.formatMillisEx((long)startMS)));
                }
                long distinctsDoneMS = System.currentTimeMillis();
                for (N_FactPage partition : partitions) {
                    if (context.isCancelling()) break;
                    if (partition == null) continue;
                    CdPair<Long, Long> optim = partition.distinctTransform(context, fileCleaner, uniqueFacts, measureIdx);
                    sizes.fst = (Long)sizes.fst + (Long)optim.fst;
                    sizes.snd = (Long)sizes.snd + (Long)optim.snd;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)String.format("[distinct-count] %s :: distinct-count processing measure [%s] transform-values done [%s]", owner, measureName, CdTimeUtils.formatMillisEx((long)distinctsDoneMS)));
                double sizeOptim = Math.ceil(10.0 * (double)((Long)sizes.fst).longValue() / (double)((Long)sizes.snd).longValue()) / 10.0;
                logger.info((Object)String.format("[distinct-count] %s :: distinct-count processing measure [%s] optim. done x%f [%s]", owner, measureName, sizeOptim, CdTimeUtils.formatMillisEx((long)startMS)));
            }
        }
    }

    public static OlapScalarEntityFactColumn transformUniqueFacts(N_OlapContext context, OlapFileCleaner fileCleaner, N_DistinctCountTransformKind[] transformation, OlapScalarEntityFactColumn from, N_DistinctCountUniques uniqueFacts) {
        long uniqueFactsCount = uniqueFacts.uniqueFactsCount();
        OlapScalarEntityFactColumn to = null;
        try {
            if (uniqueFactsCount <= 32767L) {
                to = from.createColumnForDistinctCountTransform(N_DistinctCountTransformKind.SHORT);
                transformation[0] = N_DistinctCountTransformKind.SHORT;
            } else if (uniqueFactsCount <= Integer.MAX_VALUE) {
                to = from.createColumnForDistinctCountTransform(N_DistinctCountTransformKind.INTEGER);
                transformation[0] = N_DistinctCountTransformKind.INTEGER;
            } else {
                to = from.createColumnForDistinctCountTransform(N_DistinctCountTransformKind.LONG);
                transformation[0] = N_DistinctCountTransformKind.LONG;
            }
            from.transformUniqueFacts(context, uniqueFacts, to);
            to.trimToSize();
            from.cleanupResources(fileCleaner);
            return to;
        }
        catch (RuntimeException ex) {
            if (to != null) {
                to.cleanupResources(fileCleaner);
            }
            throw ex;
        }
    }
}

