/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import java.util.List;

public interface IBaseFastNoEmpty {
    public boolean isAlwaysZero();

    public static final class NoEmptyCallBackWithMeasures
    implements OlapBitmapCallback {
        private final List<OlapScalarEntityFactColumn> measureColumns;

        public NoEmptyCallBackWithMeasures(List<OlapScalarEntityFactColumn> measureColumns) {
            this.measureColumns = measureColumns;
        }

        @Override
        public boolean onPoint(int point) {
            for (OlapScalarEntityFactColumn column : this.measureColumns) {
                if (!column.hasNulls()) {
                    throw new CdShouldNotBeHereProgrammingException();
                }
                if (column.isNullFact(point)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean onRange(int startRowId, int endRowId) {
            for (OlapScalarEntityFactColumn column : this.measureColumns) {
                if (!column.hasNulls()) {
                    throw new CdShouldNotBeHereProgrammingException();
                }
                for (int i = startRowId; i < endRowId; ++i) {
                    if (column.isNullFact(i)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

