/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.facts.IBaseFastNoEmpty;
import crazydev.iccube.cluster.node.facts.IFastNoEmpty;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_IFastNoEmpty;
import crazydev.iccube.cluster.node.schema.N_FastCj_Cache;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBuffer;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBufferOne;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBufferZero;
import crazydev.iccube.olap.index.bitmap.tor.OlapAbstractAndtor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.RoaringBufferFastAggregation;

public abstract class FastNoEmptyFactory {
    public static IFastNoEmpty creatFastNoEmpty(final N_FactPage factPage, List<OlapScalarEntityFactColumn> columnsWithNulls, OlapFactsBitmap globalBitmap) {
        if (globalBitmap.isZero() || globalBitmap.isEmpty()) {
            return Zero.INSTANCE;
        }
        final OlapBitmapCallback noEmptyCallBack = FastNoEmptyFactory.getNoEmptyCallBack(columnsWithNulls);
        if (globalBitmap.isOne()) {
            if (columnsWithNulls.isEmpty()) {
                return new IFastNoEmpty(){

                    @Override
                    public boolean isNoEmpty(int hierIndex, int memberIndex) {
                        return factPage.isNoEmpty(hierIndex, memberIndex);
                    }

                    @Override
                    public boolean isNoEmpty(OlapFactsBitmap bitmap) {
                        if (bitmap == null) {
                            return true;
                        }
                        return bitmap.isNoEmpty();
                    }
                };
            }
            return new IFastNoEmpty(){

                @Override
                public boolean isNoEmpty(int hierIndex, int memberIndex) {
                    OlapFactsBitmap roaringBitmap = factPage.getForRead(hierIndex, memberIndex);
                    if (roaringBitmap == null || roaringBitmap.isEmpty()) {
                        return false;
                    }
                    return !roaringBitmap.apply(noEmptyCallBack);
                }

                @Override
                public boolean isNoEmpty(OlapFactsBitmap bitmap) {
                    if (bitmap == null) {
                        return true;
                    }
                    return !bitmap.apply(noEmptyCallBack);
                }
            };
        }
        OlapFactsBitmapRoaringBuffer globalBitmapAsRoaring = (OlapFactsBitmapRoaringBuffer)globalBitmap;
        final RoaringBufferFastAggregation.QuickForCjNonEmpty fastAndTor = new RoaringBufferFastAggregation.QuickForCjNonEmpty(globalBitmapAsRoaring.asRoaring());
        return new IFastNoEmpty(){

            @Override
            public boolean isNoEmpty(int hierIndex, int memberIndex) {
                OlapFactsBitmap roaringBitmap = factPage.getForRead(hierIndex, memberIndex);
                if (roaringBitmap == null || roaringBitmap.isEmpty()) {
                    return false;
                }
                return !fastAndTor.and(((OlapFactsBitmapRoaringBuffer)roaringBitmap).asRoaring(), noEmptyCallBack);
            }

            @Override
            public boolean isNoEmpty(OlapFactsBitmap bitmap) {
                if (bitmap == null) {
                    return true;
                }
                if (bitmap.isEmpty()) {
                    return false;
                }
                return !fastAndTor.and(((OlapFactsBitmapRoaringBuffer)bitmap).asRoaring(), noEmptyCallBack);
            }
        };
    }

    public static N_IFastNoEmpty createForFastCrossjoin(N_FactPage factPage, OlapFactsBitmap globalBitmap, List<OlapScalarEntityFactColumn> columnsWithNulls, S_FactTuplesDef tuples, N_FastCrossjoinContext.BitmapCache bitmapCache, @Nullable N_FastCj_Cache cjCache) {
        ArrayList<OlapFactsBitmapRoaringBuffer> constantBitmaps = new ArrayList<OlapFactsBitmapRoaringBuffer>();
        MutableBoolean isZero = new MutableBoolean(false);
        if (cjCache != null) {
            cjCache.getFilterMembers().forEach((memberType, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
                OlapFactsBitmap bitmap;
                if (memberType.isStandard() && (bitmap = factPage.getForRead(hierarchyIndex, memberIndex)) != null) {
                    if (bitmap.isEmpty()) {
                        isZero.setFalse();
                    } else {
                        constantBitmaps.add((OlapFactsBitmapRoaringBuffer)bitmap);
                    }
                }
            });
        }
        if (isZero.booleanValue()) {
            return N_Zero.INSTANCE;
        }
        if (!globalBitmap.isOne()) {
            constantBitmaps.add((OlapFactsBitmapRoaringBuffer)globalBitmap);
        }
        OlapFactsBitmapRoaringBuffer constantBitmap = null;
        if (!constantBitmaps.isEmpty()) {
            IFactsBitmapAndTor andTor = OlapFactsBitmapAggregation.facts_createBitmapAndTor();
            constantBitmaps.forEach(andTor::add);
            OlapFactsBitmapRoaringBuffer bitmap = (OlapFactsBitmapRoaringBuffer)andTor.facts_asBitmap();
            if (bitmap.isEmpty()) {
                return N_Zero.INSTANCE;
            }
            constantBitmap = bitmap;
        }
        OlapBitmapCallback noEmptyCallBack = FastNoEmptyFactory.getNoEmptyCallBack(columnsWithNulls);
        if (constantBitmap == null) {
            if (columnsWithNulls.isEmpty()) {
                return new N_NoGlobalBitmapNoColumns(tuples);
            }
            return new N_NoGlobalBitmap(bitmapCache, noEmptyCallBack);
        }
        RoaringBufferFastAggregation.QuickForCjNonEmpty fastAndtor = new RoaringBufferFastAggregation.QuickForCjNonEmpty(constantBitmap.asRoaring());
        return new N_FastNoEmpty(bitmapCache, fastAndtor, constantBitmap, noEmptyCallBack);
    }

    private static OlapFactsBitmapRoaringBuffer toRoaringBitmap(@Nullable OlapFactsBitmap bitmap) {
        if (bitmap != null) {
            if (bitmap.isZero()) {
                return OlapFactsBitmapRoaringBufferZero.INSTANCE;
            }
            return (OlapFactsBitmapRoaringBuffer)bitmap;
        }
        return OlapFactsBitmapRoaringBufferOne.INSTANCE;
    }

    private static OlapBitmapCallback getNoEmptyCallBack(List<OlapScalarEntityFactColumn> columnsWithNulls) {
        return columnsWithNulls.isEmpty() ? OlapAbstractAndtor.NoEmptyCallBack.INSTANCE : new IBaseFastNoEmpty.NoEmptyCallBackWithMeasures(columnsWithNulls);
    }

    static class Zero
    implements IFastNoEmpty {
        static final Zero INSTANCE = new Zero();

        Zero() {
        }

        @Override
        public boolean isNoEmpty(int hierIndex, int memberIndex) {
            return false;
        }

        @Override
        public boolean isNoEmpty(@Nullable OlapFactsBitmap bitmap) {
            return false;
        }

        @Override
        public boolean isAlwaysZero() {
            return true;
        }
    }

    static class N_Zero
    implements N_IFastNoEmpty {
        static final N_Zero INSTANCE = new N_Zero();

        N_Zero() {
        }

        @Override
        public boolean isNoEmpty() {
            return false;
        }

        @Override
        public void addAndClear(N_FactPage factPage, int tupleIdx) {
        }
    }

    static class N_NoGlobalBitmapNoColumns
    implements N_IFastNoEmpty {
        private static final OlapFactsBitmapRoaringBuffer empty = new OlapFactsBitmapRoaringBuffer(null);
        private static final OlapFactsBitmapRoaringBuffer no_empty = new OlapFactsBitmapRoaringBuffer(null);
        private final S_FactTuplesDef tuples;
        private boolean isNoEmpty;

        N_NoGlobalBitmapNoColumns(S_FactTuplesDef tuples) {
            this.tuples = tuples;
        }

        @Override
        public boolean isAlwaysZero() {
            return false;
        }

        @Override
        public void addAndClear(N_FactPage factPage, int tupleIdx) {
            S_FactTupleDef tuple = this.tuples.get(tupleIdx);
            MutableBoolean _noEmpty = new MutableBoolean();
            tuple.forEach((memberType, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
                if (memberType.isStandard()) {
                    _noEmpty.setValue(factPage.isNoEmpty(hierarchyIndex, memberIndex));
                } else {
                    _noEmpty.setTrue();
                }
            });
            this.isNoEmpty = _noEmpty.booleanValue();
        }

        @Override
        public boolean isNoEmpty() {
            return this.isNoEmpty;
        }
    }

    static class N_NoGlobalBitmap
    extends N_IFastMemberNoEmpty {
        OlapBitmapCallback noEmptyCallBack;

        N_NoGlobalBitmap(N_FastCrossjoinContext.BitmapCache cache, OlapBitmapCallback noEmptyCallBack) {
            super(cache);
        }

        @Override
        public boolean isNoEmpty() {
            if (this.roaringBitmap.isEmpty()) {
                return false;
            }
            return !this.roaringBitmap.apply(this.noEmptyCallBack);
        }
    }

    static class N_FastNoEmpty
    extends N_IFastMemberNoEmpty {
        private final OlapBitmapCallback noEmptyCallBack;
        private final OlapFactsBitmapRoaringBuffer globalBitmap;
        private RoaringBufferFastAggregation.QuickForCjNonEmpty fastAndtor;

        N_FastNoEmpty(N_FastCrossjoinContext.BitmapCache cache, RoaringBufferFastAggregation.QuickForCjNonEmpty fastAndtor, OlapFactsBitmapRoaringBuffer globalBitmap, OlapBitmapCallback noEmptyCallBack) {
            super(cache);
            this.fastAndtor = fastAndtor;
            this.globalBitmap = globalBitmap;
            this.noEmptyCallBack = noEmptyCallBack;
        }

        @Override
        public boolean isNoEmpty() {
            boolean ret = this.roaringBitmap.isOne() ? this.globalBitmap.apply(this.noEmptyCallBack) : this.fastAndtor.and(this.roaringBitmap.asRoaring(), this.noEmptyCallBack);
            return !ret;
        }
    }

    static abstract class N_IFastMemberNoEmpty
    implements N_IFastNoEmpty {
        private final N_FastCrossjoinContext.BitmapCache cache;
        protected OlapFactsBitmapRoaringBuffer roaringBitmap;

        N_IFastMemberNoEmpty(N_FastCrossjoinContext.BitmapCache cache) {
            this.cache = cache;
        }

        @Override
        public boolean isAlwaysZero() {
            return false;
        }

        @Override
        public void addAndClear(N_FactPage factPage, int tupleIdx) {
            this.roaringBitmap = this.cache.computeIfAbsent(tupleIdx, sFactTupleDef -> {
                sFactTupleDef.forEach((memberType, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
                    if (memberType.isStandard()) {
                        OlapFactsBitmap bitmap = factPage.getForRead(hierarchyIndex, memberIndex);
                        this.roaringBitmap = FastNoEmptyFactory.toRoaringBitmap(bitmap);
                    } else {
                        this.roaringBitmap = OlapFactsBitmapRoaringBufferOne.INSTANCE;
                    }
                });
                return this.roaringBitmap;
            });
        }
    }
}

