/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.engine;

import crazydev.common.collection.CdPair;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfo;
import crazydev.iccube.cluster.node.context.N_ApplicationContext;
import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.context.N_MdxSessionContext;
import crazydev.iccube.cluster.node.context.N_MdxStatementRequestContext;
import crazydev.iccube.cluster.node.context.N_SetEvaluatorContext;
import crazydev.iccube.cluster.node.engine.N_CacheEventListener;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextInitData;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextInitData;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextRef;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextInitData;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextInitData;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextKind;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_CategoryDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDimensionality;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_IncrLoadDimensionUpdateDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class N_OlapEngine
implements N_CacheEventListener {
    private final N_ApplicationContext appContext;
    private final Map<S_BuildSchemaContextRef, N_BuildSchemaContext> buildContexts = new HashMap<S_BuildSchemaContextRef, N_BuildSchemaContext>();
    private final Map<S_SchemaRef, N_Schema> schemas = new HashMap<S_SchemaRef, N_Schema>();
    private final Map<S_MdxSessionContextRef, N_MdxSessionContext> mdxSessions = new HashMap<S_MdxSessionContextRef, N_MdxSessionContext>();

    public N_OlapEngine(N_ApplicationContext appContext) {
        this.appContext = appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaStartedPhaseI(S_SchemaRef schemaRef, String command) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for onSchemaStartedPhaseI(" + command + ")");
        }
        schema.onSchemaStartedPhaseI(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaStartedPhaseII(S_SchemaRef schemaRef, String command) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for onSchemaStartedPhaseI(" + command + ")");
        }
        schema.onSchemaStartedPhaseII(command);
    }

    @Override
    public void onSchemaLoadedDone(S_SchemaRef schemaRef) {
        this.appContext.onSchemaLoadedDone(schemaRef);
        this.deleteBuildSchemaContext(schemaRef, false);
    }

    @Override
    public void onSchemaLoaded(S_SchemaRef schemaRef) {
        this.appContext.onSchemaLoaded(schemaRef);
        this.deleteBuildSchemaContext(schemaRef, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaLoadedOnError(S_SchemaRef schemaRef) {
        N_Schema schema;
        this.appContext.onSchemaLoadedOnError(schemaRef);
        this.deleteBuildSchemaContext(schemaRef, true);
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.remove(schemaRef);
        }
        if (schema != null) {
            schema.onSchemaUnloaded();
        }
    }

    public void onSchemaLoadedOnErrorCleanup(S_SchemaRef schemaRef) {
        this.deleteBuildSchemaContextCleanup(schemaRef);
    }

    @Override
    public void onSchemaIncrLoaded(S_SchemaRef schemaRef) {
        this.appContext.onSchemaIncrLoaded(schemaRef);
        this.deleteBuildSchemaContext(schemaRef, false);
    }

    @Override
    public void onSchemaIncrLoadedOnError(S_SchemaRef schemaRef) {
        this.appContext.onSchemaIncrLoadedOnError(schemaRef);
        this.deleteBuildSchemaContext(schemaRef, false);
    }

    @Override
    public void onSchemaPartitionsUnloaded(S_SchemaRef schemaRef) {
        this.appContext.onSchemaPartitionsUnloaded(schemaRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaPartitionsLoaded(S_SchemaRef schemaRef) {
        N_Schema schema;
        this.appContext.onSchemaPartitionsLoaded(schemaRef);
        this.deleteBuildSchemaContext(schemaRef, false);
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for partitions loaded");
        }
        schema.onSchemaPartitionsLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaPartitionsLoadedOnError(S_SchemaRef schemaRef) {
        N_Schema schema;
        this.appContext.onSchemaPartitionsLoadedOnError(schemaRef);
        this.deleteBuildSchemaContext(schemaRef, false);
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for partitions loaded on error");
        }
        schema.onSchemaPartitionsLoadedOnError();
    }

    @Override
    public void onSchemaScriptStatementApplied(S_SchemaRef schemaRef) {
        this.appContext.onSchemaScriptStatementApplied(schemaRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaUnloaded(S_SchemaRef schemaRef) {
        N_Schema schema;
        this.appContext.onSchemaUnloaded(schemaRef);
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.remove(schemaRef);
        }
        if (schema != null) {
            schema.onSchemaUnloaded();
        }
    }

    @Override
    public void onSchemaSecurityAllPermissionsRemoved(S_SchemaRef schemaRef) {
        this.appContext.onSchemaSecurityAllPermissionsRemoved(schemaRef);
    }

    @Override
    public void onSchemaSecurityPermissionsSwitched(S_SchemaRef schemaRef, String roleName, S_FactPermsDef newPerms) {
        this.appContext.onSchemaSecurityPermissionsSwitched(schemaRef, roleName, newPerms);
    }

    public void callGC(long ms) {
        CdSystemUtils.callGC((long)ms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBuildSchemaContext(S_BuildSchemaContextInitData data) {
        N_Schema schema;
        if (data.getKind() == S_BuildSchemaContextKind.FULL_LOAD) {
            schema = null;
        } else {
            S_SchemaDef schemaDef = data.getSchemaDef();
            S_SchemaRef schemaRef = schemaDef.getRef();
            Map<S_SchemaRef, N_Schema> map = this.schemas;
            synchronized (map) {
                schema = this.schemas.get(schemaRef);
            }
            if (schema == null) {
                throw new RuntimeException("internal error: missing schema ( " + schemaDef.getName() + " )");
            }
        }
        N_BuildSchemaContext context = new N_BuildSchemaContext(this.appContext, data, schema);
        Map<S_BuildSchemaContextRef, N_BuildSchemaContext> map = this.buildContexts;
        synchronized (map) {
            S_BuildSchemaContextRef ref = data.getRef();
            N_BuildSchemaContext prev = this.buildContexts.put(ref, context);
            if (prev != null) {
                throw new RuntimeException("internal error: duplicated build schema context setup [" + String.valueOf(ref) + "] [" + String.valueOf(prev) + "]");
            }
        }
    }

    public void createBuildFactContext(S_BuildFactContextInitData data) {
        S_BuildSchemaContextRef buildSchemaContextRef = data.getBuildSchemaContextRef();
        N_BuildSchemaContext buildSchemaContext = this.resolveBuildSchemaContext(buildSchemaContextRef);
        buildSchemaContext.createFactContext(data);
    }

    public void restoreFacts(S_BuildSchemaContextRef contextRef) {
        N_BuildSchemaContext context = this.resolveBuildSchemaContext(contextRef);
        context.restoreFacts();
    }

    public void createPartition(S_BuildSchemaContextRef buildContextRef, S_BuildFactContextRef contextRef, S_FactPageRef factPageRef, boolean empty, int backupID, String nameForStats) {
        N_BuildFactContext buildFactContext = this.resolveBuildFactContext(buildContextRef, contextRef);
        buildFactContext.createPartition(factPageRef, empty, backupID, nameForStats);
    }

    public void addFactRows(S_BuildSchemaContextRef buildContextRef, S_BuildFactContextRef contextRef, N_FactPageBatchInfo info) {
        N_BuildFactContext buildFactContext = this.resolveBuildFactContext(buildContextRef, contextRef);
        buildFactContext.addFactRows(info);
    }

    public void onDimensionChanged(S_BuildSchemaContextRef contextRef, S_IncrLoadDimensionUpdateDef incrLoadUpdate, S_HollowUpdate hollowUpdate) {
        N_BuildSchemaContext context = this.resolveBuildSchemaContext(contextRef);
        context.onDimensionChanged(incrLoadUpdate, hollowUpdate);
    }

    public void onTableRowsProcessingCompleted(S_BuildSchemaContextRef contextRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        N_BuildSchemaContext context = this.resolveBuildSchemaContext(contextRef);
        context.onTableRowsProcessingCompleted(measureGroupRef, factPageRef);
    }

    public void onProcessFactsCompleted(S_BuildSchemaContextRef contextRef, S_MeasureGroupRef measureGroupRef, S_HierarchyDimensionality indexingHierarchies) {
        N_BuildSchemaContext context = this.resolveBuildSchemaContext(contextRef);
        context.onProcessFactsCompleted(measureGroupRef, indexingHierarchies);
    }

    public void onIncrLoadProcessFactsCompleted(S_BuildSchemaContextRef contextRef, S_MeasureGroupRef measureGroupRef) {
        N_BuildSchemaContext context = this.resolveBuildSchemaContext(contextRef);
        context.onIncrLoadProcessFactsCompleted(measureGroupRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateSchema(S_BuildSchemaContextRef contextRef) {
        N_BuildSchemaContext context;
        Map<S_BuildSchemaContextRef, N_BuildSchemaContext> map = this.buildContexts;
        synchronized (map) {
            context = this.buildContexts.remove(contextRef);
        }
        if (context != null) {
            S_SchemaRef schemaRef = context.getSchemaRef();
            N_Schema schema = context.getSchema();
            Map<S_SchemaRef, N_Schema> map2 = this.schemas;
            synchronized (map2) {
                this.schemas.put(schemaRef, schema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOnIncrLoadFullReload(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for clear-on-incr-load-full-reload");
        }
        schema.clearOnIncrLoadFullReload(cubeRef, measureGroupRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadPartitions(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<S_FactPageRef> partitionRefs) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for unloading partitions");
        }
        schema.unloadPartitions(cubeRef, measureGroupRef, partitionRefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadMeasureGroup(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for unloading measure group");
        }
        schema.unloadMeasureGroup(cubeRef, measureGroupRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adoptPartitions(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, @Nullable S_FactPageRef partition, S_FactPageRef loadedPartition) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for adopting partitions");
        }
        schema.adoptPartitions(cubeRef, measureGroupRef, partition, loadedPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef partitionRef) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for partition index [" + String.valueOf(partitionRef) + "]");
        }
        schema.getInformationForPerformanceTests(info, cubeRef, measureGroupRef, partitionRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef partitionRef) throws IOException {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for partition index [" + String.valueOf(partitionRef) + "]");
        }
        schema.dumpIndex(out, hierarchies, cubeRef, measureGroupRef, partitionRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPartitionStats(OlapStatsContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef partitionRef, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, Set<OlapDimension> dimensions__) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for partition stats [" + String.valueOf(partitionRef) + "]");
        }
        schema.createPartitionStats(context, cubeRef, measureGroupRef, partitionRef, statsPerLevel, partitionsStats, dimensions__);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIncrLoadPartitionStats(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef partitionRef, List<OlapFactsPartitionStats> partitionsStats) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
        }
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "] for incr. load partition stats [" + String.valueOf(partitionRef) + "]");
        }
        schema.createIncrLoadPartitionStats(cubeRef, measureGroupRef, partitionRef, partitionsStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMdxSessionCount() {
        Map<S_MdxSessionContextRef, N_MdxSessionContext> map = this.mdxSessions;
        synchronized (map) {
            return this.mdxSessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMdxSessionContext(S_MdxSessionContextInitData data) {
        N_MdxSessionContext ctxt = new N_MdxSessionContext(this.appContext, data);
        Map<S_MdxSessionContextRef, N_MdxSessionContext> map = this.mdxSessions;
        synchronized (map) {
            S_MdxSessionContextRef ref = ctxt.getRef();
            if (this.mdxSessions.containsKey(ref)) {
                throw new RuntimeException("internal error: existing MDX session context [" + String.valueOf(ref) + "]");
            }
            this.mdxSessions.put(ref, ctxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMdxSessionContext(S_MdxSessionContextRef sessionContextRef) {
        Map<S_MdxSessionContextRef, N_MdxSessionContext> map = this.mdxSessions;
        synchronized (map) {
            this.mdxSessions.remove(sessionContextRef);
        }
    }

    public void createMdxStatementRequestContext(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextInitData data) {
        N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
        S_SchemaRef schemaRef = data.getSchemaRef();
        N_Schema schema = this.resolveSchema(schemaRef);
        sessionContext.createMdxStatementRequestContext(schema, data);
    }

    public void deleteMdxStatementRequestContext(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef) {
        N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
        sessionContext.deleteMdxStatementRequestContext(mdxStatementContextRef);
    }

    public void createMdxRequestContext(S_MdxSessionContextRef sessionContextRef, S_MdxRequestContextInitData data) {
        N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
        sessionContext.createMdxRequestContext(data);
    }

    public void createFastCrossjoinContext(S_MdxSessionContextRef sessionContextRef, S_FastCrossjoinContextInitData data) {
        N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
        sessionContext.createFastCrossjoinContext(data);
    }

    public void createSetEvaluatorContext(S_MdxSessionContextRef sessionContextRef, S_SetEvaluatorContextInitData data) {
        N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
        sessionContext.createSetEvaluatorContext(data);
    }

    public void deleteSetEvaluatorContext(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_MdxRequestContextRef mdxRequestContextRef, S_SetEvaluatorContextRef contextRef) {
        N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
        sessionContext.deleteSetEvaluatorContext(mdxStatementContextRef, mdxRequestContextRef, contextRef);
    }

    public void createSchemaCategory(S_SchemaRef schemaRef, S_CategoryDef category, List<S_CategoryDef> children) {
        N_Schema schema = this.resolveSchema(schemaRef);
        schema.createCategory(category, children);
    }

    public void createSessionCategory(S_SchemaRef schemaRef, S_MdxSessionContextRef sessionContextRef, S_CategoryDef category, List<S_CategoryDef> children) {
        N_Schema schema = this.resolveSchema(schemaRef);
        N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
        sessionContext.createCategory(schema, category, children);
    }

    public void createRequestCategory(S_SchemaRef schemaRef, S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_CategoryDef category, List<S_CategoryDef> children) {
        N_Schema schema = this.resolveSchema(schemaRef);
        N_MdxStatementRequestContext mdxStatementRequestContext = this.resolveMdxStatementRequestContext(sessionContextRef, mdxStatementContextRef);
        mdxStatementRequestContext.createCategory(schema, category, children);
    }

    public void createRequestSubCube(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_RequestSubCubeDef subCube) {
        N_MdxStatementRequestContext mdxStatementRequestContext = this.resolveMdxStatementRequestContext(sessionContextRef, mdxStatementContextRef);
        mdxStatementRequestContext.createRequestSubCube(subCube);
    }

    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_MdxRequestContextRef mdxRequestContextRef, GFContext dtContext, S_MeasureGroupRef measureGroupRef, OlapMeasureMember measure, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeRef> subCubeRefs) {
        N_MdxRequestContext mdxRequestContext = this.resolveMdxRequestContext(sessionContextRef, mdxStatementContextRef, mdxRequestContextRef);
        List<S_RequestSubCubeDef> subCubes = mdxRequestContext.resolveRequestSubCubes(subCubeRefs);
        N_Schema schemaContext = mdxRequestContext.getSchemaContext();
        return schemaContext.getFastNonEmptyFilter(mdxRequestContext, dtContext, measureGroupRef, tupleDef, measure, overwrittenHierarchies, visualTotals, subCubes);
    }

    public OlapScalarEntity evalTuple(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_MdxRequestContextRef mdxRequestContextRef, GFContext dtContext, S_MeasureGroupRef measureGroupRef, OlapMeasureMember measure, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeRef> subCubeRefs) {
        N_MdxRequestContext mdxRequestContext = this.resolveMdxRequestContext(sessionContextRef, mdxStatementContextRef, mdxRequestContextRef);
        List<S_RequestSubCubeDef> subCubes = mdxRequestContext.resolveRequestSubCubes(subCubeRefs);
        N_Schema schemaContext = mdxRequestContext.getSchemaContext();
        OlapScalarEntity res = schemaContext.evalTuple(mdxRequestContext, dtContext, measureGroupRef, tupleDef, measure, overwrittenHierarchies, visualTotals, subCubes);
        return res;
    }

    public OlapScalarEntity evalSetTuple(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_MdxRequestContextRef mdxRequestContextRef, S_SetEvaluatorContextRef contextRef, GFContext gfContext, S_FactTupleDef tupleDef) {
        N_SetEvaluatorContext setEvaluatorContext = this.resolveSetEvaluatorContext(sessionContextRef, mdxStatementContextRef, mdxRequestContextRef, contextRef);
        OlapScalarEntity res = setEvaluatorContext.evalSetTuple(gfContext, tupleDef);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable factsColumnForTests__() {
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            for (N_Schema schema : this.schemas.values()) {
                String name = schema.getSchemaDef().getName();
                if (!name.equals("tot")) continue;
                OlapScalarEntityFactColumn[] res = schema.factsColumnForTests__();
                return res;
            }
        }
        throw new RuntimeException("internal error: cannot retrieve facts column");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private N_MdxSessionContext resolveSessionContext(S_MdxSessionContextRef ref) {
        N_MdxSessionContext sessionContext;
        Object referenced = ref.getReferenced();
        if (referenced != null) {
            N_MdxSessionContext sessionContext2 = (N_MdxSessionContext)referenced;
            return sessionContext2;
        }
        Map<S_MdxSessionContextRef, N_MdxSessionContext> map = this.mdxSessions;
        synchronized (map) {
            sessionContext = this.mdxSessions.get(ref);
        }
        if (sessionContext == null) {
            throw new RuntimeException("internal error: missing MDX session context [" + String.valueOf(ref) + "]");
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private N_BuildSchemaContext resolveBuildSchemaContext(S_BuildSchemaContextRef ref) {
        N_BuildSchemaContext buildSchemaContext;
        Object referenced = ref.getReferenced();
        if (referenced != null) {
            N_BuildSchemaContext buildSchemaContext2 = (N_BuildSchemaContext)referenced;
            return buildSchemaContext2;
        }
        Map<S_BuildSchemaContextRef, N_BuildSchemaContext> map = this.buildContexts;
        synchronized (map) {
            buildSchemaContext = this.buildContexts.get(ref);
        }
        if (buildSchemaContext == null) {
            throw new RuntimeException("internal error: missing build schema context [" + String.valueOf(ref) + "]");
        }
        return buildSchemaContext;
    }

    private N_BuildFactContext resolveBuildFactContext(S_BuildSchemaContextRef buildSchemaContextRef, S_BuildFactContextRef buildFactContextRef) {
        Object referenced = buildFactContextRef.getReferenced();
        if (referenced != null) {
            N_BuildFactContext buildFactContext = (N_BuildFactContext)referenced;
            return buildFactContext;
        }
        N_BuildSchemaContext buildSchemaContext = this.resolveBuildSchemaContext(buildSchemaContextRef);
        N_BuildFactContext buildFactContext = buildSchemaContext.resolveFactContext(buildFactContextRef);
        return buildFactContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private N_Schema resolveSchema(S_SchemaRef schemaRef) {
        N_Schema schema;
        Map<S_SchemaRef, N_Schema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaRef);
            if (schema == null) {
                throw new RuntimeException("internal error: missing schema [" + String.valueOf(schemaRef) + "]");
            }
        }
        return schema;
    }

    private N_MdxStatementRequestContext resolveMdxStatementRequestContext(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef contextRef) {
        N_MdxStatementRequestContext mdxRequestContext;
        Object referenced = contextRef.getReferenced();
        if (referenced != null) {
            mdxRequestContext = (N_MdxStatementRequestContext)referenced;
        } else {
            N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
            mdxRequestContext = sessionContext.getMdxStatementRequestContext(contextRef);
        }
        return mdxRequestContext;
    }

    private N_MdxRequestContext resolveMdxRequestContext(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef statementContextRef, S_MdxRequestContextRef contextRef) {
        N_MdxRequestContext mdxRequestContext;
        Object referenced = contextRef.getReferenced();
        if (referenced != null) {
            mdxRequestContext = (N_MdxRequestContext)referenced;
        } else {
            N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
            mdxRequestContext = sessionContext.getMdxRequestContext(statementContextRef, contextRef);
        }
        return mdxRequestContext;
    }

    private N_FastCrossjoinContext resolveFastCrossjoinContext(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef statementContextRef, S_FastCrossjoinContextRef contextRef) {
        N_FastCrossjoinContext fastCrossjoinContext;
        Object referenced = contextRef.getReferenced();
        if (referenced != null) {
            fastCrossjoinContext = (N_FastCrossjoinContext)referenced;
        } else {
            N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
            fastCrossjoinContext = sessionContext.getFastCrossjoinContext(statementContextRef, contextRef);
        }
        return fastCrossjoinContext;
    }

    private N_SetEvaluatorContext resolveSetEvaluatorContext(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef statementContextRef, S_MdxRequestContextRef mdxRequestContextRef, S_SetEvaluatorContextRef contextRef) {
        N_SetEvaluatorContext setEvaluatorContext;
        Object referenced = contextRef.getReferenced();
        if (referenced != null) {
            setEvaluatorContext = (N_SetEvaluatorContext)referenced;
        } else {
            N_MdxSessionContext sessionContext = this.resolveSessionContext(sessionContextRef);
            N_MdxRequestContext mdxRequestContext = sessionContext.getMdxRequestContext(statementContextRef, mdxRequestContextRef);
            setEvaluatorContext = mdxRequestContext.getSetEvaluatorContext(contextRef);
        }
        return setEvaluatorContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBuildSchemaContext(S_SchemaRef schemaRef, boolean cleanupSchemaResource) {
        ArrayList<N_Schema> schemas = null;
        Map<S_BuildSchemaContextRef, N_BuildSchemaContext> map = this.buildContexts;
        synchronized (map) {
            ArrayList<S_BuildSchemaContextRef> toDelete = null;
            for (Map.Entry<S_BuildSchemaContextRef, N_BuildSchemaContext> entry : this.buildContexts.entrySet()) {
                N_BuildSchemaContext context = entry.getValue();
                S_SchemaRef contextSchemaRef = context.getSchemaRef();
                if (!contextSchemaRef.equals(schemaRef)) continue;
                if (toDelete == null) {
                    toDelete = new ArrayList<S_BuildSchemaContextRef>();
                }
                toDelete.add(entry.getKey());
            }
            if (toDelete != null) {
                for (S_BuildSchemaContextRef ref : toDelete) {
                    N_BuildSchemaContext buildContext = this.buildContexts.remove(ref);
                    if (buildContext == null || !cleanupSchemaResource) continue;
                    N_Schema schema = buildContext.getSchema();
                    if (schemas == null) {
                        schemas = new ArrayList<N_Schema>();
                        schemas.add(schema);
                        continue;
                    }
                    if (schemas.contains(schema)) continue;
                    schemas.add(schema);
                }
            }
        }
        if (schemas != null) {
            for (N_Schema schema : schemas) {
                schema.cleanupResources();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBuildSchemaContextCleanup(S_SchemaRef schemaRef) {
        HashSet<N_Schema> schemas = new HashSet<N_Schema>();
        Map<S_BuildSchemaContextRef, N_BuildSchemaContext> map = this.buildContexts;
        synchronized (map) {
            for (Map.Entry<S_BuildSchemaContextRef, N_BuildSchemaContext> entry : this.buildContexts.entrySet()) {
                N_BuildSchemaContext context = entry.getValue();
                S_SchemaRef contextSchemaRef = context.getSchemaRef();
                if (!contextSchemaRef.equals(schemaRef)) continue;
                schemas.add(context.getSchema());
            }
        }
        for (N_Schema schema : schemas) {
            schema.cleanupResources();
        }
    }

    public void fastcrossjoin_logOnCompleted(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_FastCrossjoinContextRef fastCrossjoinContextRef, Logger logger) {
        N_FastCrossjoinContext fastCrossjoinContext = this.resolveFastCrossjoinContext(sessionContextRef, mdxStatementContextRef, fastCrossjoinContextRef);
        fastCrossjoinContext.logOnCompleted(logger);
    }

    public List<CjBitmapHelper.CjBitmap> fastcrossjoin_init(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_FastCrossjoinContextRef fastCrossjoinContextRef, S_NonEmptyBehavior nonEmptyBehavior, OlapTupleDimensionality cjTupleDimensionality, List<S_FactTuplesDef> tuples, int limitSize) {
        N_FastCrossjoinContext fastCrossjoinContext = this.resolveFastCrossjoinContext(sessionContextRef, mdxStatementContextRef, fastCrossjoinContextRef);
        N_Schema schemaContext = fastCrossjoinContext.getSchemaContext();
        List<CjBitmapHelper.CjBitmap> res = schemaContext.fastcrossjoin_init(fastCrossjoinContext, nonEmptyBehavior, cjTupleDimensionality, tuples, limitSize);
        return res;
    }

    public void fastcrossjoin_initReduce(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_FastCrossjoinContextRef fastCrossjoinContextRef, S_NonEmptyBehavior nonEmptyBehavior, CjBitmapHelper.CjBitmap isNotEmpty, int tupleListindex, int start, int end) {
        N_FastCrossjoinContext fastCrossjoinContext = this.resolveFastCrossjoinContext(sessionContextRef, mdxStatementContextRef, fastCrossjoinContextRef);
        N_Schema schemaContext = fastCrossjoinContext.getSchemaContext();
        schemaContext.fastcrossjoin_initReduce(fastCrossjoinContext, nonEmptyBehavior, isNotEmpty, tupleListindex, start, end);
    }

    public CdPair<List<CjBitmapHelper.CjTupleListReducer>, Integer> fastcrossjoin_reduce(S_MdxSessionContextRef sessionContextRef, S_MdxStatementRequestContextRef mdxStatementContextRef, S_FastCrossjoinContextRef fastCrossjoinContextRef, S_NonEmptyBehavior nonEmptyBehavior, int index, List<CjBitmapHelper.CjTupleListReducer> tuplesReducer, S_FactTupleDef filterMembers) {
        N_FastCrossjoinContext fastCrossjoinContext = this.resolveFastCrossjoinContext(sessionContextRef, mdxStatementContextRef, fastCrossjoinContextRef);
        N_Schema schemaContext = fastCrossjoinContext.getSchemaContext();
        CdPair<List<CjBitmapHelper.CjTupleListReducer>, Integer> res = schemaContext.fastcrossjoin_reduce(fastCrossjoinContext, nonEmptyBehavior, index, tuplesReducer, filterMembers);
        return res;
    }

    public boolean measureHasNullsInFactColumns(S_SchemaRef schemaRef, S_MeasureGroupRef clusterMeasureGroupRef, OlapMeasureMember measure) {
        N_Schema schema = this.resolveSchema(schemaRef);
        return schema.getMeasureGroup(clusterMeasureGroupRef).measureHasNullsInFactColumns(measure);
    }

    public String sizeInRows(S_SchemaRef schemaRef, S_MeasureGroupRef clusterMeasureGroupRef) {
        N_Schema schema = this.resolveSchema(schemaRef);
        return schema.getMeasureGroup(clusterMeasureGroupRef).sizeInRows();
    }

    public int sizeInRowsEx(S_SchemaRef schemaRef, S_MeasureGroupRef clusterMeasureGroupRef) {
        N_Schema schema = this.resolveSchema(schemaRef);
        return schema.getMeasureGroup(clusterMeasureGroupRef).sizeInRowsEx();
    }

    public int partitionCount(S_SchemaRef schemaRef, S_MeasureGroupRef clusterMeasureGroupRef) {
        N_Schema schema = this.resolveSchema(schemaRef);
        return schema.getMeasureGroup(clusterMeasureGroupRef).partitionCount();
    }
}

