/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.context;

import crazydev.iccube.cluster.node.context.N_AbstractContext;
import crazydev.iccube.cluster.node.context.N_ApplicationContext;
import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.context.N_MdxSessionContext;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.node.perms.N_SecurityPermissionsManager;
import crazydev.iccube.cluster.node.schema.N_Category;
import crazydev.iccube.cluster.node.schema.N_RequestCategoryManager;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextInitData;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.cluster.shared.schema.S_CategoryDef;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_DefaultsDef;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class N_MdxStatementRequestContext
extends N_AbstractContext {
    private final S_MdxStatementRequestContextRef ref;
    private final N_MdxSessionContext sessionContext;
    private final N_Schema schemaContext;
    private final String role;
    @Nullable
    private final S_DefaultsDef defaults;
    @Nullable
    private final S_FactPermsDef permsDef;
    private final boolean drillthroughActive;
    private final int neCrossjoinBitmapCacheLimit;
    private final Map<S_MdxRequestContextRef, N_MdxRequestContext> mdxRequests = new HashMap<S_MdxRequestContextRef, N_MdxRequestContext>();
    private final N_RequestCategoryManager categoryManager;
    private final Map<S_RequestSubCubeRef, S_RequestSubCubeDef> subCubes = new ConcurrentHashMap<S_RequestSubCubeRef, S_RequestSubCubeDef>();
    private final Map<S_FastCrossjoinContextRef, N_FastCrossjoinContext> fastCrossjoins = new HashMap<S_FastCrossjoinContextRef, N_FastCrossjoinContext>();
    @Nullable
    private N_MdxRequestContext staticMdxRequest;
    @Nullable
    private N_MdxRequestContext dynamicMdxRequest;

    public N_MdxStatementRequestContext(N_MdxSessionContext sessionContext, N_Schema schemaContext, S_MdxStatementRequestContextInitData data) {
        super(sessionContext.getAppContext(), data.getClientUUID());
        this.ref = data.getRef();
        this.ref.setReferenced(this);
        this.sessionContext = sessionContext;
        this.schemaContext = schemaContext;
        this.role = data.getRole();
        this.defaults = data.getDefaults();
        N_ApplicationContext appContext = sessionContext.getAppContext();
        N_SecurityPermissionsManager securityManager = appContext.getSecurityPermissionsManager();
        S_SchemaRef schemaRef = schemaContext.getSchemaRef();
        this.permsDef = securityManager.getSchemaSecurityPermissions(this.role, schemaRef);
        this.drillthroughActive = data.isDrillthroughActive();
        this.neCrossjoinBitmapCacheLimit = data.getNonEmptyCrossjoinBitmapCacheLimit();
        this.categoryManager = new N_RequestCategoryManager();
    }

    public N_MdxSessionContext getSessionContext() {
        return this.sessionContext;
    }

    public S_MdxStatementRequestContextRef getRef() {
        return this.ref;
    }

    public N_Schema getSchemaContext() {
        return this.schemaContext;
    }

    public boolean isDrillthroughActive() {
        return this.drillthroughActive;
    }

    public int getNonEmptyCrossjoinBitmapCacheLimit() {
        return this.neCrossjoinBitmapCacheLimit;
    }

    public String getRoleName() {
        return this.role;
    }

    public S_SchemaDef getSchemaDef() {
        return this.schemaContext.getSchemaDef();
    }

    public S_CubeDef getCubeDef(S_CubeRef ref) {
        S_SchemaDef schemaDef = this.getSchemaDef();
        S_CubeDef cubeDef = schemaDef.resolveCube(ref);
        return cubeDef;
    }

    @Nullable
    public S_DefaultsDef getDefaults() {
        return this.defaults;
    }

    @Nullable
    public OlapFactsBitmap getOrCreatePermissionBitmap(N_FactBitmapContainer bitmapContainer) {
        if (this.permsDef == null) {
            return null;
        }
        N_ApplicationContext appContext = this.sessionContext.getAppContext();
        N_SecurityPermissionsManager securityManager = appContext.getSecurityPermissionsManager();
        S_SchemaRef schemaRef = this.schemaContext.getSchemaRef();
        OlapFactsBitmap perms = securityManager.getOrCreateSchemaSecurityPermissions(this.role, schemaRef, this.permsDef, bitmapContainer);
        return perms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMdxRequestContext(S_MdxRequestContextInitData data) {
        N_MdxRequestContext context = new N_MdxRequestContext(this, data);
        S_MdxRequestContextRef ref = context.getRef();
        Map<S_MdxRequestContextRef, N_MdxRequestContext> map = this.mdxRequests;
        synchronized (map) {
            if (this.mdxRequests.put(ref, context) != null) {
                throw new RuntimeException("internal error: existing MDX request context [" + String.valueOf(ref) + "]");
            }
            if (context.isStatic()) {
                this.staticMdxRequest = context;
            }
            if (context.isDynamic()) {
                this.dynamicMdxRequest = context;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N_MdxRequestContext getMdxRequestContext(S_MdxRequestContextRef ref) {
        Map<S_MdxRequestContextRef, N_MdxRequestContext> map = this.mdxRequests;
        synchronized (map) {
            N_MdxRequestContext request = this.mdxRequests.get(ref);
            if (request == null) {
                throw new RuntimeException("internal error: missing MDX request context [" + String.valueOf(ref) + "]");
            }
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N_MdxRequestContext getMdxRequestContext() {
        Map<S_MdxRequestContextRef, N_MdxRequestContext> map = this.mdxRequests;
        synchronized (map) {
            return this.dynamicMdxRequest == null ? this.staticMdxRequest : this.dynamicMdxRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFastCrossjoinContext(S_FastCrossjoinContextInitData data) {
        N_FastCrossjoinContext context = new N_FastCrossjoinContext(this, data);
        S_FastCrossjoinContextRef ref = context.getRef();
        Map<S_FastCrossjoinContextRef, N_FastCrossjoinContext> map = this.fastCrossjoins;
        synchronized (map) {
            if (this.fastCrossjoins.put(ref, context) != null) {
                throw new RuntimeException("internal error: existing fast crossjoin context [" + String.valueOf(ref) + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N_FastCrossjoinContext getFastCrossjoinContext(S_FastCrossjoinContextRef ref) {
        Map<S_FastCrossjoinContextRef, N_FastCrossjoinContext> map = this.fastCrossjoins;
        synchronized (map) {
            N_FastCrossjoinContext request = this.fastCrossjoins.get(ref);
            if (request == null) {
                throw new RuntimeException("internal error: missing fast crossjoin context [" + String.valueOf(ref) + "]");
            }
            return request;
        }
    }

    public void addDefaults(OlapTupleDimensionality tupleDimensionality, Consumer<S_MemberDef> onDefaultMemberF) {
        if (this.defaults == null) {
            return;
        }
        this.defaults.addDefaults(tupleDimensionality, onDefaultMemberF);
    }

    public void createCategory(N_Schema schema, S_CategoryDef category, List<S_CategoryDef> children) {
        this.categoryManager.addCategory(schema, category, children);
    }

    @Nullable
    public N_Category lookupCategory(int hierarchyIndex, int memberIndex, long cacheId) {
        N_Category category = this.categoryManager.getCategory(this.schemaContext, hierarchyIndex, memberIndex, cacheId);
        return category;
    }

    public void createRequestSubCube(S_RequestSubCubeDef subCube) {
        this.subCubes.put(subCube.getRef(), subCube);
    }

    @Nullable
    public List<S_RequestSubCubeDef> resolveRequestSubCubes(@Nullable List<S_RequestSubCubeRef> subCubeRefs) {
        ArrayList<S_RequestSubCubeDef> subCubeDefs;
        if (subCubeRefs != null) {
            subCubeDefs = new ArrayList<S_RequestSubCubeDef>();
            for (S_RequestSubCubeRef subCubeRef : subCubeRefs) {
                S_RequestSubCubeDef subCubeDef = (S_RequestSubCubeDef)subCubeRef.getReferenced();
                if (subCubeDef == null) {
                    subCubeDef = this.subCubes.get(subCubeRef);
                }
                if (subCubeDef == null) {
                    throw new RuntimeException("internal error: missing request sub-cube [" + String.valueOf(subCubeRef) + "]");
                }
                subCubeDefs.add(subCubeDef);
            }
        } else {
            subCubeDefs = null;
        }
        return subCubeDefs;
    }
}

