/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.context;

import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.context.N_MdxSessionContext;
import crazydev.iccube.cluster.node.context.N_MdxStatementRequestContext;
import crazydev.iccube.cluster.node.context.N_SetEvaluatorContext;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.node.facts.N_MdxRequestBitmapCache;
import crazydev.iccube.cluster.node.schema.N_Category;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextInitData;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextRef;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_DefaultsDef;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class N_MdxRequestContext
implements N_CancellingContext {
    private final N_MdxStatementRequestContext owner;
    private final S_MdxRequestContextRef ref;
    private final S_MdxRequestContextInitData data;
    private final boolean dynamic;
    private final S_CubeDef cube;
    @Nullable
    private final S_FactSubCube slicer;
    @Nullable
    private final S_FactSubCube subSelect;
    private final Map<S_SetEvaluatorContextRef, N_SetEvaluatorContext> activeSetEvaluatorContexts = new ConcurrentHashMap<S_SetEvaluatorContextRef, N_SetEvaluatorContext>();
    private final Map<N_FactBitmapContainer, N_MdxRequestBitmapCache> bitmapCaches = new ConcurrentHashMap<N_FactBitmapContainer, N_MdxRequestBitmapCache>();

    public N_MdxRequestContext(N_MdxStatementRequestContext owner, S_MdxRequestContextInitData data) {
        this.owner = owner;
        this.data = data;
        this.ref = data.getRef();
        this.ref.setReferenced(this);
        this.dynamic = data.isDynamic();
        this.cube = owner.getCubeDef(data.getCubeRef());
        this.slicer = data.getSlicer();
        this.subSelect = data.getSubSelect();
    }

    public N_MdxSessionContext getSessionContext() {
        return this.owner.getSessionContext();
    }

    public N_MdxStatementRequestContext getMdxStatementContext() {
        return this.owner;
    }

    public S_MdxRequestContextRef getRef() {
        return this.ref;
    }

    public N_Schema getSchemaContext() {
        return this.owner.getSchemaContext();
    }

    public boolean isDrillthroughActive() {
        return this.owner.isDrillthroughActive();
    }

    @Override
    public boolean isCancelling() {
        return this.owner.isCancelling();
    }

    public boolean isStatic() {
        return !this.dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public S_CubeDef getCube() {
        return this.cube;
    }

    @Nullable
    public S_FactSubCube getSlicer() {
        return this.slicer;
    }

    @Nullable
    public S_FactSubCube getSubSelect() {
        return this.subSelect;
    }

    @Nullable
    public OlapFactsBitmap getOrCreatePermissionBitmap(N_FactBitmapContainer bitmapContainer) {
        OlapFactsBitmap perms = this.owner.getOrCreatePermissionBitmap(bitmapContainer);
        return perms;
    }

    public void createSetEvaluatorContext(N_MdxRequestContext mdxRequestContext, S_SetEvaluatorContextInitData data) {
        N_SetEvaluatorContext context = new N_SetEvaluatorContext(mdxRequestContext, data);
        S_SetEvaluatorContextRef ref = context.getRef();
        if (this.activeSetEvaluatorContexts.put(ref, context) != null) {
            throw new RuntimeException("internal error: existing set-evaluator [" + String.valueOf(ref) + "]");
        }
    }

    public void deleteSetEvaluatorContext(S_SetEvaluatorContextRef ref) {
        this.activeSetEvaluatorContexts.remove(ref);
    }

    public N_SetEvaluatorContext getSetEvaluatorContext(S_SetEvaluatorContextRef ref) {
        N_SetEvaluatorContext context = this.activeSetEvaluatorContexts.get(ref);
        if (context == null) {
            throw new RuntimeException("internal error: missing set-evaluator [" + String.valueOf(ref) + "]");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N_MdxRequestBitmapCache getOrCreateBitmapCache(N_FactBitmapContainer bitmapContainer) {
        N_MdxRequestBitmapCache cache = this.bitmapCaches.get(bitmapContainer);
        if (cache == null) {
            Map<N_FactBitmapContainer, N_MdxRequestBitmapCache> map = this.bitmapCaches;
            synchronized (map) {
                cache = this.bitmapCaches.get(bitmapContainer);
                if (cache == null) {
                    cache = new N_MdxRequestBitmapCache(this, bitmapContainer);
                    this.bitmapCaches.put(bitmapContainer, cache);
                }
            }
        }
        return cache;
    }

    public void addDefaults(OlapTupleDimensionality tupleDimensionality, Consumer<S_MemberDef> onDefaultMemberF) {
        this.owner.addDefaults(tupleDimensionality, onDefaultMemberF);
    }

    public N_Category getCategory(OlapHierarchyScope scope, int hierarchyIndex, int memberIndex, long cacheId) {
        N_Category category = switch (scope) {
            case OlapHierarchyScope.SCHEMA -> {
                N_Schema schema = this.getSchemaContext();
                yield schema.lookupCategory(hierarchyIndex, memberIndex, cacheId);
            }
            case OlapHierarchyScope.SESSION -> {
                N_Schema schema = this.getSchemaContext();
                N_MdxSessionContext sessionContext = this.getSessionContext();
                yield sessionContext.lookupCategory(schema, hierarchyIndex, memberIndex, cacheId);
            }
            case OlapHierarchyScope.REQUEST -> {
                N_MdxStatementRequestContext requestContext = this.getMdxStatementContext();
                yield requestContext.lookupCategory(hierarchyIndex, memberIndex, cacheId);
            }
            default -> throw new RuntimeException("internal error: unexpected category scope [" + String.valueOf((Object)scope) + "]");
        };
        if (category == null) {
            throw new RuntimeException("internal error: missing category [hierIdx:" + hierarchyIndex + "] [memberIdx:" + memberIndex + "][scope:" + String.valueOf((Object)scope) + "]");
        }
        return category;
    }

    @Nullable
    public OlapFactsBitmap getOrCreateCategoryBitmap(N_FactBitmapContainer bitmapContainer, OlapHierarchyScope scope, int hierarchyIndex, int memberIndex, long cacheId) {
        N_Category category = this.getCategory(scope, hierarchyIndex, memberIndex, cacheId);
        OlapFactsBitmap bitmap = category.getOrCreateCategoryBitmap(this, bitmapContainer);
        return bitmap;
    }

    @Nullable
    public List<S_RequestSubCubeDef> resolveRequestSubCubes(@Nullable List<S_RequestSubCubeRef> subCubeRefs) {
        List<S_RequestSubCubeDef> subCubeDefs = this.owner.resolveRequestSubCubes(subCubeRefs);
        return subCubeDefs;
    }

    @Nullable
    public S_DefaultsDef getDefaults() {
        return this.owner.getDefaults();
    }

    public OlapSchema getSchema() {
        return this.data.getStatementContext().getSchema();
    }
}

