/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.context;

import crazydev.common.collection.CdArrayList;
import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.context.N_MdxSessionContext;
import crazydev.iccube.cluster.node.context.N_MdxStatementRequestContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextInitData;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorNode;
import crazydev.iccube.collection.olapiterator.fastcj.OlapFastCrossjoinIterator;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapOrTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapOne;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBuffer;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class N_FastCrossjoinContext
implements N_CancellingContext {
    @Nullable
    public static Integer TEST_CJ_CACHE_LIMIT = null;
    private final N_MdxStatementRequestContext owner;
    private final boolean neCrossjoinBitmapCacheActivated;
    private final int neCrossjoinBitmapCacheLimit;
    private final S_FastCrossjoinContextRef ref;
    private final OlapFastCrossjoinContext context;
    private final Map<N_FactPage, OlapFactsBitmap> bitmaps = new ConcurrentHashMap<N_FactPage, OlapFactsBitmap>();
    private final Map<N_FactPage, List<OlapScalarEntityFactColumn>> nonEmptyBehaviorColumns = new ConcurrentHashMap<N_FactPage, List<OlapScalarEntityFactColumn>>();
    private final Map<N_FactPage, OlapFactsBitmapRoaringBuffer[][]> getForReadCache = new ConcurrentHashMap<N_FactPage, OlapFactsBitmapRoaringBuffer[][]>();
    private S_FactTuplesDef[] listTuples;
    private boolean[] listTuplesCached;
    private N_MeasureGroup[] sortedMeasureGroups = null;

    public N_FastCrossjoinContext(N_MdxStatementRequestContext owner, S_FastCrossjoinContextInitData data) {
        int limit;
        this.owner = owner;
        this.neCrossjoinBitmapCacheLimit = limit = TEST_CJ_CACHE_LIMIT == null ? owner.getNonEmptyCrossjoinBitmapCacheLimit() : TEST_CJ_CACHE_LIMIT.intValue();
        this.neCrossjoinBitmapCacheActivated = limit != 0;
        OlapLoggers.MDX_EVALUATION_FAST_CROSSJOIN.debug((Object)("[fast-crossjoin] non-empty index cache activated : " + this.neCrossjoinBitmapCacheActivated));
        OlapLoggers.MDX_EVALUATION_FAST_CROSSJOIN.debug((Object)("[fast-crossjoin] non-empty index cache limit : " + this.neCrossjoinBitmapCacheLimit));
        this.ref = data.getRef();
        this.ref.setReferenced(this);
        this.context = data.getRef().context();
    }

    public N_MdxSessionContext getSessionContext() {
        return this.owner.getSessionContext();
    }

    public S_FastCrossjoinContextRef getRef() {
        return this.ref;
    }

    public N_Schema getSchemaContext() {
        return this.owner.getSchemaContext();
    }

    @Override
    public boolean isCancelling() {
        return this.owner.isCancelling();
    }

    public void init(N_FactPage factPage, OlapTupleDimensionality cjTupleDimensionality) {
        this.bitmaps.putIfAbsent(factPage, factPage.createGlobalBitmapForCj(this.owner.getMdxRequestContext(), cjTupleDimensionality));
    }

    public void initSet(CdArrayList<S_FactTuplesDef> filteredTuples) {
        int limit = this.neCrossjoinBitmapCacheLimit / this.bitmaps.size();
        this.listTuples = (S_FactTuplesDef[])filteredTuples.toArray((Object[])new S_FactTuplesDef[0]);
        this.listTuplesCached = new boolean[this.listTuples.length];
        int cumSize = 0;
        for (int i = 1; i < this.listTuples.length; ++i) {
            int listSize = this.listTuples[i].size();
            if (cumSize + listSize > limit) continue;
            cumSize += listSize;
            this.listTuplesCached[i] = true;
        }
    }

    public OlapFactsBitmap getGlobalBitmap(N_FactPage factPage) {
        OlapFactsBitmap bitmap = this.bitmaps.get(factPage);
        return bitmap;
    }

    public S_FactTuplesDef getInitialSet(int index) {
        return this.listTuples[index];
    }

    public void addToGlobalFilter(N_FactPage factPage, IFactsBitmapOrTor orTorFilter) {
        if (orTorFilter.noAdds()) {
            return;
        }
        OlapFactsBitmap bitmapFilter = orTorFilter.facts_asBitmap();
        if (bitmapFilter == null || OlapFactsBitmapOne.isOneBitmap(bitmapFilter)) {
            return;
        }
        IFactsBitmapAndTor andTor = OlapFactsBitmapAggregation.facts_createBitmapAndTor();
        andTor.add(this.bitmaps.get(factPage));
        andTor.add(bitmapFilter);
        this.bitmaps.put(factPage, andTor.facts_asBitmap());
    }

    public N_MeasureGroup[] getSortedMeasureGroupsByRowSize(S_NonEmptyBehavior nonEmptyBehavior, Function<OlapFactMeasureGroupBaseManager, N_MeasureGroup> measureGroupF) {
        if (this.sortedMeasureGroups == null) {
            N_MeasureGroup[] measuregroups = (N_MeasureGroup[])nonEmptyBehavior.getNodes().stream().map(t -> (N_MeasureGroup)measureGroupF.apply(t.getMeasureGroupRef())).toArray(N_MeasureGroup[]::new);
            Long[] measureGroupSize = (Long[])Arrays.stream(measuregroups).map(N_MeasureGroup::getRowCount).toArray(Long[]::new);
            this.sortedMeasureGroups = (N_MeasureGroup[])IntStream.range(0, measuregroups.length).boxed().sorted((i, j) -> Long.compare(measureGroupSize[i], measureGroupSize[j])).map(pos -> measuregroups[pos]).toArray(N_MeasureGroup[]::new);
        }
        return this.sortedMeasureGroups;
    }

    public void initCjTableContext(N_FactPage factPage) {
    }

    public List<OlapScalarEntityFactColumn> getFactColumnsWithNulls(S_NonEmptyBehavior nonEmptyBehavior, N_FactPage factPage) {
        List cols = this.nonEmptyBehaviorColumns.computeIfAbsent(factPage, page -> {
            ArrayList<OlapScalarEntityFactColumn> columns = new ArrayList<OlapScalarEntityFactColumn>();
            S_NonEmptyBehaviorNode node = nonEmptyBehavior.getNode(factPage.getMeasureGroupDef());
            List<OlapMeasureMember> measures = node.getMeasures();
            ArrayList<OlapMeasureMember> addedMeasures = new ArrayList<OlapMeasureMember>();
            if (measures != null && measures.size() == 1) {
                OlapMeasureMember measure = measures.getFirst();
                S_MeasureRef[] refs = measure.getClusterRefs();
                if (refs.length != 1) throw new RuntimeException("internal error: unexpected missing ref. for measure [" + measure.getNameX() + "] [" + refs.length + "]");
                Object def = refs[0].getReferenced();
                if (def instanceof S_MeasureDef) {
                    S_MeasureDef measureDef = (S_MeasureDef)def;
                    OlapScalarEntityFactColumn col = factPage.getColumn(measureDef);
                    if (col.hasNulls()) {
                        columns.add(col);
                        addedMeasures.add(measure);
                    }
                } else {
                    if (def != null) throw new RuntimeException("internal error: unexpected def. for measure [" + measure.getNameX() + "] [" + def.getClass().getName() + "]");
                    throw new RuntimeException("internal error: unexpected missing def. for measure [" + measure.getNameX() + "]");
                }
            }
            if (addedMeasures.isEmpty()) return columns;
            OlapFastCrossjoinIterator.LOGGER.debug((Object)("[fast-crossjoin] measure with null rows  [" + factPage.getName() + "] : " + addedMeasures.stream().map(OlapMember::getNameX).collect(Collectors.joining(", "))));
            return columns;
        });
        return cols;
    }

    public int getInitialNonEmptyMaxRow() {
        return this.context.getInitialNonEmptyMaxRow();
    }

    public BitmapCache getCacheForTupleBitmaps(N_FactPage factPage, S_FactTuplesDef tuples, int setIndex) {
        if (!this.neCrossjoinBitmapCacheActivated) {
            return (tupleIdx, getter) -> (OlapFactsBitmapRoaringBuffer)getter.apply(tuples.get(tupleIdx));
        }
        OlapFactsBitmapRoaringBuffer[][] cachePerFactPage = this.getForReadCache.computeIfAbsent(factPage, f -> {
            OlapFactsBitmapRoaringBuffer[][] cachedTuples = new OlapFactsBitmapRoaringBuffer[this.listTuplesCached.length][];
            for (int ii = 0; ii < this.listTuplesCached.length; ++ii) {
                if (!this.listTuplesCached[ii]) continue;
                cachedTuples[ii] = new OlapFactsBitmapRoaringBuffer[this.listTuples[ii].size()];
            }
            return cachedTuples;
        });
        OlapFactsBitmapRoaringBuffer[] cachedTuples = cachePerFactPage[setIndex];
        if (cachedTuples == null) {
            return (tupleIdx, getter) -> (OlapFactsBitmapRoaringBuffer)getter.apply(tuples.get(tupleIdx));
        }
        return (tupleIdx, getter) -> {
            OlapFactsBitmapRoaringBuffer roaring = cachedTuples[tupleIdx];
            if (roaring == null) {
                roaring = cachedTuples[tupleIdx] = (OlapFactsBitmapRoaringBuffer)getter.apply(tuples.get(tupleIdx));
            }
            return roaring;
        };
    }

    public void logOnCompleted(Logger logger) {
    }

    @FunctionalInterface
    public static interface BitmapCache {
        public OlapFactsBitmapRoaringBuffer computeIfAbsent(int var1, Function<S_FactTupleDef, OlapFactsBitmapRoaringBuffer> var2);
    }
}

