/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.schema;

import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaFactFilterLine;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class M_SchemaSubCubeFactory {
    public static boolean NON_MAPPED_PERMISSIONS_ACTIVATED = true;

    private M_SchemaSubCubeFactory() {
    }

    public static S_FactSubCube create(@Nullable OlapAbstractCategoryMember category, OlapSubCubeEntity entity) {
        return entity.asClusterCube(category);
    }

    @Nullable
    public static S_FactSubCube createForSlicer(OlapResSlicer slicer) {
        List<OlapTuple> tupleList = slicer.getTupleList();
        S_FactSubCube suCube = new S_FactSubCube(S_FactSubCube.Operation.OR);
        for (int i = 0; i < tupleList.size(); ++i) {
            OlapTuple olapTuple = tupleList.get(i);
            S_FactSubCube tupleSubCube = M_SchemaSubCubeFactory.createTupleSubCube(olapTuple);
            suCube.addSubCube(tupleSubCube);
        }
        S_FactSubCube asNonEmpty = suCube.asNonEmpty();
        return asNonEmpty;
    }

    @Nullable
    public static S_FactSubCube createForSubSelect(@Nullable List<List<OlapTuple>> axes, @Nullable List<OlapSubCubeEntity> subCubes) {
        if ((axes == null || axes.isEmpty()) && (subCubes == null || subCubes.isEmpty())) {
            return null;
        }
        S_FactSubCube subSelectSubCube = new S_FactSubCube(S_FactSubCube.Operation.AND);
        if (axes != null) {
            for (List list : axes) {
                S_FactSubCube axisSubCube = new S_FactSubCube(S_FactSubCube.Operation.OR);
                for (OlapTuple tuple : list) {
                    axisSubCube.addSubCube(M_SchemaSubCubeFactory.createTupleSubCube(tuple));
                }
                subSelectSubCube.addSubCube(axisSubCube);
            }
        }
        if (subCubes != null) {
            for (OlapSubCubeEntity olapSubCubeEntity : subCubes) {
                subSelectSubCube.addSubCube(olapSubCubeEntity.asClusterCube(null));
            }
        }
        return subSelectSubCube.asNonEmpty();
    }

    @Nullable
    public static S_FactSubCube createForPerms(List<OlapRoleFlatSchemaFactFilterLine> lines) {
        if (lines.isEmpty()) {
            return null;
        }
        OlapRoleFlatSchemaFactFilterLine line = lines.get(0);
        S_FactSubCube entitySubCube = M_SchemaSubCubeFactory.createEntitySubCube(line.entity);
        S_FactSubCube subCube = line.plus ? entitySubCube : new S_FactSubCube(S_FactSubCube.Operation.NOT, entitySubCube);
        int filterLinesCount = lines.size();
        for (int ii = 1; ii < filterLinesCount; ++ii) {
            line = lines.get(ii);
            entitySubCube = M_SchemaSubCubeFactory.createEntitySubCube(line.entity);
            subCube = line.plus ? new S_FactSubCube(S_FactSubCube.Operation.OR, subCube, entitySubCube) : new S_FactSubCube(S_FactSubCube.Operation.AND, subCube, new S_FactSubCube(S_FactSubCube.Operation.NOT, entitySubCube));
        }
        return subCube;
    }

    public static S_FactSubCube createForPerms(@Nullable List<OlapIterator<? extends OlapTuple>> allowedCells, @Nullable List<OlapIterator<? extends OlapTuple>> deniedCells) {
        if (allowedCells == null && deniedCells == null) {
            throw new RuntimeException("internal error: inconsistent permissions");
        }
        S_FactSubCube allowedSubCube = allowedCells != null ? M_SchemaSubCubeFactory.createForPerms(allowedCells, false) : null;
        S_FactSubCube deniedSubCube = deniedCells != null ? M_SchemaSubCubeFactory.createForPerms(deniedCells, true) : null;
        if (allowedSubCube != null && deniedSubCube == null) {
            return allowedSubCube;
        }
        if (allowedSubCube == null && deniedSubCube != null) {
            return deniedSubCube;
        }
        return new S_FactSubCube(S_FactSubCube.Operation.AND, allowedSubCube, deniedSubCube);
    }

    private static S_FactSubCube createForPerms(List<OlapIterator<? extends OlapTuple>> cells, boolean denied) {
        S_FactSubCube subCube = new S_FactSubCube(S_FactSubCube.Operation.OR);
        for (OlapIterator<? extends OlapTuple> cell : cells) {
            OlapTuple tuple;
            cell.reset();
            while ((tuple = cell.next()) != null) {
                subCube.addSubCube(M_SchemaSubCubeFactory.createTupleSubCube(tuple));
            }
        }
        if (denied) {
            return new S_FactSubCube(S_FactSubCube.Operation.NOT, subCube);
        }
        return subCube;
    }

    private static S_FactSubCube createEntitySubCube(OlapEntity entity) {
        if (entity instanceof OlapMember) {
            return new S_FactSubCube(S_FactSubCube.Operation.OR, new S_MemberDef((OlapMember)entity));
        }
        if (entity instanceof OlapTuple) {
            return M_SchemaSubCubeFactory.createTupleSubCube((OlapTuple)entity);
        }
        if (entity instanceof OlapTupleSet) {
            return M_SchemaSubCubeFactory.createTupleSetSubCube((OlapTupleSet)entity);
        }
        throw new RuntimeException("internal error: unexpected entity type [" + entity.getFriendlyTypeName() + "]");
    }

    private static S_FactSubCube createTupleSubCube(OlapTuple tuple) {
        S_FactSubCube tupleSubCube = new S_FactSubCube(S_FactSubCube.Operation.AND);
        int memberCount = tuple.getMemberCount();
        for (int i = 0; i < memberCount; ++i) {
            tupleSubCube.addMember(new S_MemberDef(tuple.getMember(i)));
        }
        return tupleSubCube;
    }

    private static S_FactSubCube createTupleSetSubCube(OlapTupleSet<?> tupleSet) {
        OlapTuple tuple;
        S_FactSubCube setSubCube = new S_FactSubCube(S_FactSubCube.Operation.OR);
        OlapIterator tuples = tupleSet.getIterator(false);
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            setSubCube.addSubCube(M_SchemaSubCubeFactory.createTupleSubCube(tuple));
        }
        return setSubCube;
    }

    public static S_FactSubCube createForCategory(OlapAbstractCategoryMember category) {
        S_FactSubCube subCube;
        if (category.isUnderlyingMember()) {
            subCube = M_SchemaSubCubeFactory.createEntitySubCube(category.getUnderlyingMember());
        } else if (category.getTupleIterator() != null) {
            OlapTuple tuple;
            subCube = new S_FactSubCube(S_FactSubCube.Operation.OR);
            OlapIterator<? extends OlapTuple> tuples = category.getTupleIterator();
            tuples.reset();
            while ((tuple = tuples.next()) != null) {
                S_FactSubCube tupleSubCube = M_SchemaSubCubeFactory.createTupleSubCube(tuple);
                subCube.addSubCube(tupleSubCube);
            }
        } else if (category.getSubCube() != null) {
            subCube = M_SchemaSubCubeFactory.create(category, category.getSubCube());
        } else {
            throw new RuntimeException("internal error: inconsistent category [" + category.getNameX() + "]");
        }
        return subCube;
    }
}

