/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.schema;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderCubeBasedSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_DimensionDef;
import crazydev.iccube.cluster.shared.schema.S_FactsMeasureColumns;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureColumn;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class M_SchemaDefFactory {
    private M_SchemaDefFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static S_SchemaDef createSchemaDef(S_SchemaRef ref, String name, IOlapBuilderSchemaDefFactory definitionFactory, List<OlapDimension> dimensions, IOlapFactListFactory factsColumnListFactory, S_FactBitmapContainerFactory factsBitmapContainerFactory) {
        IOlapBuilderSchemaDef def;
        OlapBuilderConnectionPool connectionPool;
        OlapBuilderErrorManager errorManager;
        if (definitionFactory instanceof OlapBuilderCubeBasedSchemaDefFactory) {
            errorManager = new OlapBuilderErrorManager(true);
            connectionPool = new OlapBuilderConnectionPool();
        } else {
            errorManager = null;
            connectionPool = null;
        }
        try {
            def = definitionFactory.createSchemaDefinition(connectionPool, errorManager);
        }
        finally {
            if (connectionPool != null) {
                connectionPool.close();
            }
        }
        HashMap<Integer, Integer> hierarchyIndexToBaseHierarchyIndices = new HashMap<Integer, Integer>();
        S_SchemaDef cSchema = new S_SchemaDef(ref, name, definitionFactory.incrementalLoadActive(), definitionFactory.useFactPartitioning(), definitionFactory.getDistinctCountOptim(), factsColumnListFactory, factsBitmapContainerFactory, definitionFactory.enableReverseLink());
        OlapNameContext nc = OlapNameContext.DEFAULT_VALUES;
        for (OlapDimension dimension : dimensions) {
            S_DimensionDef cDimension = new S_DimensionDef(dimension.getName(nc));
            for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                S_HierarchyDef cHierarchy = new S_HierarchyDef(hierarchy.getName(nc), hierarchy.isBase(), hierarchy.getTupleDimensionalityIndex(), hierarchy.getMaxUniqueMemberIndex());
                cDimension.addHierarchy(cHierarchy);
                if (hierarchy.isBase()) continue;
                hierarchyIndexToBaseHierarchyIndices.put(hierarchy.getTupleDimensionalityIndex(), dimension.getBaseHierarchy().getTupleDimensionalityIndex());
            }
            cSchema.addDimension(cDimension);
        }
        cSchema.setHierarchyIndexToBaseHierarchyIndices(hierarchyIndexToBaseHierarchyIndices);
        for (IOlapBuilderCubeDef cube : def.getCubes()) {
            S_CubeDef cCube = new S_CubeDef(cSchema, new S_CubeRef(cube.getName()), cube.getName());
            M_SchemaDefFactory.createMeasureGroups(cSchema, cCube, cube);
            cSchema.addCube(cCube);
        }
        return cSchema;
    }

    private static void createMeasureGroups(S_SchemaDef cSchema, S_CubeDef cCube, IOlapBuilderCubeDef cube) {
        for (IOlapBuilderBaseFactsDef facts : cube.getFacts()) {
            S_MeasureGroupRef ref = new S_MeasureGroupRef(facts.getName(), facts.getMeasureGroupName());
            Set<S_HierarchyDef> baseHierarchyIdxs = Collections.emptySet();
            S_MeasureGroupDef cMeasureGroup = new S_MeasureGroupDef(ref, cube.getName(), facts.getName(), facts.getMeasureGroupName(), facts.getPartitioningType(), baseHierarchyIdxs);
            List<IOlapBuilderMeasureDef> measures = facts.getMeasures();
            S_FactsMeasureColumns measureColumnInfos = S_FactsMeasureColumns.create(facts);
            for (int measureDefIndex = 0; measureDefIndex < measures.size(); ++measureDefIndex) {
                IOlapBuilderMeasureDef measureDef = measures.get(measureDefIndex);
                S_MeasureColumn columnInfo = measureColumnInfos.getColumn(measureDef);
                S_MeasureIndex index = new S_MeasureIndex(measureDefIndex, columnInfo.getFactsColumnIndex());
                OlapBuilderInputType factDataType = measureDef.getFactDataType();
                OlapAggregationType hierarchyAggregationType = measureDef.getAggregationType();
                boolean emptyIsZeroAsDouble = hierarchyAggregationType.outputScalarTypeIsDouble(factDataType.isFloatDouble());
                S_MeasureDef cMeasure = new S_MeasureDef(measureDef, cMeasureGroup, index, factDataType, hierarchyAggregationType, emptyIsZeroAsDouble);
                cMeasureGroup.addMeasure(cMeasure);
            }
            cCube.addMeasureGroup(cMeasureGroup);
        }
    }
}

