/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.local.facts;

import crazydev.iccube.cluster.master.facts.M_ClusterSetTupleAggregator;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextInitData;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import org.jetbrains.annotations.Nullable;

public class M_LocalClusterSetTupleAggregator
extends M_ClusterSetTupleAggregator {
    private final M_LocalCluster cluster;
    private final N_OlapEngine engine;
    private final S_MeasureGroupRef measureGroupRef;
    private final OlapTuple lambdaTuple;
    private final OlapBitSet evalTupleD;
    private final S_MdxStatementRequestContextRef statementContextRef;
    private final S_MdxRequestContextRef mdxRequestContextRef;
    private final S_SetEvaluatorContextRef contextRef;
    @Nullable
    private OlapTuple iTuple;

    public M_LocalClusterSetTupleAggregator(M_LocalCluster cluster, S_MeasureGroupRef measureGroupRef, GFContext context, OlapTuple lambdaTuple, GFFactsEvalTuple tuple, OlapBitSet evalTupleD) {
        super(context, tuple);
        this.cluster = cluster;
        this.engine = cluster.getEngine();
        this.measureGroupRef = measureGroupRef;
        this.lambdaTuple = lambdaTuple;
        this.evalTupleD = evalTupleD;
        this.contextRef = new S_SetEvaluatorContextRef(this);
        S_SetEvaluatorContextInitData initData = this.contextRef.createObjectInitData();
        this.statementContextRef = initData.getMdxStatementContextRef();
        this.mdxRequestContextRef = initData.getMdxRequestContextRef();
        cluster.createSetEvaluatorContext(this.sessionContextRef, initData);
    }

    @Override
    public void onFinally() {
        this.cluster.deleteSetEvaluatorContext(this.sessionContextRef, this.mdxStatementContextRef, this.mdxRequestContextRef, this.contextRef);
        super.onFinally();
    }

    public String __debug() {
        return this.measure.getNameX();
    }

    public S_MeasureGroupRef getMeasureGroupRef() {
        return this.measureGroupRef;
    }

    public OlapBitSet getTupleD() {
        return this.evalTupleD;
    }

    @Override
    public void iTuple(@Nullable OlapTuple iTuple) {
        this.iTuple = iTuple;
        IOlapMembers.touchCategories(iTuple);
    }

    private OlapTuple assertIteratedTuple() {
        if (this.iTuple == null) {
            throw new RuntimeException("internal error: missing iterator tuple");
        }
        return this.iTuple;
    }

    @Override
    public OlapScalarEntity aggregateTuple(GFContext context) {
        OlapTuple iTuple = this.assertIteratedTuple();
        OlapInstrExecListener listener = context.getInstrExecListener();
        OlapScalarEntity res = listener != null && context.isInstrExecListening() ? this.doAggregateTupleAndListen(listener, context, iTuple) : this.doAggregateTuple(context, iTuple);
        return res;
    }

    private OlapScalarEntity doAggregateTupleAndListen(OlapInstrExecListener listener, GFContext context, OlapTuple iTuple) {
        GFFactsEvalTuple xTuple = this.tuple.replaceIteratedTupleForSetEvaluation(context, this.lambdaTuple, iTuple);
        listener.beginFactSetTupleAggregation(this.measure, xTuple);
        OlapScalarEntity res = this.doAggregateTuple(context, iTuple);
        listener.endFactSetTupleAggregation(this.measure, xTuple, res);
        return res;
    }

    private OlapScalarEntity doAggregateTuple(GFContext context, OlapTuple iTuple) {
        if (context.isDrillthroughActive()) {
            GFFactsEvalTuple xTuple = this.tuple.replaceIteratedTupleForSetEvaluation(context, this.lambdaTuple, iTuple);
            context.pushCurrentTupleForDrillthrough(xTuple);
        }
        OlapScalarEntity res = this.engine.evalSetTuple(this.sessionContextRef, this.mdxStatementContextRef, this.mdxRequestContextRef, this.contextRef, context, iTuple);
        if (context.isDrillthroughActive()) {
            context.popCurrentTupleForDrillthrough();
        }
        if (iTuple != null && !context.isStatsFrozen()) {
            this.onTupleAggregateSet(iTuple, this.measure);
        }
        return res;
    }
}

