/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.local.facts;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBackupTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartitions;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalTablePartition;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class M_FactsLocalTablePartitions
extends M_FactsLocalPartitions {
    private final Map<IOlapBuilderTablePartitionKey, M_FactsLocalTablePartition> partitions = new ConcurrentHashMap<IOlapBuilderTablePartitionKey, M_FactsLocalTablePartition>();

    public M_FactsLocalTablePartitions(N_OlapEngine engine, M_FactsLocalMeasureGroupManager measureGroup) {
        super(engine, measureGroup);
    }

    @Override
    public OlapPartitioningType getPartitioningType() {
        return OlapPartitioningType.DATA_TABLE_DEFINED;
    }

    @Override
    public boolean isTablePartitioned() {
        return true;
    }

    @Override
    public boolean isLevelPartitioned() {
        return false;
    }

    @Override
    public List<OlapSchemaPartitionInformation> listPartitions(List<OlapSchemaPartitionInformation> partitions, String cube, String measureGroup) {
        for (M_FactsLocalTablePartition partition : this.partitions.values()) {
            this.listPartition(partitions, partition, cube, measureGroup, OlapSchemaPartitionInformation.Kind.TABLE);
        }
        return partitions;
    }

    @Override
    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        for (M_FactsLocalTablePartition partition : this.partitions.values()) {
            OlapLoggers.GENERAL.warn((Object)("[###] facts :   >> " + String.valueOf(partition.getTablePartitionKey())));
            this.getInformationForPerformanceTests(info, schemaRef, cubeRef, measureGroupRef, partition);
        }
    }

    @Override
    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) throws IOException {
        for (M_FactsLocalTablePartition partition : this.partitions.values()) {
            this.dumpIndex(out, hierarchies, schemaRef, cubeRef, measureGroupRef, partition);
        }
    }

    @Override
    public void createStats(OlapStatsContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, Set<OlapDimension> dimensions__) {
        for (M_FactsLocalTablePartition partition : this.partitions.values()) {
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)("[stats] facts :   >> " + String.valueOf(partition.getTablePartitionKey())));
            }
            this.createStats(context, schemaRef, cubeRef, measureGroupRef, statsPerLevel, partitionsStats, partition, dimensions__);
        }
    }

    @Override
    public void createIncrLoadStats(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<OlapFactsPartitionStats> partitionsStats) {
        for (M_FactsLocalTablePartition partition : this.partitions.values()) {
            this.createIncrLoadStats(schemaRef, cubeRef, measureGroupRef, partitionsStats, partition);
        }
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, S_MeasureGroupRef clusterMeasureGroupRef, IOlapBuilderTablePartitionKey tablePartitionKey) {
        S_BuildSchemaContextRef buildContextRef = context.getClusterContextRef();
        if (buildContextRef == null) {
            return;
        }
        M_FactsLocalTablePartition partition = this.partitions.get(tablePartitionKey);
        if (partition != null) {
            S_FactPageRef factPageRef = partition.getFactsPageRef();
            this.engine.onTableRowsProcessingCompleted(buildContextRef, clusterMeasureGroupRef, factPageRef);
        }
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, S_MeasureGroupRef clusterMeasureGroupRef) {
        S_BuildSchemaContextRef buildContextRef = context.getClusterContextRef();
        if (buildContextRef == null) {
            return;
        }
        for (M_FactsLocalTablePartition partition : this.partitions.values()) {
            S_FactPageRef factPageRef = partition.getFactsPageRef();
            this.engine.onTableRowsProcessingCompleted(buildContextRef, clusterMeasureGroupRef, factPageRef);
        }
    }

    @Override
    public M_FactsLocalPartition createEmptyPartition(OlapBuilderFactContext context, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
        if (tablePartitionKey == null) {
            throw new RuntimeException("internal error : missing table partition key");
        }
        if (this.partitions.containsKey(tablePartitionKey)) {
            throw new RuntimeException("internal error : inconsistent existing partition key [facts : " + this.name + "] [" + tablePartitionKey.getStrValue() + "]");
        }
        M_FactsLocalTablePartition partition = this.createPartition(context, tablePartitionKey, true);
        return partition;
    }

    @Override
    public M_FactsLocalTablePartition getOrCreatePartition(OlapBuilderFactContext context, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
        if (tablePartitionKey == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.PARTITION_KEY_MISSING, new Serializable[]{this.name});
        }
        M_FactsLocalTablePartition partition = this.partitions.get(tablePartitionKey);
        if (partition == null) {
            partition = this.createPartition(context, tablePartitionKey, false);
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private M_FactsLocalTablePartition createPartition(OlapBuilderFactContext context, IOlapBuilderTablePartitionKey tablePartitionKey, boolean empty) {
        Map<IOlapBuilderTablePartitionKey, M_FactsLocalTablePartition> map = this.partitions;
        synchronized (map) {
            M_FactsLocalTablePartition partition = this.partitions.get(tablePartitionKey);
            if (partition == null) {
                partition = new M_FactsLocalTablePartition(tablePartitionKey.getName(), tablePartitionKey);
                this.createClusterPartition(context, partition, empty);
                this.partitions.put(tablePartitionKey, partition);
            }
            return partition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restorePartition(OlapBuilderFactContext context, int backupID, String nameForStats, OlapBuilderInputType keyInputType, String keyValue) {
        Map<IOlapBuilderTablePartitionKey, M_FactsLocalTablePartition> map = this.partitions;
        synchronized (map) {
            OlapBuilderBackupTablePartitionKey partitionKey = new OlapBuilderBackupTablePartitionKey(keyInputType, keyValue);
            M_FactsLocalTablePartition partition = this.partitions.get(partitionKey);
            if (partition != null) {
                throw new RuntimeException("internal error: restore duplicated (table) partition [" + nameForStats + "] [" + this.name + "]");
            }
            partition = new M_FactsLocalTablePartition(backupID, partitionKey.getName(), partitionKey);
            this.createClusterPartition(context, partition, false);
            this.partitions.put(partitionKey, partition);
        }
    }

    @Override
    public boolean adoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, M_FactsLocalPartitions loadedPartitions) {
        if (loadedPartitions instanceof M_FactsLocalTablePartitions) {
            boolean adopted = this.doAdoptPartitions(context, bContext, schemaRef, cubeRef, measureGroupRef, (M_FactsLocalTablePartitions)loadedPartitions);
            return adopted;
        }
        throw new RuntimeException("internal error: (adopt-partitions) [" + this.name + "] inconsistent usage (" + this.getClass().getSimpleName() + "/" + loadedPartitions.getClass().getSimpleName() + ")");
    }

    private boolean doAdoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, M_FactsLocalTablePartitions loadedPartitions) {
        Logger schemaLogger = context.getSchemaLogger();
        if (schemaLogger.isInfoEnabled()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts manager adopting (table) partitions [" + this.name + "]"));
        }
        boolean adopted = false;
        if (context.isLoadMeasureGroup() && !this.partitions.isEmpty()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts manager adopting (table) delete all partitions [" + this.partitions.size() + "]"));
            for (M_FactsLocalTablePartition partition : this.partitions.values()) {
                context.registerAsReLoadedPartition(partition.getTablePartitionKey().getName());
            }
            this.partitions.clear();
            context.adoptUnresolvedRowsRemoveMeasureGroup(bContext, this.measureGroup);
            this.engine.unloadMeasureGroup(schemaRef, cubeRef, measureGroupRef);
            adopted = true;
        }
        Collection<M_FactsLocalTablePartition> loadedPartitions_ = loadedPartitions.partitions.values();
        for (M_FactsLocalTablePartition loadedPartition : loadedPartitions_) {
            IOlapBuilderTablePartitionKey loadedTablePartitionKey = loadedPartition.getTablePartitionKey();
            if (loadedTablePartitionKey == null) {
                throw new RuntimeException("internal error: [" + this.name + "] inconsistent loaded (table) partition (missing partition key)");
            }
            M_FactsLocalTablePartition partition = this.partitions.get(loadedTablePartitionKey);
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts manager adopting (table) partition [" + loadedTablePartitionKey.getName() + "] [existing:" + (partition != null) + "]"));
            }
            S_FactPageRef partitionRef = partition != null ? partition.getFactsPageRef() : null;
            S_FactPageRef loadedPartitionRef = loadedPartition.getFactsPageRef();
            this.engine.adoptPartitions(schemaRef, cubeRef, measureGroupRef, partitionRef, loadedPartitionRef);
            this.partitions.put(loadedPartition.getTablePartitionKey(), loadedPartition);
            context.adoptUnresolvedRows1(bContext, this.measureGroup, loadedPartition.getTablePartitionKey());
            if (partition != null) {
                context.registerAsReLoadedPartition(loadedTablePartitionKey.getName());
            } else {
                context.registerAsNewPartition(loadedTablePartitionKey.getName());
            }
            adopted = true;
        }
        loadedPartitions.partitions.clear();
        return adopted;
    }

    @Override
    public boolean unloadPartitions(OlapBuilderUnloadPartitionsContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<String> partitionKeys) {
        Logger schemaLogger = context.getSchemaLogger();
        boolean unloaded = false;
        ArrayList<S_FactPageRef> partitionRefs = new ArrayList<S_FactPageRef>();
        for (String partitionKey : partitionKeys) {
            M_FactsLocalTablePartition partition = this.getPartition(partitionKey);
            if (partition != null) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " schema [" + this.measureGroup.getSchemaName() + "] cube [" + this.measureGroup.getCubeName() + "] facts [" + this.measureGroup.getMeasureGroupName() + "] unloading partition [" + partitionKey + "]"));
                }
                partitionRefs.add(partition.getFactsPageRef());
                this.partitions.remove(partition.getTablePartitionKey());
                context.setupUnloadPartitionForBackup(this.measureGroup, partition);
                context.registerAsUnloadedPartition(partitionKey);
                unloaded = true;
                continue;
            }
            if (!schemaLogger.isInfoEnabled()) continue;
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " schema [" + this.measureGroup.getSchemaName() + "] cube [" + this.measureGroup.getCubeName() + "] facts [" + this.measureGroup.getMeasureGroupName() + "] unloading partition [" + partitionKey + "] IGNORED"));
        }
        if (!partitionRefs.isEmpty()) {
            this.engine.unloadPartitions(schemaRef, cubeRef, measureGroupRef, partitionRefs);
        }
        return unloaded;
    }

    @Nullable
    private M_FactsLocalTablePartition getPartition(String partitionKey) {
        IOlapBuilderTablePartitionKey pKey = this.getKeys(partitionKey);
        if (pKey != null) {
            M_FactsLocalTablePartition partition = this.partitions.get(pKey);
            return partition;
        }
        return null;
    }

    @Nullable
    private IOlapBuilderTablePartitionKey getKeys(String partitionKey) {
        for (IOlapBuilderTablePartitionKey key : this.partitions.keySet()) {
            if (!key.getStrValue().equals(partitionKey)) continue;
            return key;
        }
        return null;
    }

    @Override
    public void clearOnIncrLoadFullReload(OlapBuilderContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        IOlapContextLoggers loggers = context.getLoggers();
        Logger logger = loggers.schema();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[schema] schema [" + this.measureGroup.getSchemaName() + "] cube [" + this.measureGroup.getCubeName() + "] facts [" + this.measureGroup.getMeasureGroupName() + "] clear-on-incr-load-full-reload (table)"));
        }
        this.partitions.clear();
        this.engine.clearOnIncrLoadFullReload(schemaRef, cubeRef, measureGroupRef);
    }
}

