/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.local.facts;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfo;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalLevelPartitions;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalNoPartitions;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartitions;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalTablePartitions;
import crazydev.iccube.cluster.master.local.facts.M_LocalClusterRegularTupleAggregator;
import crazydev.iccube.cluster.master.local.facts.M_LocalClusterSetTupleAggregator;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDimensionality;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class M_FactsLocalMeasureGroupManager
extends OlapFactMeasureGroupBaseManager {
    private final M_LocalCluster cluster;
    private final N_OlapEngine engine;
    private final OlapCube cube;
    private final IOlapBuilderBaseFactsDef factsDefinition;
    private final M_FactsLocalPartitions partitions;
    private S_CubeRef clusterCubeRef;
    private S_MeasureGroupRef clusterMeasureGroupRef;

    public M_FactsLocalMeasureGroupManager(OlapBuilderContext context, IOlapFactListFactory factsColumnListFactory, S_FactBitmapContainerFactory factsBitmapContainerFactory, OlapCube cube, IOlapBuilderBaseFactsDef factsDefinition, OlapPartitioningType partitionType) {
        super(factsColumnListFactory, factsBitmapContainerFactory, cube, factsDefinition, partitionType);
        this.cluster = context.getCluster();
        this.engine = this.cluster.getEngine();
        this.cube = cube;
        this.factsDefinition = factsDefinition;
        switch (partitionType) {
            case NONE: {
                this.partitions = new M_FactsLocalNoPartitions(this.engine, this);
                break;
            }
            case DATA_TABLE_DEFINED: {
                this.partitions = new M_FactsLocalTablePartitions(this.engine, this);
                break;
            }
            case OLAP_LEVEL_DEFINED: {
                OlapLevel partitioningLevel = factsDefinition.getPartitioningLevel();
                if (partitioningLevel == null) {
                    throw new RuntimeException("internal error: missing partitioning level for measure group [" + this.getName() + "]");
                }
                this.partitions = new M_FactsLocalLevelPartitions(this.engine, this, partitioningLevel);
                break;
            }
            default: {
                throw new RuntimeException("internal error: [" + factsDefinition.getName() + "] unexpected partition type [" + String.valueOf((Object)partitionType) + "]");
            }
        }
    }

    public OlapPartitioningType getPartitioningType() {
        return this.partitions.getPartitioningType();
    }

    @Override
    public void setupClusterInformation() {
        S_SchemaDef schemaDef = this.cube.getSchema().getClusterSchemaDef();
        S_CubeDef cubeDef = schemaDef.resolveCube(this.cube.getName(OlapNameContext.DEFAULT_VALUES));
        S_MeasureGroupDef measureGroupDef = cubeDef.getMeasureGroup(this.factsDefinition.getName());
        this.clusterCubeRef = cubeDef.getRef();
        this.clusterMeasureGroupRef = measureGroupDef.getRef();
    }

    @Override
    public void setupClusterBuildFactContext(OlapBuilderFactContext context) {
        if (this.clusterCubeRef == null || this.clusterMeasureGroupRef == null) {
            throw new RuntimeException("internal error: schema (" + this.cube.getSchema().getName() + ") cube (" + this.cube.getNameX() + ") missing cluster setup");
        }
        context.setCubeRef(this.clusterCubeRef);
        context.setMeasureGroupRef(this.clusterMeasureGroupRef);
    }

    @Override
    public S_MeasureGroupRef getClusterRef() {
        if (this.clusterMeasureGroupRef == null) {
            throw new RuntimeException("internal error: schema (" + this.cube.getSchema().getName() + ") cube (" + this.cube.getNameX() + ") missing cluster setup");
        }
        return this.clusterMeasureGroupRef;
    }

    @Override
    public boolean isTablePartitioned() {
        return this.partitions.isTablePartitioned();
    }

    @Override
    public boolean isLevelPartitioned() {
        return this.partitions.isLevelPartitioned();
    }

    @Override
    public void restorePartition(OlapBuilderFactContext context, int backupID, String nameForStats, OlapBuilderInputType keyInputType, String keyValue) {
        this.partitions.restorePartition(context, backupID, nameForStats, keyInputType, keyValue);
    }

    @Override
    public void addFactEmptyRow(OlapBuilderFactContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey) {
        this.partitions.createEmptyPartition(context, partitionKey);
    }

    @Override
    public void addFactRows(OlapBuilderFactContext context, N_FactPageBatchInfo info) {
        this.partitions.addFactRows(context, info);
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, IOlapBuilderTablePartitionKey tablePartitionKey) {
        this.partitions.onTableRowsProcessingCompleted(context, this.clusterMeasureGroupRef, tablePartitionKey);
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context) {
        this.partitions.onTableRowsProcessingCompleted(context, this.clusterMeasureGroupRef);
    }

    @Override
    public void onProcessFactsCompleted(OlapBuilderContext context, OlapFileCleaner cleaner) {
        S_BuildSchemaContextRef buildContextRef = context.getClusterContextRef();
        if (buildContextRef == null) {
            return;
        }
        M_LocalCluster cluster = context.getCluster();
        N_OlapEngine engine = cluster.getEngine();
        S_HierarchyDimensionality dimensionalityH = this.createIndexingHierarchiesDimensionality();
        engine.onProcessFactsCompleted(buildContextRef, this.clusterMeasureGroupRef, dimensionalityH);
    }

    @Override
    public void onIncrLoadProcessFactsCompleted(OlapBuilderContext context) {
        S_BuildSchemaContextRef buildContextRef = context.getClusterContextRef();
        if (buildContextRef == null) {
            return;
        }
        M_LocalCluster cluster = context.getCluster();
        N_OlapEngine engine = cluster.getEngine();
        engine.onIncrLoadProcessFactsCompleted(buildContextRef, this.clusterMeasureGroupRef);
    }

    @Override
    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(GFContext context, OlapTuple tuple) {
        boolean noEmptyEvaluation = false;
        boolean fromAxis = false;
        GFFactsEvalTuple evalTuple = (GFFactsEvalTuple)context.setupEvalTuple(false, false, tuple);
        if (evalTuple.isFilteredOut()) {
            return member -> false;
        }
        OlapCalculatedMember calcMember = evalTuple.getHighestPriorityMember();
        if (calcMember != null) {
            throw new OlapEvaluationException(context, OlapErrorCode.UNEXPECTED_CALC_MEMBER, new Serializable[]{calcMember.getUniqueName(context.getNameContext())});
        }
        evalTuple.touchCategories();
        M_LocalClusterRegularTupleAggregator aggregator = new M_LocalClusterRegularTupleAggregator(this.cluster, this.clusterMeasureGroupRef, context, evalTuple);
        return aggregator.getFastNonEmptyFilter(context);
    }

    @Override
    public M_LocalClusterRegularTupleAggregator createClusterTupleAggregator(GFContext context, GFFactsEvalTuple evalTuple) {
        evalTuple.touchCategories();
        M_LocalClusterRegularTupleAggregator aggregator = new M_LocalClusterRegularTupleAggregator(this.cluster, this.clusterMeasureGroupRef, context, evalTuple);
        return aggregator;
    }

    @Override
    public M_LocalClusterSetTupleAggregator createClusterSetTupleAggregator(GFContext context, OlapTuple lambdaTuple, GFFactsEvalTuple evalTuple, OlapBitSet evalTupleD) {
        evalTuple.touchCategories();
        M_LocalClusterSetTupleAggregator aggregator = new M_LocalClusterSetTupleAggregator(this.cluster, this.clusterMeasureGroupRef, context, lambdaTuple, evalTuple, evalTupleD);
        return aggregator;
    }

    @Override
    public OlapScalarEntityFactColumn[] getColumnsForTest__() {
        Serializable res = this.engine.factsColumnForTests__();
        return (OlapScalarEntityFactColumn[])res;
    }

    @Override
    public boolean measureHasNullsInFactColumns(OlapMeasureMember measure) {
        OlapSchema schema = this.cube.getSchema();
        return this.engine.measureHasNullsInFactColumns(schema.getClusterRef(), this.clusterMeasureGroupRef, measure);
    }

    @Override
    public String sizeInRows() {
        OlapSchema schema = this.cube.getSchema();
        return this.engine.sizeInRows(schema.getClusterRef(), this.clusterMeasureGroupRef);
    }

    @Override
    public int sizeInRowsEx() {
        OlapSchema schema = this.cube.getSchema();
        return this.engine.sizeInRowsEx(schema.getClusterRef(), this.clusterMeasureGroupRef);
    }

    @Override
    public int partitionCount() {
        OlapSchema schema = this.cube.getSchema();
        return this.engine.partitionCount(schema.getClusterRef(), this.clusterMeasureGroupRef);
    }

    @Override
    public void deleteCategoryHierarchyBitmaps(OlapHierarchy hierarchy) {
    }

    @Override
    public List<OlapSchemaPartitionInformation> listPartitions(List<OlapSchemaPartitionInformation> partitions, String cube, String measureGroup) {
        return this.partitions.listPartitions(partitions, cube, measureGroup);
    }

    @Override
    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info) {
        this.partitions.getInformationForPerformanceTests(info, this.cube.getSchema().getClusterRef(), this.clusterCubeRef, this.clusterMeasureGroupRef);
    }

    @Override
    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies) throws IOException {
        this.partitions.dumpIndex(out, hierarchies, this.cube.getSchema().getClusterRef(), this.clusterCubeRef, this.clusterMeasureGroupRef);
    }

    @Override
    protected void createStats(OlapStatsContext context, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats) {
        HashSet<OlapDimension> dimensions__ = new HashSet<OlapDimension>();
        for (OlapDimension dimension : this.cube.getDimensions()) {
            if (!dimension.isFactIndexing() || !this.containsDimension(dimension)) continue;
            dimensions__.add(dimension);
        }
        this.partitions.createStats(context, this.cube.getSchema().getClusterRef(), this.clusterCubeRef, this.clusterMeasureGroupRef, statsPerLevel, partitionsStats, dimensions__);
    }

    @Override
    protected void createIncrLoadStats(List<OlapFactsPartitionStats> partitionsStats) {
        this.partitions.createIncrLoadStats(this.cube.getSchema().getClusterRef(), this.clusterCubeRef, this.clusterMeasureGroupRef, partitionsStats);
    }

    @Override
    public boolean adoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, OlapFactMeasureGroupBaseManager loadedMeasureGroupManager) {
        M_FactsLocalMeasureGroupManager loadedMeasureGroupManager_ = (M_FactsLocalMeasureGroupManager)loadedMeasureGroupManager;
        OlapSchema schema = this.cube.getSchema();
        boolean adopted = this.partitions.adoptPartitions(context, bContext, schema.getClusterRef(), this.clusterCubeRef, this.clusterMeasureGroupRef, loadedMeasureGroupManager_.partitions);
        return adopted;
    }

    @Override
    public boolean unloadPartitions(OlapBuilderUnloadPartitionsContext context, List<String> partitionKeys) {
        OlapSchema schema = this.cube.getSchema();
        boolean unloaded = this.partitions.unloadPartitions(context, schema.getClusterRef(), this.clusterCubeRef, this.clusterMeasureGroupRef, partitionKeys);
        return unloaded;
    }

    @Override
    public void clearOnIncrLoadFullReload(OlapBuilderContext context) {
        OlapSchema schema = this.cube.getSchema();
        this.partitions.clearOnIncrLoadFullReload(context, schema.getClusterRef(), this.clusterCubeRef, this.clusterMeasureGroupRef);
    }
}

