/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.local.backup;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartition;
import crazydev.iccube.cluster.master.backup.save.M_BackupContext;
import crazydev.iccube.cluster.master.local.backup.M_LocalNodeBackupManagerDebug;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_BackupManager;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class M_LocalNodeBackupManager
implements N_BackupManager {
    public static M_LocalNodeBackupManagerDebug debug_ = null;

    @Override
    public void saveFacts(Object backup, N_MeasureGroup measureGroup) {
        final M_BackupContext context = (M_BackupContext)backup;
        if (context.isOnError()) {
            return;
        }
        N_BackupContext bContext = new N_BackupContext(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isCancelling() {
                return context.isCancelling();
            }
        };
        long startMS = System.currentTimeMillis();
        OlapLoggers.BACKUP.info((Object)("[backup] saving measure group [" + measureGroup.getName() + "] for schema [" + measureGroup.getSchemaName() + "]"));
        try {
            OlapEngineBackupConfiguration configuration = context.getConfiguration();
            File dir = context.getFactsDir();
            measureGroup.savePartitionsContent(bContext, configuration, dir);
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("unexpected error for backup [" + context.getInfoForError() + "]", ex);
        }
        OlapLoggers.BACKUP.info((Object)("[backup] saved measure group [" + measureGroup.getName() + "] for schema [" + measureGroup.getSchemaName() + "] [" + CdTimeUtils.formatMillisEx((long)startMS) + "]"));
    }

    @Override
    public void restoreFacts(Object backup, N_Schema schema) {
        final M_RestoreContext context = (M_RestoreContext)backup;
        final OlapBuilderContext bContext = context.getBuildContext();
        N_RestoreContext rContext = new N_RestoreContext(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isVersion0() {
                return context.isVersion0();
            }

            @Override
            public boolean isVersion1() {
                return context.isVersion1();
            }

            @Override
            public OlapFileCleaner getFileCleaner() {
                return bContext.getFileCleaner();
            }

            @Override
            public boolean isCancelling() {
                return context.isCancelling();
            }
        };
        OlapLoggers.BACKUP.info((Object)("[backup] restoring facts for schema [" + schema.getName() + "]"));
        S_BackupMode mode = context.getMode();
        if (S_BackupMode.FULL_LOAD != mode && S_BackupMode.LOAD_PARTITIONS != mode && S_BackupMode.LOAD_MEASURE_GROUPS != mode) {
            throw new RuntimeException("internal error: unexpected restore mode [" + String.valueOf((Object)mode) + "]");
        }
        OlapEngineBackupConfiguration configuration = context.getConfiguration();
        File factsDir = context.getFactsDir();
        List<M_RestorePartition> partitions = context.getRestoringPartitions();
        for (M_RestorePartition partition : partitions) {
            String cubeName = partition.getCubeName();
            String measureGroupNameF = partition.getMeasureGroupNameF();
            bContext.onRestorePartitionStarted(measureGroupNameF, partition.getNameForStats(), new Date());
            OlapLoggers.BACKUP.info((Object)("[backup] restoring facts [" + cubeName + "] [" + measureGroupNameF + "] partition [" + partition.getNameForStats() + "/" + partition.getID() + "]"));
            N_MeasureGroup measureGroup = S_BackupMode.FULL_LOAD == mode ? schema.getMeasureGroupForFullLoadRestore(cubeName, measureGroupNameF) : schema.getMeasureGroupForLoadPartitionsRestore(cubeName, measureGroupNameF);
            try {
                long rowCount = measureGroup.restorePartitionContent(rContext, configuration, factsDir, partition.getID(), partition.getNameForStats());
                bContext.onRestorePartitionCompleted(measureGroupNameF, partition.getNameForStats(), new Date(), rowCount);
                if (debug_ == null) continue;
                debug_.registerLoadedPartition(partition.getKeyValue());
            }
            catch (IOException ex) {
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"could not restore measure group [" + measureGroup.getName() + "]", ex});
            }
        }
    }
}

