/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.save;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartitionManager;
import crazydev.iccube.cluster.master.backup.save.M_BackupCompacter;
import crazydev.iccube.cluster.shared.backup.S_RestoreMode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;

public class M_BackupShrinker {
    private M_RestorePartitionManager manager;
    private M_BackupCompacter.PartitionCompacter compacter;

    public void performFullCompacting(CdVFileSystem vfs, String schemaName, File backupDir) throws IOException {
        OlapLoggers.BACKUP.info((Object)("[backup] compacting partitions : full shrink [" + schemaName + "] [" + backupDir.getAbsolutePath() + "]"));
        try {
            this.compacter = new M_BackupCompacter.PartitionCompacter(schemaName, backupDir);
            this.manager = new M_RestorePartitionManager(vfs, schemaName, S_RestoreMode.FULL, backupDir);
            this.manager.forEachCompactingPartitions(this.compacter);
            OlapLoggers.BACKUP.info((Object)("[backup] compacting partitions : full shrink [" + schemaName + "] [hit: " + CdStringUtils.formatNice((long)this.compacter.hit.get()) + " ] [miss: " + CdStringUtils.formatNice((long)this.compacter.miss.get()) + " ]"));
        }
        catch (IOException | RuntimeException ex) {
            this.manager = null;
            this.compacter = null;
            throw ex;
        }
    }

    public void performIncrCompacting(String schemaName, File backupDir, String timestamp) throws IOException {
        OlapLoggers.BACKUP.info((Object)"[backup] compacting partitions : incr. shrink");
        if (this.manager == null || this.compacter == null) {
            OlapLoggers.BACKUP.info((Object)"[backup] compacting partitions : incr. shrink not performed");
            return;
        }
        if (!schemaName.equals(this.manager.getSchemaName()) || !backupDir.equals(this.manager.getRoot())) {
            OlapLoggers.BACKUP.info((Object)("[backup] compacting partitions : incr. shrink not performed [" + schemaName + "] [" + this.manager.getSchemaName() + "] [" + backupDir.getAbsolutePath() + "] [" + this.manager.getRoot().getAbsolutePath() + "]"));
            return;
        }
        this.manager.parseMetaInformationForActivity(timestamp);
        this.manager.forEachCompactingPartitions(this.compacter);
        OlapLoggers.BACKUP.info((Object)("[backup] compacting partitions : incr. shrink [" + schemaName + "] [hit: " + CdStringUtils.formatNice((long)this.compacter.hit.get()) + " ] [miss: " + CdStringUtils.formatNice((long)this.compacter.miss.get()) + " ]"));
    }
}

