/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.save;

import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.cluster.master.backup.save.M_BackupContext;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class M_BackupSavingTableReader
implements IOlapBuilderTableRowReader<IOlapBuilderConnection> {
    private final M_BackupManager backupManager;
    private final M_BackupContext context;
    private final IOlapBuilderTableRowReader underlying;
    private final IOlapBuilderDataTableDef<IOlapBuilderConnection> table;
    private final List<IOlapBuilderDataColumnDef> actualSelectedTableColumns;
    @Nullable
    private S_BackupOutputStream out;
    @Nullable
    private DataOutputStream dOut;

    public M_BackupSavingTableReader(M_BackupManager backupManager, M_BackupContext context, IOlapBuilderTableRowReader underlying) {
        this.backupManager = backupManager;
        this.context = context;
        this.underlying = underlying;
        this.table = underlying.getTable();
        this.actualSelectedTableColumns = this.table.getActualSelectedColumns();
    }

    @Override
    public String getName() {
        return "backup(" + this.underlying.getName() + ")";
    }

    @Override
    public String getTableName() {
        return this.underlying.getTableName();
    }

    @Override
    public String getFullTableNameForEndUser() {
        return this.underlying.getFullTableNameForEndUser();
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.underlying.getPartitionKey();
    }

    @Override
    public IOlapBuilderDataTableDef<IOlapBuilderConnection> getTable() {
        return this.table;
    }

    @Override
    public void init() {
        this.underlying.init();
        this.createStream();
    }

    @Override
    public boolean isRowSafe() {
        return this.underlying.isRowSafe();
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow nextRow() {
        IOlapBuilderTableRow row = this.underlying.nextRow();
        if (row != null) {
            this.writeRow(row);
        }
        return row;
    }

    @Override
    public int rowNb() {
        return this.underlying.rowNb();
    }

    @Override
    public void done() {
        this.underlying.done();
        this.closeStream();
    }

    private void createStream() {
        if (this.context.isOnError()) {
            return;
        }
        try {
            String tableId = this.table.getId();
            S_BackupHelper.appendToFile(new File(this.context.getTablesDir(), "meta-info.txt"), "t:" + tableId + " " + this.table.getName() + "\n");
            String filename = tableId + ".icc-table";
            File file = new File(this.context.getTablesDir(), filename);
            this.out = new S_BackupOutputStream(this.backupManager.getConfiguration(), file);
            this.dOut = new DataOutputStream(this.out);
            int colCount = this.actualSelectedTableColumns.size();
            this.dOut.writeInt(colCount);
            for (int ii = 0; ii < colCount; ++ii) {
                String colName = this.actualSelectedTableColumns.get(ii).getName();
                this.dOut.writeUTF(colName);
            }
        }
        catch (IOException | RuntimeException ex) {
            this.onBackupError(ex);
        }
    }

    private void writeRow(IOlapBuilderTableRow row) {
        if (this.context.isOnError() || this.dOut == null) {
            return;
        }
        try {
            for (IOlapBuilderDataColumnDef selectedColumn : this.actualSelectedTableColumns) {
                Comparable nativeValue = row.getJavaNativeDataValue(selectedColumn);
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(nativeValue);
                serializer.write(this.dOut, nativeValue);
            }
        }
        catch (IOException | RuntimeException ex) {
            this.onBackupError(ex);
        }
    }

    private void closeStream() {
        if (this.context.isOnError()) {
            if (this.out != null) {
                this.out.closeQuietly();
            }
            this.out = null;
            this.dOut = null;
            return;
        }
        try {
            if (this.dOut != null) {
                this.dOut.flush();
            }
            if (this.out != null) {
                this.out.sync();
                this.out.close();
            }
            this.out = null;
            this.dOut = null;
        }
        catch (IOException | RuntimeException ex) {
            this.onBackupError(ex);
        }
    }

    private void onBackupError(Exception ex) {
        OlapLoggers.BACKUP.error((Object)("[backup] unexpected error for backup [" + this.context.getInfoForError() + "]"), (Throwable)ex);
        this.context.setOnError("unexpected error for backup [" + this.context.getInfoForError() + "]", ex);
        if (this.out != null) {
            this.out.closeQuietly();
        }
        this.out = null;
        this.dOut = null;
    }
}

