/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.save;

import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.backup.save.M_DefaultBackupManager;
import crazydev.iccube.cluster.master.backup.save.M_NoBackupManager;
import crazydev.iccube.common.lock.DirectoryLockException;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.directories.OlapClusterConfiguration;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.context.IOlapEngineApplicationContext;
import crazydev.iccube.pub.tenant.OlapTenant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class M_BackupManagerContainer {
    private final boolean backupActive;
    private final OlapEngineBackupConfiguration configuration;
    private final Map<String, M_BackupManager> managers = new ConcurrentHashMap<String, M_BackupManager>();

    public M_BackupManagerContainer(boolean licensed, OlapEngineBackupConfiguration configuration) {
        this(licensed, configuration, null);
    }

    public M_BackupManagerContainer(boolean licensed, OlapEngineBackupConfiguration configuration, @Nullable M_BackupManager rootBackupManager) {
        this.backupActive = licensed && configuration.isActive();
        this.configuration = configuration;
        if (rootBackupManager != null) {
            this.managers.put("$IC3_NO_TENANT_KEY$", rootBackupManager);
        }
    }

    public M_BackupManager getOrCreateBackupManager(OlapRuntimeContext runtimeContext) {
        OlapTenant tenant = runtimeContext.getTenant();
        String tenantName = tenant != null ? tenant.getName() : "$IC3_NO_TENANT_KEY$";
        M_BackupManager manager = this.managers.computeIfAbsent(tenantName, key -> this.createBackupManager(runtimeContext));
        return manager;
    }

    private M_BackupManager createBackupManager(OlapRuntimeContext runtimeContext) {
        IOlapEngineApplicationContext appContext = runtimeContext.getAppContext();
        OlapClusterConfiguration cluster = appContext.getClusterConfiguration();
        OlapDirectoriesResolved directories = runtimeContext.getDirectoriesResolved();
        String tenantInfo = OlapTenant.info(runtimeContext.getTenant());
        M_BackupManager manager = null;
        if (this.backupActive) {
            try {
                manager = new M_DefaultBackupManager(directories.getVfs(), cluster, tenantInfo, this.configuration, directories.getTmpDirectory(), directories.getBackupDirectory());
            }
            catch (DirectoryLockException ex) {
                OlapLoggers.BACKUP.error((Object)("[backup]" + tenantInfo + " could not start the backup manager (backup support disabled)"), (Throwable)ex);
                manager = new M_NoBackupManager(directories.getVfs(), this.configuration, true);
            }
        } else {
            manager = new M_NoBackupManager(directories.getVfs(), this.configuration, false);
        }
        return manager;
    }

    public void shutdownNow() {
        for (M_BackupManager backupManager : this.managers.values()) {
            backupManager.shutdownNow();
        }
    }
}

