/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.save;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdExceptionUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.cluster.master.backup.save.M_BackupCleanupBackupOnErrorJob;
import crazydev.iccube.cluster.master.backup.save.M_BackupCompacter;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.housekeeper.M_HouseKeeper;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;

public class M_BackupContext {
    private static final AtomicLong NEXT_UUID = new AtomicLong(0L);
    private final AtomicInteger NEXT_PARTITION_BACKUP_ID = new AtomicInteger(0);
    private final long uuid = NEXT_UUID.getAndIncrement();
    private final M_BackupManager backupManager;
    private final OlapBuilderContext context;
    private final S_BackupMode mode;
    private final File parentDir;
    private final File dir;
    private volatile boolean factProcessing;
    private volatile boolean m2mProcessing;
    private volatile boolean incrLoadWithoutData;
    private volatile boolean onError;
    private volatile String onErrorMessage;
    @Nullable
    private volatile String onErrorStacktrace;

    public M_BackupContext(M_BackupManager backupManager, OlapBuilderContext context, S_BackupMode mode, File parentDir, File dir) {
        this.backupManager = backupManager;
        this.context = context;
        this.mode = mode;
        this.parentDir = parentDir;
        this.dir = dir;
    }

    public CdVFileSystem getVfs() {
        return this.backupManager.getVfs();
    }

    public OlapEngineBackupConfiguration getConfiguration() {
        return this.backupManager.getConfiguration();
    }

    public boolean isCancelling() {
        return this.context.isCancelling();
    }

    public long getUUID() {
        return this.uuid;
    }

    public String getInfoForError() {
        String schemaName = this.getSchema().getName();
        String timestamp = this.dir.getName();
        return schemaName + " " + timestamp;
    }

    public M_HouseKeeper getHouseKeeper() {
        OlapEngineRequestContext engineContext = this.context.getEngineContext();
        OlapEngineApplicationContext appContext = engineContext.getApplicationContext();
        M_HouseKeeper houseKeeper = appContext.getHouseKeeper();
        return houseKeeper;
    }

    public OlapSchema getSchema() {
        return this.context.getSchema();
    }

    public String getSchemaName() {
        return this.getSchema().getName();
    }

    public S_BackupMode getMode() {
        return this.mode;
    }

    public File getParentDir() {
        return this.parentDir;
    }

    public File getDir() {
        return this.dir;
    }

    public File getTablesDir() {
        return new File(this.dir, "tables");
    }

    public File getM2MsDir() {
        return new File(this.dir, "m2ms");
    }

    public File getBridgesDir() {
        return new File(this.dir, "bridges");
    }

    public File getFactsDir() {
        return new File(this.dir, "facts");
    }

    public File getSavePointsDir() {
        return new File(this.dir, "save-points");
    }

    public File getCubesUnresolvedRowsDir() {
        return new File(this.dir, "unresolved-rows");
    }

    public File getM2MsUnresolvedRowsDir() {
        return this.getM2MsDir();
    }

    public int getNextPartitionBackupID() {
        return this.NEXT_PARTITION_BACKUP_ID.getAndIncrement();
    }

    public boolean isIncrLoad() {
        return this.mode == S_BackupMode.INCR_LOAD;
    }

    public boolean isIncrLoadWithData() {
        return !this.incrLoadWithoutData;
    }

    public boolean isServerWithPartitionHistory() {
        OlapEngineBackupConfiguration configuration = this.getConfiguration();
        boolean withHistory = configuration.isWithPartitionHistory();
        return withHistory;
    }

    public boolean isServerWithBackupHistory() {
        OlapEngineBackupConfiguration configuration = this.getConfiguration();
        boolean withHistory = configuration.isServerWithBackupHistory();
        return withHistory;
    }

    public boolean isContinueBackupOnLoadPartitionsOnError() {
        return this.context.isContinueBackupOnLoadPartitionsOnError();
    }

    public void compact(String timestamp) {
        M_BackupCompacter.compact(this, timestamp);
    }

    public boolean isOnError() {
        return this.onError;
    }

    public void setOnError(String error, @Nullable Exception ex) {
        this.onError = true;
        OlapSchema schema = this.getSchema();
        schema.disableBackupOnError();
        this.onErrorMessage = error;
        if (ex != null) {
            this.onErrorStacktrace = CdExceptionUtils.getStackTraceAsStringX((Throwable)ex);
        }
        OlapEngineRequestContext engineContext = this.context.getEngineContext();
        IcCubeRequestStatusManager statusManager = engineContext.getRequestStatusManager();
        String reqUUID = engineContext.getRequestClientUUID();
        statusManager.onRequestBackupError(reqUUID, new OlapBuilderError(OlapBuilderErrorCode.BACKUP_ERROR, new Serializable[]{this.onErrorMessage}));
        statusManager.onRequestBackupError(reqUUID, new OlapBuilderError(OlapBuilderErrorCode.BACKUP_ERROR_DETAILS, new Serializable[]{this.onErrorStacktrace}));
    }

    public void resetOnError(String reason) {
        this.onError = false;
        OlapSchema schema = this.getSchema();
        schema.resetDisableBackupOnError();
        this.onErrorMessage = null;
        this.onErrorStacktrace = null;
        OlapEngineRequestContext engineContext = this.context.getEngineContext();
        IcCubeRequestStatusManager statusManager = engineContext.getRequestStatusManager();
        String reqUUID = engineContext.getRequestClientUUID();
        statusManager.onRequestBackupError(reqUUID, new OlapBuilderError(OlapBuilderErrorCode.BACKUP_ERROR, new Serializable[]{reason}));
    }

    @Nullable
    public String getBackupError() {
        Object error = null;
        if (this.onErrorMessage != null) {
            error = this.onErrorMessage;
            if (this.onErrorStacktrace != null) {
                error = (String)error + "\n" + this.onErrorStacktrace;
            }
        }
        return error;
    }

    public void cleanupOnError(File dir, boolean onCancelled) {
        boolean keepError;
        OlapEngineRequestContext engineContext = this.context.getEngineContext();
        OlapEngineComponent olapEngine = engineContext.getOlapEngineComponent();
        if (onCancelled) {
            boolean schemaLoaded;
            OlapSchema schema = this.context.getSchema();
            String schemaName = schema.getName();
            keepError = schemaLoaded = olapEngine.isSchemaLoaded(this.context.asRuntimeContext(), schemaName);
        } else {
            keepError = true;
        }
        OlapEngineApplicationContext appContext = engineContext.getApplicationContext();
        M_HouseKeeper houseKeeper = appContext.getHouseKeeper();
        houseKeeper.cleanup(new M_BackupCleanupBackupOnErrorJob(this.getVfs(), dir, keepError, this.onErrorMessage, this.onErrorStacktrace));
    }

    public void deletePrevBackups(String schema, String timestamp) throws IOException {
        this.backupManager.deletePrevBackups(this, schema, timestamp);
    }

    public IOlapBuilderTableRowReader decorateTableReaderForBackup(IOlapBuilderTableRowReader reader, boolean tablePartition) {
        if (this.mode != S_BackupMode.INCR_LOAD) {
            if (this.factProcessing || this.m2mProcessing) {
                return reader;
            }
            if (tablePartition) {
                throw new RuntimeException("internal error: table [" + reader.getTableName() + "] with partition not supported");
            }
        }
        if (this.m2mProcessing) {
            return reader;
        }
        IOlapBuilderTableRowReader decoratingReader = this.backupManager.decorateTableReaderForSave(this, reader);
        return decoratingReader;
    }

    public void setFactProcessing(boolean factProcessing) {
        this.factProcessing = factProcessing;
    }

    public void setupUnloadPartitionForBackup(M_FactsLocalMeasureGroupManager measureGroup, M_FactsLocalPartition partition) {
        this.backupManager.setupUnloadPartitionForSave(this, measureGroup, partition);
    }

    public void setupPartitionForBackup(M_FactsLocalMeasureGroupManager measureGroup, M_FactsLocalPartition partition) {
        if (this.mode == S_BackupMode.INCR_LOAD) {
            return;
        }
        if (!this.factProcessing && !this.m2mProcessing) {
            OlapLoggers.BACKUP.error((Object)("[backup] internal error: inconsistent partition usage [" + measureGroup.getName() + "] [" + partition.getNameForStats() + "]"));
            this.setOnError("internal error: inconsistent partition usage [" + measureGroup.getName() + "] [" + partition.getNameForStats() + "]", null);
            return;
        }
        this.backupManager.setupPartitionForSave(this, measureGroup, partition);
    }

    public void setForMany2ManyProcessing(boolean m2mProcessing) {
        this.m2mProcessing = m2mProcessing;
    }

    public void saveBridges() {
        this.backupManager.saveBridges(this);
    }

    public void onIncrLoadWithErrorPhaseI() {
        this.deleteIncrLoadTemporaryContainer();
        this.resetOnError("Backup re-activated because of incr. load recoverable error!");
    }

    public void onIncrLoadWithoutData() {
        this.deleteIncrLoadTemporaryContainer();
        this.incrLoadWithoutData = true;
    }

    public void onIncrLoadWithDataMoved() {
        this.deleteIncrLoadTemporaryContainer();
    }

    private void deleteIncrLoadTemporaryContainer() {
        if (this.mode == S_BackupMode.INCR_LOAD) {
            CdVFileSystem vfs = this.backupManager.getVfs();
            File parent = this.dir.getParentFile();
            if (parent != null && CdVFileSystem.isTemporary((Path)parent.toPath())) {
                vfs.delete(parent);
            } else {
                vfs.delete(this.dir);
            }
        }
    }

    public void onLoadPartitionAdopted() {
        if (this.mode == S_BackupMode.LOAD_PARTITIONS || this.mode == S_BackupMode.LOAD_MEASURE_GROUPS) {
            this.backupManager.saveCubesUnresolvedRows(this);
        }
    }

    public void onBuildCompleted() {
        if (this.mode == S_BackupMode.INCR_LOAD) {
            this.backupManager.saveM2MsUnresolvedRows(this);
            return;
        }
        if (this.mode == S_BackupMode.LOAD_PARTITIONS || this.mode == S_BackupMode.LOAD_MEASURE_GROUPS) {
            this.backupManager.saveIncrLoadSavePoints(this);
            return;
        }
        this.backupManager.saveCubesUnresolvedRows(this);
        this.backupManager.saveM2MsUnresolvedRows(this);
        this.backupManager.saveIncrLoadSavePoints(this);
    }

    public void onBuildFinally(OlapSchema schema, boolean succeeded) {
        String timestamp = this.dir.getName();
        this.backupManager.onBackupFinally(this, schema, timestamp, succeeded);
    }
}

