/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.save;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartition;
import crazydev.iccube.cluster.master.backup.save.M_BackupCompacterDebug;
import crazydev.iccube.cluster.master.backup.save.M_BackupContext;
import crazydev.iccube.cluster.master.backup.save.M_BackupPartitionCompacter;
import crazydev.iccube.cluster.master.backup.save.M_BackupShrinker;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class M_BackupCompacter {
    public static M_BackupCompacterDebug debug_ = null;

    public static void compact(M_BackupContext context, String timestamp) {
        M_BackupCompacter.compactLoadPartitions(context, timestamp);
        M_BackupCompacter.compactPrevBackups(context);
    }

    public static void compactLoadPartitions(M_BackupContext context, String timestamp) {
        S_BackupMode mode = context.getMode();
        if (mode != S_BackupMode.LOAD_PARTITIONS) {
            return;
        }
        OlapSchema schema = context.getSchema();
        String schemaName = schema.getName();
        long startMS = System.currentTimeMillis();
        OlapLoggers.BACKUP.info((Object)("[backup] compacting partitions started [" + schemaName + "]"));
        File backupDir = schema.getBackupDir();
        if (backupDir == null) {
            OlapLoggers.BACKUP.info((Object)("[backup] compacting partitions completed [" + schemaName + "] no backup directory"));
            return;
        }
        try {
            M_BackupCompacter.compactLoadPartitions(context, schema, schemaName, backupDir, timestamp);
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] compacting partitions unexpected error [" + schemaName + "]"), (Throwable)ex);
        }
        OlapLoggers.BACKUP.info((Object)("[backup] compacting partitions completed [" + schemaName + "] [" + CdTimeUtils.formatMillisEx((long)startMS) + "]"));
    }

    private static void compactLoadPartitions(M_BackupContext context, OlapSchema schema, String schemaName, File backupDir, String timestamp) throws IOException {
        boolean serverWithHistory = context.isServerWithPartitionHistory();
        boolean backupWithHistory = S_BackupHelper.isBackupWithPartitionHistory(backupDir);
        if (serverWithHistory) {
            if (backupWithHistory) {
                OlapLoggers.BACKUP.info((Object)"[backup] compacting partitions [server w/ history] [backup w/ history] ignored");
                return;
            }
            OlapLoggers.BACKUP.info((Object)"[backup] compacting partitions [server w/ history] [backup wo/ history]");
        } else if (backupWithHistory) {
            OlapLoggers.BACKUP.info((Object)"[backup] compacting partitions [server wo/ history] [backup w/ history]");
            S_BackupHelper.setBackupWithNoPartitionHistory(backupDir);
        } else {
            OlapLoggers.BACKUP.info((Object)"[backup] compacting partitions [server wo/ history] [backup wo/ history]");
        }
        M_BackupShrinker shrinker = schema.getBackupShrinker();
        if (shrinker == null) {
            shrinker = new M_BackupShrinker();
            shrinker.performFullCompacting(context.getVfs(), schemaName, backupDir);
            schema.setBackupShrinker(shrinker);
        } else {
            shrinker.performIncrCompacting(schemaName, backupDir, timestamp);
        }
    }

    public static void compactPrevBackups(M_BackupContext context) {
        S_BackupMode mode = context.getMode();
        if (mode != S_BackupMode.FULL_LOAD) {
            return;
        }
        boolean serverWithHistory = context.isServerWithBackupHistory();
        if (serverWithHistory) {
            return;
        }
        OlapSchema schema = context.getSchema();
        String schemaName = schema.getName();
        OlapLoggers.BACKUP.info((Object)("[backup] deleting prev. backups started [" + schemaName + "]"));
        File backupDir = schema.getBackupDir();
        if (backupDir == null) {
            OlapLoggers.BACKUP.info((Object)("[backup] deleting prev. backups completed [" + schemaName + "] no backup directory"));
            return;
        }
        try {
            M_BackupCompacter.compactPrevBackups(context, schemaName, backupDir.getName());
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] deleting prev. backups started unexpected error [" + schemaName + "]"), (Throwable)ex);
        }
        OlapLoggers.BACKUP.info((Object)("[backup] deleting prev. backups started completed [" + schemaName + "]"));
    }

    private static void compactPrevBackups(M_BackupContext context, String schemaName, String timestamp) throws IOException {
        context.deletePrevBackups(schemaName, timestamp);
    }

    static class PartitionCompacter
    implements M_BackupPartitionCompacter {
        final String schemaName;
        final File backupDir;
        final AtomicLong hit = new AtomicLong();
        final AtomicLong miss = new AtomicLong();

        public PartitionCompacter(String schemaName, File backupDir) {
            this.schemaName = schemaName;
            this.backupDir = backupDir;
        }

        @Override
        public void compactPartitions(String timestamp, List<M_RestorePartition> partitions) {
            for (M_RestorePartition partition : partitions) {
                this.deletePartition(timestamp, partition);
            }
        }

        private void deletePartition(String timestamp, M_RestorePartition partition) {
            File factsDir;
            if (this.backupDir.getName().equals(timestamp)) {
                factsDir = new File(this.backupDir, "facts");
            } else {
                File activitiesDir = new File(this.backupDir, "activities");
                File activityDir = new File(activitiesDir, timestamp);
                factsDir = new File(activityDir, "facts");
            }
            int backupID = partition.getID();
            this.deletePartitionFile(partition, new File(factsDir, String.valueOf(backupID) + ".icc-facts"));
            this.deletePartitionFile(partition, new File(factsDir, String.valueOf(backupID) + ".icc-index"));
            if (debug_ != null) {
                debug_.registerDeletedPartition(partition.getKeyValue());
            }
        }

        private void deletePartitionFile(M_RestorePartition partition, File file) {
            boolean exists = file.exists();
            if (!exists) {
                this.miss.incrementAndGet();
                return;
            }
            OlapLoggers.BACKUP.info((Object)("[backup] compacting partitions [" + this.schemaName + "] [" + partition.getCubeName() + "] [" + partition.getMeasureGroupNameF() + "] [" + partition.getKeyValue() + "] deleting file [" + file.getAbsolutePath() + "]"));
            this.hit.incrementAndGet();
            file.delete();
        }
    }
}

