/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.restore.actions;

import crazydev.iccube.cluster.master.backup.restore.M_RestorePartition;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartitionMode;
import crazydev.iccube.cluster.master.backup.restore.actions.M_Action;
import crazydev.iccube.cluster.master.backup.restore.actions.M_FactsKey;
import crazydev.iccube.cluster.master.backup.restore.actions.M_PartitionInfo;
import crazydev.iccube.cluster.master.backup.save.M_BackupPartitionCompacter;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class M_FactsActionHistory {
    public final M_FactsKey key;
    public final Map<String, M_Action> actionsPerTimestamp = new HashMap<String, M_Action>();
    private final Map<String, M_Action> lastActions = new HashMap<String, M_Action>();
    public List<M_Action> actions = new ArrayList<M_Action>();
    private M_Action lastAction = null;

    public M_FactsActionHistory(M_FactsKey key) {
        this.key = key;
    }

    public void forEachCompactingPartitions(M_BackupPartitionCompacter compacter) {
        for (int ii = 0; ii < this.actions.size() - 1; ++ii) {
            List<M_RestorePartition> partitions;
            M_Action action = this.actions.get(ii);
            if (!action.isLoad() || action.compacted || (partitions = this.getPartitions(M_RestorePartitionMode.COMPACTING, null, action, action.seqId)) == null) continue;
            compacter.compactPartitions(action.timestamp, partitions);
            if (partitions.size() != action.infos.size()) continue;
            action.compacted = true;
        }
    }

    public void getPartitions(M_RestorePartitionMode mode, List<M_RestorePartition> partitions, String timestamp) {
        M_Action action = this.actionsPerTimestamp.get(timestamp);
        if (action != null) {
            this.getPartitions(mode, partitions, action, action.seqId);
        }
    }

    private List<M_RestorePartition> getPartitions(M_RestorePartitionMode mode, @Nullable List<M_RestorePartition> partitions, M_Action action, int seqId) {
        Logger LOGGER;
        Object object = LOGGER = OlapLoggers.BACKUP_X.isTraceEnabled() ? OlapLoggers.BACKUP_X : null;
        if (mode == M_RestorePartitionMode.COMPACTING && LOGGER != null) {
            LOGGER.trace((Object)("[backup] [cube:" + this.key.cube + "] [measureGroup:" + this.key.measureGroup + "] [" + action.timestamp + "]"));
        }
        for (M_PartitionInfo info : action.infos) {
            boolean loadedOrDeletedAfter = this.isPartitionLoadedOrDeletedAfter(action.seqId, info.keyValue);
            if (switch (mode) {
                case M_RestorePartitionMode.RESTORING -> !loadedOrDeletedAfter;
                case M_RestorePartitionMode.COMPACTING -> loadedOrDeletedAfter;
                default -> throw new RuntimeException("internal error: unexpected restore mode [" + String.valueOf((Object)mode) + "]");
            }) {
                if (LOGGER != null) {
                    if (mode != M_RestorePartitionMode.COMPACTING) {
                        LOGGER.trace((Object)("[backup] [cube:" + this.key.cube + "] [measureGroup:" + this.key.measureGroup + "] [partition:" + info.keyValue + "] SELECTED"));
                    } else {
                        LOGGER.trace((Object)("[backup] [cube:" + this.key.cube + "] [measureGroup:" + this.key.measureGroup + "] [partition:" + info.keyValue + "] SELECTED"));
                    }
                }
                if (partitions == null) {
                    partitions = new ArrayList<M_RestorePartition>();
                }
                partitions.add(new M_RestorePartition(this.key.cube, this.key.measureGroup, this.key.measureGroupF, info.backupId, info.nameForStats, info.keyColumnType, info.keyValue));
                continue;
            }
            if (LOGGER == null) continue;
            if (mode != M_RestorePartitionMode.COMPACTING) {
                LOGGER.trace((Object)("[backup] [cube:" + this.key.cube + "] [measureGroup:" + this.key.measureGroup + "] [partition:" + info.keyValue + "] IGNORED"));
                continue;
            }
            LOGGER.trace((Object)("[backup] [cube:" + this.key.cube + "] [measureGroup:" + this.key.measureGroup + "] [partition:" + info.keyValue + "] IGNORED"));
        }
        return partitions;
    }

    public boolean isPartitionLoadedOrDeletedAfter(int seqId, String keyValue) {
        return this.isPartitionLoadedOrDeletedAfter_new(seqId, keyValue);
    }

    private boolean isPartitionLoadedOrDeletedAfter_new(int seqId, String keyValue) {
        if (this.lastAction != null) {
            return this.lastAction.seqId > seqId;
        }
        M_Action action = this.lastActions.get(keyValue);
        return action != null && action.seqId > seqId;
    }

    public void addLastAction(M_PartitionInfo partition, M_Action action) {
        if (action.forMeasureGroup) {
            this.lastAction = action;
        } else {
            this.lastActions.compute(partition.keyValue, (pK, pAction) -> action);
        }
    }
}

