/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.restore;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class M_RestoreMany2ManyMeasureGroups {
    private final Map<String, Cube> cubes = new HashMap<String, Cube>();

    public static M_RestoreMany2ManyMeasureGroups restore(File metaFile) {
        M_RestoreMany2ManyMeasureGroups m_RestoreMany2ManyMeasureGroups;
        block6: {
            M_RestoreMany2ManyMeasureGroups meta = new M_RestoreMany2ManyMeasureGroups();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(metaFile), StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    String cubeName = line.substring(2);
                    Cube cube = meta.getOrCreateCube(cubeName);
                    String measureGroupName = reader.readLine().substring(3);
                    String measureGroupNameF = reader.readLine().substring(4);
                    MeasureGroup measureGroup = cube.getOrCreateMeasureGroup(measureGroupName, measureGroupNameF);
                }
                m_RestoreMany2ManyMeasureGroups = meta;
                if (reader == null) break block6;
            }
            catch (IOException ex) {
                try {
                    throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"could not restore partitions meta-information", ex});
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        IOUtils.closeQuietly(reader);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        return m_RestoreMany2ManyMeasureGroups;
    }

    private Cube getOrCreateCube(String name) {
        Cube cube = this.cubes.get(name);
        if (cube == null) {
            cube = new Cube(name);
            this.cubes.put(name, cube);
        }
        return cube;
    }

    public boolean contains(String name) {
        for (Cube cube : this.cubes.values()) {
            if (!cube.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.cubes.isEmpty();
    }

    public static class Cube {
        private final String name;
        private final Map<String, MeasureGroup> measureGroups = new HashMap<String, MeasureGroup>();

        public Cube(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private MeasureGroup getOrCreateMeasureGroup(String name, String nameF) {
            MeasureGroup measureGroup = this.measureGroups.get(name);
            if (measureGroup == null) {
                measureGroup = new MeasureGroup(this, name, nameF);
                this.measureGroups.put(name, measureGroup);
            }
            return measureGroup;
        }

        public Collection<MeasureGroup> getMeasureGroups() {
            return this.measureGroups.values();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class MeasureGroup {
        private final Cube cube;
        private final String name;
        private final String nameF;

        public MeasureGroup(Cube cube, String name, String nameF) {
            this.cube = cube;
            this.name = name;
            this.nameF = nameF;
        }

        public Cube getCube() {
            return this.cube;
        }

        public String getName() {
            return this.name;
        }

        public String getNameF() {
            return this.nameF;
        }

        public String toString() {
            return this.name + " / " + this.nameF;
        }
    }
}

