/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.info;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cluster.master.backup.info.M_BackupActivityInfoUI;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class M_BackupInfoUI {
    private final String schema;
    private final String group;
    private final String timestamp;
    private final File factoryFile;
    private final boolean valid;
    private final List<M_BackupActivityInfoUI> activities;

    public M_BackupInfoUI(String schema, @Nullable String group, String timestamp, File factoryFile, boolean valid, List<M_BackupActivityInfoUI> activities) {
        this.schema = schema;
        this.group = group;
        this.timestamp = timestamp;
        this.factoryFile = factoryFile;
        this.valid = valid;
        this.activities = activities;
    }

    public String getSchema() {
        return this.schema;
    }

    @Nullable
    public String getSchemaGroup() {
        return this.group;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampSortable() {
        return this.timestamp;
    }

    public String getTimestampServerTimeSortableForUI() {
        return M_BackupInfoUI.getTimestampServerTimeForUI(this.timestamp);
    }

    public static String getTimestampServerTimeForUI(String timestamp) {
        try {
            Date ts = S_BackupHelper.getTimestampX(timestamp);
            return CdTimeUtils.formatServerTimeForRequest((Date)ts);
        }
        catch (ParseException ex) {
            return "n/a";
        }
    }

    public File getFactoryFile() {
        return this.factoryFile;
    }

    public static String getValidAsStatus(boolean valid) {
        return valid ? "ok" : "error";
    }

    public String getStatus() {
        return M_BackupInfoUI.getValidAsStatus(this.valid);
    }

    public boolean isValid() {
        return this.isInitialLoadValid() && this.isActivitiesValid();
    }

    public boolean isInitialLoadValid() {
        return this.valid;
    }

    public boolean isActivitiesValid() {
        for (M_BackupActivityInfoUI activity : this.activities) {
            if (activity.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean hasActivity() {
        return !this.activities.isEmpty();
    }

    public List<M_BackupActivityInfoUI> getActivities() {
        return this.activities;
    }

    public int getActivityCount() {
        return this.activities.size();
    }

    public String toString() {
        return this.timestamp;
    }
}

