/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cleaner;

import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cleaner.OlapNopFileCleaner;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class OlapWindowsFileCleaner
implements OlapFileCleaner {
    private final ExecutorService executor;
    private final LinkedList<File> files = new LinkedList();
    private final LinkedList<File> directories = new LinkedList();

    private OlapWindowsFileCleaner(int cleanerDelay, int cleanerFileCount) {
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(new Task(this, cleanerDelay, cleanerFileCount));
        OlapLoggers.CLEANER.debug((Object)("Windows cleaner : started [delay:" + cleanerDelay + "s][fileCount:" + String.valueOf(cleanerFileCount == -1 ? "no limit" : Integer.valueOf(cleanerFileCount)) + "]"));
    }

    public static OlapFileCleaner create(OlapEngineComponentConfiguration configuration) {
        OlapProperties properties = configuration.getProperties();
        if (!properties.isCleanerActive()) {
            return OlapNopFileCleaner.INSTANCE;
        }
        return new OlapWindowsFileCleaner(properties.getCleanerDelay(), properties.getCleanerFileCount());
    }

    @Override
    public void shutdownNow() {
        OlapLoggers.CLEANER.debug((Object)"Windows cleaner : shutdown requested");
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(File file) {
        LinkedList<File> linkedList;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            linkedList = this.files;
            synchronized (linkedList) {
                this.files.addLast(file);
            }
        }
        if (file.isDirectory()) {
            linkedList = this.directories;
            synchronized (linkedList) {
                this.directories.addLast(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFilesAndDirectories(int cleanerFileCount) {
        boolean ok = false;
        LinkedList<File> linkedList = this.files;
        synchronized (linkedList) {
            if (!this.files.isEmpty()) {
                ok = true;
            }
        }
        linkedList = this.directories;
        synchronized (linkedList) {
            if (!this.directories.isEmpty()) {
                ok = true;
            }
        }
        if (!ok) {
            OlapLoggers.CLEANER.debug((Object)"Windows cleaner : nop ------------------------------------------------------------------------------------------------------");
            return;
        }
        OlapWindowsFileCleaner.deleteFilesOrDirectories("file", cleanerFileCount, this.files);
        OlapWindowsFileCleaner.deleteFilesOrDirectories("directory", cleanerFileCount, this.directories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFilesOrDirectories(String type, int cleanerFileCount, LinkedList<File> files) {
        int total;
        ArrayList<File> toDelete = new ArrayList<File>();
        LinkedList<File> linkedList = files;
        synchronized (linkedList) {
            total = files.size();
            int count = cleanerFileCount == -1 ? files.size() : cleanerFileCount;
            for (int ii = 0; !files.isEmpty() && ii < count; ++ii) {
                File file = files.pollFirst();
                if (file == null) continue;
                toDelete.add(file);
            }
        }
        OlapLoggers.CLEANER.debug((Object)("Windows cleaner : (" + total + ") deleting " + toDelete.size() + " " + type + "(s) ..."));
        int deletedCount = 0;
        ArrayList<File> notDeleted = new ArrayList<File>();
        for (File file : toDelete) {
            if (!CdVFileSystemUtils.deleteQuietly((File)file)) {
                notDeleted.add(file);
                continue;
            }
            ++deletedCount;
        }
        OlapLoggers.CLEANER.debug((Object)("Windows cleaner : deleted : " + deletedCount));
        LinkedList<File> linkedList2 = files;
        synchronized (linkedList2) {
            for (File file : notDeleted) {
                if (file == null) continue;
                files.addFirst(file);
            }
        }
    }

    class Task
    implements Runnable {
        private final int cleanerDelay;
        private final int cleanerFileCount;
        final /* synthetic */ OlapWindowsFileCleaner this$0;

        public Task(OlapWindowsFileCleaner this$0, int cleanerDelay, int cleanerFileCount) {
            OlapWindowsFileCleaner olapWindowsFileCleaner = this$0;
            Objects.requireNonNull(olapWindowsFileCleaner);
            this.this$0 = olapWindowsFileCleaner;
            this.cleanerDelay = cleanerDelay;
            this.cleanerFileCount = cleanerFileCount;
        }

        @Override
        public void run() {
            try {
                this.this$0.deleteFilesAndDirectories(this.cleanerFileCount);
            }
            catch (RuntimeException ignored) {
                OlapLoggers.CLEANER.warn((Object)"Windows cleaner : unexpected error while deleting files", (Throwable)ignored);
            }
            try {
                Thread.sleep(this.cleanerDelay * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.this$0.executor.isShutdown()) {
                this.this$0.executor.submit(new Task(this.this$0, this.cleanerDelay, this.cleanerFileCount));
            }
        }
    }
}

