/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.collection.CdPair;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder2.cruncher.IUxCruncherTableAnalyzer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class UxCruncherTableAnalyzerHierarchical
implements IUxCruncherTableAnalyzer {
    private final Map<CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>, Relation> pairs = new HashMap<CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>, Relation>();
    private final List<IOlapBuilderDataColumnDef> compatibleColumns;
    private final List<IOlapBuilderDataColumnDef> allColumns;
    private final String tableName;
    private int rowCount;

    public UxCruncherTableAnalyzerHierarchical(IOlapBuilderTabularDataDef tableName) {
        this.allColumns = tableName.getSelectedColumns();
        this.tableName = tableName.getName();
        this.compatibleColumns = this.allColumns.stream().filter(c -> c.getType().isString()).collect(Collectors.toList());
        this.init();
    }

    public String getTableName() {
        return this.tableName;
    }

    private void init() {
        for (int i = 0; i < this.compatibleColumns.size(); ++i) {
            for (int j = i + 1; j < this.compatibleColumns.size(); ++j) {
                IOlapBuilderDataColumnDef c1 = this.compatibleColumns.get(i);
                IOlapBuilderDataColumnDef c2 = this.compatibleColumns.get(j);
                this.pairs.putIfAbsent((CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>)new CdPair((Object)c1, (Object)c2), new Relation(c1, c2));
            }
        }
    }

    @Override
    public boolean analyse(IOlapBuilderTableRow row) {
        ++this.rowCount;
        MutableBoolean oneLive = new MutableBoolean();
        this.pairs.forEach((col, o) -> {
            if (o.acceptsData()) {
                Comparable val1 = row.getJavaNativeDataValue(o.c1);
                Comparable val2 = row.getJavaNativeDataValue(o.c2);
                o.addValues(val1, val2);
                oneLive.setValue(true);
            }
        });
        return oneLive.booleanValue();
    }

    Map<CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>, Relation> getPairs() {
        return this.pairs;
    }

    List<IOlapBuilderDataColumnDef> getAllColumns() {
        return this.allColumns;
    }

    static class Relation {
        final IOlapBuilderDataColumnDef c1;
        final IOlapBuilderDataColumnDef c2;
        boolean isc1Root;
        boolean isc2Root;
        private Map<Comparable, Set<Comparable>> c1_c2;
        private Map<Comparable, Set<Comparable>> c2_c1;

        public Relation(IOlapBuilderDataColumnDef c1, IOlapBuilderDataColumnDef c2) {
            this.c1 = c1;
            this.c2 = c2;
            this.c1_c2 = new HashMap<Comparable, Set<Comparable>>();
            this.c2_c1 = new HashMap<Comparable, Set<Comparable>>();
        }

        private void addValues(Comparable valueC1, Comparable valueC2) {
            if (this.c1_c2 == null) {
                return;
            }
            Set setc1c2 = this.c1_c2.computeIfAbsent(valueC1, comparable -> new HashSet());
            setc1c2.add(valueC2);
            if (setc1c2.size() > 1) {
                this.isc1Root = true;
            }
            Set setc2c1 = this.c2_c1.computeIfAbsent(valueC2, comparable -> new HashSet());
            setc2c1.add(valueC1);
            if (setc2c1.size() > 1) {
                this.isc2Root = true;
            }
            if (this.isc1Root && this.isc2Root) {
                this.c1_c2 = null;
                this.c2_c1 = null;
            }
        }

        public IOlapBuilderDataColumnDef getParent() {
            return this.isc1Root ? this.c1 : this.c2;
        }

        public IOlapBuilderDataColumnDef getChild() {
            return this.isc1Root ? this.c2 : this.c1;
        }

        public boolean isOneToOneRelation() {
            if (this.c1_c2 == null || this.c1_c2.isEmpty() || this.c1_c2.size() != this.c2_c1.size()) {
                return false;
            }
            return this.c1_c2.values().stream().noneMatch(s -> s.size() != 1) && this.c1_c2.values().stream().noneMatch(s -> s.size() != 1);
        }

        private boolean acceptsData() {
            return this.c1_c2 != null;
        }

        public boolean isParentChild() {
            if (this.c1_c2 == null || this.c1_c2.isEmpty()) {
                return false;
            }
            return !this.isOneToOneRelation();
        }

        boolean isOneOrEmpty() {
            return this.c1_c2 == null || this.c2_c1 == null || this.c1_c2.size() <= 1 || this.c2_c1.size() <= 1;
        }

        void addSingleValueColumn(Set<IOlapBuilderDataColumnDef> set) {
            if (this.c1_c2.size() == 1) {
                set.add(this.c1);
            }
            if (this.c2_c1.size() == 1) {
                set.add(this.c2);
            }
        }
    }
}

