/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder2.cruncher.IUxCruncherTableAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class UxCruncherTableAnalyzerFlat
implements IUxCruncherTableAnalyzer {
    private final IOlapBuilderTabularDataDef table;
    private final List<IOlapBuilderDataColumnDef> columns;
    private final Map<IOlapBuilderDataColumnDef, Map<Comparable, MutableInt>> values;
    private int rowCount = 0;

    public UxCruncherTableAnalyzerFlat(IOlapBuilderTabularDataDef table) {
        this.columns = table.getSelectedColumns();
        this.table = table;
        this.values = new HashMap<IOlapBuilderDataColumnDef, Map<Comparable, MutableInt>>();
    }

    Map<IOlapBuilderDataColumnDef, Map<Comparable, MutableInt>> getValues() {
        return this.values;
    }

    @Override
    public boolean analyse(IOlapBuilderTableRow row) {
        for (int i = 0; i < this.columns.size(); ++i) {
            IOlapBuilderDataColumnDef column = this.columns.get(i);
            Map ret = this.values.computeIfAbsent(column, k -> new HashMap());
            @Nullable Comparable val = row.getJavaNativeDataValue(column);
            ret.computeIfAbsent(val, v -> new MutableInt(0)).increment();
        }
        ++this.rowCount;
        return true;
    }

    public List<Coincidence> link(UxCruncherTableAnalyzerFlat other) {
        return this.link(other, null);
    }

    public List<Coincidence> link(UxCruncherTableAnalyzerFlat other, @Nullable BiPredicate<OlapBuilderBaseDataTable, IOlapBuilderDataColumnDef> filter) {
        ArrayList<Coincidence> list = new ArrayList<Coincidence>();
        for (int i = 0; i < this.columns.size(); ++i) {
            IOlapBuilderDataColumnDef col = this.columns.get(i);
            for (int j = 0; j < other.columns.size(); ++j) {
                Coincidence res;
                IOlapBuilderDataColumnDef otherCol = other.columns.get(j);
                if (col.getType() != otherCol.getType() || (res = this.findCoincidence(this.table, other.table, col, otherCol, this.values.get(col), other.values.get(otherCol))) == null) continue;
                list.add(res);
            }
        }
        return list;
    }

    private Coincidence findCoincidence(IOlapBuilderTabularDataDef table1, IOlapBuilderTabularDataDef table2, IOlapBuilderDataColumnDef col1, IOlapBuilderDataColumnDef col2, Map<Comparable, MutableInt> values1, Map<Comparable, MutableInt> values2) {
        Set<Comparable> keys1 = values1.keySet();
        Set<Comparable> keys2 = values2.keySet();
        @Nullable Comparable val1 = (Comparable)CdCollections.firstNotNull(keys1);
        @Nullable Comparable val2 = (Comparable)CdCollections.firstNotNull(keys2);
        if (val1 == null || val2 == null || val1.getClass() != val2.getClass()) {
            return null;
        }
        int key2InKeys1 = (int)keys2.stream().filter(values1::containsKey).count();
        int key1InKeys2 = (int)keys1.stream().filter(values2::containsKey).count();
        int totalKey1 = keys1.size();
        int totalKey2 = keys2.size();
        if (key2InKeys1 == 0 && key1InKeys2 == 0) {
            return null;
        }
        return new Coincidence(table1, table2, col1, col2, totalKey1, totalKey2, key2InKeys1, key1InKeys2);
    }

    public String toString() {
        return this.table.toString();
    }

    public String getTableName() {
        return this.table.getName();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public static class Coincidence {
        private final IOlapBuilderTabularDataDef table1;
        private final IOlapBuilderTabularDataDef table2;
        private final IOlapBuilderDataColumnDef col1;
        private final IOlapBuilderDataColumnDef col2;
        private final int key2InKeys1;
        private final int key1InKeys2;
        private final int totalKey1;
        private final int totalKey2;

        public Coincidence(IOlapBuilderTabularDataDef table1, IOlapBuilderTabularDataDef table2, IOlapBuilderDataColumnDef col1, IOlapBuilderDataColumnDef col2, int totalKey1, int totalKey2, int key2InKeys1, int key1InKeys2) {
            this.table1 = table1;
            this.table2 = table2;
            this.col1 = col1;
            this.col2 = col2;
            this.key2InKeys1 = key2InKeys1;
            this.key1InKeys2 = key1InKeys2;
            this.totalKey1 = totalKey1;
            this.totalKey2 = totalKey2;
        }

        public boolean perfectMatch() {
            return this.key1InKeys2 == this.totalKey1 && this.key2InKeys1 == this.totalKey2;
        }

        public String toString() {
            return this.table1.toString() + ":" + String.valueOf(this.col1) + " -> " + this.table2.toString() + ":" + String.valueOf(this.col2) + " -> ";
        }
    }
}

