/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.collection.CdArrayList;
import crazydev.common.collection.CdPair;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder2.cruncher.UxCruncherHelper;
import crazydev.iccube.builder2.cruncher.UxCruncherTableAnalyzerHierarchical;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class UxCruncherSchemaScriptReport {
    private final String tableName;
    List<Dimension> dimensions = new ArrayList<Dimension>();
    List<IOlapBuilderDataColumnDef> timeDimensions = new ArrayList<IOlapBuilderDataColumnDef>();

    public UxCruncherSchemaScriptReport(String tableName) {
        this.tableName = tableName;
    }

    public void attach(HashMap<IOlapBuilderDataColumnDef, LevelInfo> structures, CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> pair) {
        boolean done = false;
        for (Dimension dimension : this.dimensions) {
            if (done) continue;
            done = dimension.attach(structures, pair);
        }
        if (!done) {
            LevelInfo level1 = structures.computeIfAbsent((IOlapBuilderDataColumnDef)pair.fst, LevelInfo::new);
            LevelInfo level2 = structures.computeIfAbsent((IOlapBuilderDataColumnDef)pair.snd, LevelInfo::new);
            this.dimensions.add(new Dimension(level1, level2));
        }
    }

    public String toUxStructure() {
        StringBuilder builder = new StringBuilder();
        builder.append("# Text version (still beta)  \n# Format :   [Type] - name [;options separated by ;]\n# Format :   [D|H|L|P] - name [; name column name][; key column name]\n# TABLE - Table Name                            # optional, selects the table that will apply from this line\n# D  - dimension name\n# H  - hierarchy name                           # the first one is the default hierarchy\n# AL - all level name  ; all level member name  # optional\n# L  - level name  ; name column; key column\n# P  - property name  ; column\n# TD - time dimension name  ; column - nullable ; default hierarchy levels; no default hierarchies levels    # levels is a list of level type : Y HY Q M D DY DM for Year, HalfYear, Quarter, Month, Day, DayOfMonth, Day of Quarter\n\n# MG - measure group name  [; cube type]       #  if no cube, the first one will be taken or created\n# M  - measure name  ; column ; aggregation type [; FORMAT_STRING]\n\n");
        builder.append("\nTABLE - ").append(this.tableName).append("\n");
        this.dimensions.forEach(d -> d.toStructure(builder));
        if (!this.timeDimensions.isEmpty()) {
            builder.append("\n\n# Time Dimensions");
            this.timeDimensions.forEach(c -> builder.append("\nT - ").append(UxCruncherHelper.mdxName(c.getName())).append(" ; ").append(c.getName()).append(" ; Y Q M D ; Q M D"));
        }
        return builder.toString();
    }

    public boolean in(IOlapBuilderDataColumnDef columnDef) {
        return this.dimensions.stream().anyMatch(d -> d.in(columnDef));
    }

    private void addOrphan(IOlapBuilderDataColumnDef orphanCol) {
        if (orphanCol.getType().isDateType()) {
            this.timeDimensions.add(orphanCol);
        } else if (orphanCol.getType().isString()) {
            this.dimensions.add(new Dimension(orphanCol));
        }
    }

    public static UxCruncherSchemaScriptReport build(UxCruncherTableAnalyzerHierarchical analyzer) {
        Map<CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>, UxCruncherTableAnalyzerHierarchical.Relation> pairs = analyzer.getPairs();
        ArrayList<CdArrayList<IOlapBuilderDataColumnDef>> one2one = new ArrayList<CdArrayList<IOlapBuilderDataColumnDef>>();
        pairs.values().stream().filter(UxCruncherTableAnalyzerHierarchical.Relation::isOneToOneRelation).forEach(relation -> {
            CdArrayList set = null;
            for (CdArrayList set2 : one2one) {
                if (!set2.contains((Object)relation.c1) && !set2.contains((Object)relation.c2)) continue;
                set = set2;
                break;
            }
            if (set == null) {
                set = new CdArrayList();
                one2one.add(set);
            }
            set.addIfNotPresent((Object)relation.c1);
            set.addIfNotPresent((Object)relation.c2);
        });
        HashSet<IOlapBuilderDataColumnDef> aliasOf = new HashSet<IOlapBuilderDataColumnDef>();
        for (int i = 0; i < one2one.size(); ++i) {
            CdArrayList columns = (CdArrayList)one2one.get(i);
            for (int j = 1; j < columns.size(); ++j) {
                aliasOf.add((IOlapBuilderDataColumnDef)columns.get(j));
            }
        }
        ArrayList<CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>> parentChild = new ArrayList<CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>>();
        pairs.values().stream().filter(UxCruncherTableAnalyzerHierarchical.Relation::isParentChild).filter(rel -> !rel.isOneOrEmpty() && !aliasOf.contains(rel.c1) && !aliasOf.contains(rel.c2)).forEach(relation -> parentChild.add(new CdPair((Object)relation.getParent(), (Object)relation.getChild())));
        HashSet<IOlapBuilderDataColumnDef> excluded = new HashSet<IOlapBuilderDataColumnDef>();
        pairs.values().stream().filter(UxCruncherTableAnalyzerHierarchical.Relation::isParentChild).filter(UxCruncherTableAnalyzerHierarchical.Relation::isOneOrEmpty).forEach(relation -> relation.addSingleValueColumn(excluded));
        return UxCruncherSchemaScriptReport.buildPhase(analyzer, one2one, parentChild, excluded);
    }

    private static UxCruncherSchemaScriptReport buildPhase(UxCruncherTableAnalyzerHierarchical analyzer, List<CdArrayList<IOlapBuilderDataColumnDef>> alias, List<CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>> parentChild, Set<IOlapBuilderDataColumnDef> excluded) {
        List<LevelInfo> info = alias.stream().map(t -> new LevelInfo((CdArrayList<IOlapBuilderDataColumnDef>)t)).collect(Collectors.toList());
        HashMap structures = new HashMap();
        info.forEach(al -> structures.put(al.getFirst(), al));
        UxCruncherSchemaScriptReport root = new UxCruncherSchemaScriptReport(analyzer.getTableName());
        parentChild.forEach(pair -> root.attach(structures, (CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>)pair));
        root.onFinishAttach();
        List orphanColumns = analyzer.getAllColumns().stream().filter(c -> !excluded.contains(c) && !root.in((IOlapBuilderDataColumnDef)c)).collect(Collectors.toList());
        orphanColumns.stream().forEach(c -> root.addOrphan((IOlapBuilderDataColumnDef)c));
        return root;
    }

    private void onFinishAttach() {
        HashMap dims = new HashMap();
        this.dimensions.forEach(d -> dims.compute(d.getName(), (name, mapDim) -> {
            if (mapDim == null || mapDim.size() < d.size()) {
                return d;
            }
            return mapDim;
        }));
        this.dimensions.clear();
        this.dimensions.addAll(dims.values());
    }

    static class Dimension {
        List<Hierarchy> hierarchies = new ArrayList<Hierarchy>();

        public Dimension(LevelInfo level1, LevelInfo level2) {
            this.hierarchies.add(new Hierarchy(level1, level2));
        }

        public Dimension(IOlapBuilderDataColumnDef orphanCol) {
            this.hierarchies.add(new Hierarchy(orphanCol));
        }

        public boolean attach(HashMap<IOlapBuilderDataColumnDef, LevelInfo> structures, CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> pair) {
            boolean done = false;
            for (Hierarchy hierarchy : this.hierarchies) {
                if (done) continue;
                done = hierarchy.attach(structures, pair);
            }
            return done;
        }

        public void toStructure(StringBuilder builder) {
            builder.append("\nD - ").append(this.getName());
            this.hierarchies.forEach(h -> h.toStructure(builder));
        }

        public String getName() {
            return this.hierarchies.get(0).getName();
        }

        public boolean in(IOlapBuilderDataColumnDef columnDef) {
            return this.hierarchies.stream().anyMatch(h -> h.in(columnDef));
        }

        public int size() {
            return 1024 * this.hierarchies.size() + this.hierarchies.get(0).levelSize();
        }
    }

    static class LevelInfo {
        private final List<IOlapBuilderDataColumnDef> properties;
        private final IOlapBuilderDataColumnDef key;
        private final IOlapBuilderDataColumnDef name;
        private IOlapBuilderDataColumnDef first;

        public LevelInfo(CdArrayList<IOlapBuilderDataColumnDef> columnDefs) {
            this.first = (IOlapBuilderDataColumnDef)columnDefs.get(0);
            this.name = UxCruncherHelper.getPossibleName(columnDefs);
            this.key = UxCruncherHelper.getPossibleKey(columnDefs);
            this.properties = columnDefs.stream().filter(c -> c != this.name && c != this.key).collect(Collectors.toList());
        }

        public LevelInfo(IOlapBuilderDataColumnDef c) {
            this.properties = Collections.emptyList();
            this.name = this.key = c;
            this.first = this.key;
        }

        public String getName() {
            if (this.name != null) {
                return UxCruncherHelper.mdxName(this.name.getName());
            }
            if (this.key != null) {
                return UxCruncherHelper.mdxName(this.key.getName());
            }
            return UxCruncherHelper.mdxName(this.properties.get(0).getName());
        }

        public IOlapBuilderDataColumnDef getFirst() {
            return this.first;
        }

        public boolean in(IOlapBuilderDataColumnDef col) {
            return col == this.key || col == this.name || this.properties.contains(col);
        }
    }

    static class Level {
        String name;
        LevelInfo info;
        Level child;

        Level(LevelInfo info) {
            this.name = info.getName();
            this.info = info;
        }

        Level(IOlapBuilderDataColumnDef col) {
            this.name = UxCruncherHelper.mdxName(col.getName());
            this.info = new LevelInfo(col);
        }

        public boolean attach(HashMap<IOlapBuilderDataColumnDef, LevelInfo> structures, CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> pair) {
            if (this.child != null) {
                return this.child.attach(structures, pair);
            }
            if (this.info.key == pair.fst) {
                LevelInfo str = structures.get(pair.snd);
                this.child = str != null ? new Level(str) : new Level((IOlapBuilderDataColumnDef)pair.snd);
                return true;
            }
            return false;
        }

        public void toStructure(StringBuilder builder) {
            builder.append("\n    L - ").append(this.name).append(" ; ").append(this.info.name).append(" ; ").append(this.info.key == null ? this.info.name : this.info.key);
            this.info.properties.forEach(c -> builder.append("\n      P - ").append(UxCruncherHelper.mdxName(c.getName())).append(" ; ").append(c.getName()));
        }

        public boolean in(IOlapBuilderDataColumnDef columnDef) {
            return this.info.in(columnDef) || this.child != null && this.child.in(columnDef);
        }

        public Level getLast() {
            if (this.child == null) {
                return this;
            }
            return this.child.getLast();
        }

        public String getName() {
            return this.name;
        }

        public int count() {
            if (this.child == null) {
                return 1;
            }
            return 1 + this.child.count();
        }
    }

    static class Hierarchy {
        Level level;

        public Hierarchy(LevelInfo level1, LevelInfo level2) {
            this.level = new Level(level1);
            this.level.child = level2 == null ? null : new Level(level2);
        }

        public Hierarchy(IOlapBuilderDataColumnDef orphanCol) {
            this.level = new Level(orphanCol);
        }

        public boolean attach(HashMap<IOlapBuilderDataColumnDef, LevelInfo> structures, CdPair<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> pair) {
            if (this.isAlready((IOlapBuilderDataColumnDef)pair.fst) && this.isAlready((IOlapBuilderDataColumnDef)pair.snd)) {
                return true;
            }
            return this.level.attach(structures, pair);
        }

        private boolean forEachLevel(Predicate<Level> tester) {
            Level level = this.level;
            do {
                if (!tester.test(level)) continue;
                return true;
            } while ((level = level.child) != null);
            return false;
        }

        private boolean isAlready(IOlapBuilderDataColumnDef col) {
            return this.forEachLevel(l -> l.info.key == col);
        }

        public void toStructure(StringBuilder builder) {
            builder.append("\n  H - ").append(this.getName());
            builder.append("\n    ").append("AL - All Level ; All");
            this.forEachLevel(t -> {
                t.toStructure(builder);
                return false;
            });
        }

        private String getName() {
            return this.level.getLast().getName();
        }

        public boolean in(IOlapBuilderDataColumnDef columnDef) {
            return this.level.in(columnDef);
        }

        int levelSize() {
            return this.level.count();
        }
    }
}

