/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class UxCruncherHelper {
    @Nullable
    public static IOlapBuilderDataColumnDef getPossibleKey(Collection<IOlapBuilderDataColumnDef> names) {
        for (IOlapBuilderDataColumnDef col : names) {
            if (!col.getType().isInteger() || !UxCruncherHelper.endsWith(col, "id") && !UxCruncherHelper.endsWith(col, "key")) continue;
            return col;
        }
        for (IOlapBuilderDataColumnDef col : names) {
            if (!col.getType().isInteger() || !UxCruncherHelper.endsWith(col, "code")) continue;
            return col;
        }
        for (IOlapBuilderDataColumnDef col : names) {
            if (!col.getType().isInteger()) continue;
            return col;
        }
        for (IOlapBuilderDataColumnDef col : names) {
            if (!UxCruncherHelper.endsWith(col, "id") && !UxCruncherHelper.endsWith(col, "key")) continue;
            return col;
        }
        for (IOlapBuilderDataColumnDef col : names) {
            if (!UxCruncherHelper.endsWith(col, "code")) continue;
            return col;
        }
        return null;
    }

    public static boolean endsWith(IOlapBuilderDataColumnDef col, String tag) {
        return col.getName().toLowerCase().endsWith(tag);
    }

    public static IOlapBuilderDataColumnDef getPossibleName(Collection<IOlapBuilderDataColumnDef> names) {
        for (IOlapBuilderDataColumnDef name : names) {
            if (!"name".endsWith(name.getName().toLowerCase())) continue;
            return name;
        }
        for (IOlapBuilderDataColumnDef name : names) {
            if (!name.getName().toLowerCase().contains("name")) continue;
            return name;
        }
        Optional<IOlapBuilderDataColumnDef> name = names.stream().filter(c -> c.getType().isString()).min(Comparator.comparingInt(o -> o.getName().length()));
        return name.orElseGet(() -> names.stream().min(Comparator.comparingInt(o -> o.getName().length())).orElse(null));
    }

    public static String mdxName(String str) {
        String name = CdStringUtils.camelCase((String)str);
        if (name.endsWith(" Name")) {
            return name.substring(0, name.length() - " Name".length());
        }
        return name;
    }
}

