/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder2.cruncher.UxCruncherTableAnalyzerFlat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class UxCruncherFlatReport {
    private final Map<IOlapBuilderDataColumnDef, Map<Comparable, MutableInt>> values;
    private final int rowCount;
    private String tableName;

    private UxCruncherFlatReport(Map<IOlapBuilderDataColumnDef, Map<Comparable, MutableInt>> values, String tableName, int rowCount) {
        this.values = values;
        this.tableName = tableName;
        this.rowCount = rowCount;
    }

    @Nullable
    public static UxCruncherFlatReport build(@Nullable UxCruncherTableAnalyzerFlat analysis) {
        if (analysis == null) {
            return null;
        }
        return new UxCruncherFlatReport(analysis.getValues(), analysis.getTableName(), analysis.getRowCount());
    }

    public int getExistingCount(IOlapBuilderDataColumnDef col, Comparable value) {
        MutableInt anInt = this.values.get(col).get(value);
        return anInt == null ? 0 : anInt.intValue();
    }

    public int getExistingCountUnique(IOlapBuilderDataColumnDef col) {
        return this.values.get(col).size();
    }

    public Map<IOlapBuilderDataColumnDef, Comparable[]> getTopValues(int limit, boolean withoutNull) {
        HashMap<IOlapBuilderDataColumnDef, Comparable[]> top100 = new HashMap<IOlapBuilderDataColumnDef, Comparable[]>();
        this.values.forEach((column, valuesForTable) -> {
            Set comparables = valuesForTable.keySet();
            if (withoutNull) {
                comparables = new HashSet(comparables);
                comparables.remove(null);
                comparables.remove("");
            }
            Comparable[] keys = (Comparable[])CdCollections.copy(comparables, (Object[])new Comparable[comparables.size()]);
            Arrays.parallelSort(keys, Comparator.comparingInt(o -> -((MutableInt)valuesForTable.get(o)).intValue()));
            Comparable[] top100Keys = Arrays.copyOfRange(keys, 0, Math.min(limit, keys.length));
            top100.put((IOlapBuilderDataColumnDef)column, top100Keys);
        });
        return top100;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String toUxStructure() {
        StringBuilder value = new StringBuilder("\n\n\n#\n# Table " + this.getTableName() + "\n#\n");
        Map<IOlapBuilderDataColumnDef, Comparable[]> top100 = this.getTopValues(100, false);
        ArrayList<IOlapBuilderDataColumnDef> sortedCols = new ArrayList<IOlapBuilderDataColumnDef>(top100.keySet());
        sortedCols.sort(Comparator.comparingInt(this::getExistingCountUnique));
        sortedCols.forEach(col -> {
            Comparable[] values = (Comparable[])top100.get(col);
            value.append("\n#").append(col.getName()).append(col.getType().getShortName()).append(" - ").append(this.getExistingCountUnique((IOlapBuilderDataColumnDef)col)).append(" distinct values : ");
            for (int i = 0; i < values.length; ++i) {
                Comparable val = values[i];
                int count = this.getExistingCount((IOlapBuilderDataColumnDef)col, val);
                value.append(i == 0 ? "" : ", ").append(val).append(" (").append(count).append(")");
            }
        });
        return value.toString();
    }
}

