/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.exception.programming.CdUnsupportedSwitchTypeException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder2.cruncher.IUxCruncherColumn;
import org.jetbrains.annotations.Nullable;

public class UxCruncherColType
implements IUxCruncherColumn {
    private final OlapBuilderInputType originalType;
    private final int stopAfterMatchingCases;
    @Nullable
    private OlapBuilderInputType suggestedType;
    private boolean noMatchFound = false;
    private String errorMessage;
    private int matchesFound = -1;

    public UxCruncherColType(OlapBuilderInputType originalType, int stopAfterMatchingCases) {
        this.originalType = originalType;
        this.stopAfterMatchingCases = stopAfterMatchingCases;
    }

    @Override
    public boolean analyse(Comparable newValue) {
        if (this.noMatchFound) {
            return false;
        }
        if (newValue == null) {
            return true;
        }
        if (this.suggestedType != null) {
            if (!this.check(newValue, this.suggestedType)) {
                this.noMatchFound = true;
                this.errorMessage = "Value [" + String.valueOf(newValue) + "] could not be converted tu expected type" + String.valueOf((Object)this.suggestedType);
            }
            return this.matchesFound++ < this.stopAfterMatchingCases || this.stopAfterMatchingCases < 0;
        }
        if (this.check(newValue, OlapBuilderInputType.INTEGER)) {
            this.suggestedType = OlapBuilderInputType.INTEGER;
            return true;
        }
        if (this.check(newValue, OlapBuilderInputType.DOUBLE)) {
            this.suggestedType = OlapBuilderInputType.DOUBLE;
            return true;
        }
        if (this.check(newValue, OlapBuilderInputType.DATE)) {
            this.suggestedType = OlapBuilderInputType.DATE;
            return true;
        }
        if (this.check(newValue, OlapBuilderInputType.DATETIME)) {
            this.suggestedType = OlapBuilderInputType.DATETIME;
            return true;
        }
        return false;
    }

    @Override
    public String report() {
        if (this.noMatchFound) {
            return "No matching type could be found : " + this.errorMessage;
        }
        if (this.suggestedType != null) {
            return "Matching type found  = " + this.suggestedType.getShortName();
        }
        return "No type could be found ";
    }

    private boolean check(Comparable newValue, OlapBuilderInputType expectedType) {
        switch (expectedType) {
            case INTEGER: 
            case DOUBLE: 
            case DATE: 
            case DATETIME: 
            case BOOLEAN: {
                return this.checkGeneric(newValue, expectedType);
            }
        }
        throw new CdUnsupportedSwitchTypeException((Enum)expectedType);
    }

    private boolean checkGeneric(Comparable newValue, OlapBuilderInputType type) {
        try {
            type.getTypeConverter().toScalarEntity(newValue);
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }
}

