/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdPair;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.executor.common.OlapBuilderTableHelper;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder2.cruncher.IUxCruncherColumn;
import crazydev.iccube.builder2.cruncher.UxCruncherColType;
import crazydev.iccube.builder2.cruncher.UxCruncherColValues;
import crazydev.iccube.builder2.cruncher.UxCruncherConfiguration;
import crazydev.iccube.builder2.cruncher.UxCruncherFlatReport;
import crazydev.iccube.builder2.cruncher.UxCruncherHierarchicalReport;
import crazydev.iccube.builder2.cruncher.UxCruncherResult;
import crazydev.iccube.builder2.cruncher.UxCruncherSameNames;
import crazydev.iccube.builder2.cruncher.UxCruncherSchemaScriptReport;
import crazydev.iccube.builder2.cruncher.UxCruncherTableAnalyzerFlat;
import crazydev.iccube.builder2.cruncher.UxCruncherTableAnalyzerHierarchical;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public abstract class UxCruncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IUxCruncherColumn> crunchColumnOnly(OlapEngineRequestContext engineRequestContext, OlapBuilderBaseDataTable table, IOlapBuilderDataColumnDef column, int limit) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            UxCruncherColValues typeDiscoverer = new UxCruncherColValues(column.getType(), -1);
            UxCruncherColType colValues = new UxCruncherColType(column.getType(), -1);
            UxCruncher.browseTable(engineRequestContext, table, row -> {
                @Nullable Comparable value = row.getJavaNativeDataValue(column);
                boolean cont = typeDiscoverer.analyse(value);
                return cont |= colValues.analyse(value);
            }, connectionPool);
            List<IUxCruncherColumn> list = Arrays.asList(typeDiscoverer, colValues);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UxCruncherHierarchicalReport crunchTable(OlapEngineRequestContext engineRequestContext, OlapBuilderBaseDataTable table, int limit) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            UxCruncherTableAnalyzerHierarchical hierarchical = new UxCruncherTableAnalyzerHierarchical(table);
            MutableInt rowCount = new MutableInt(0);
            UxCruncher.browseTable(engineRequestContext, table, row -> {
                rowCount.increment();
                return (limit != -1 || rowCount.intValue() > limit) && hierarchical.analyse((IOlapBuilderTableRow)row);
            }, connectionPool);
            UxCruncherHierarchicalReport uxCruncherHierarchicalReport = UxCruncherHierarchicalReport.build(hierarchical);
            return uxCruncherHierarchicalReport;
        }
    }

    public static List<UxCruncherSameNames> crunchColumnNames(Iterable<OlapBuilderBaseDataTable> tablesIter) {
        ArrayList<UxCruncherSameNames> list = new ArrayList<UxCruncherSameNames>();
        ArrayList tables = CdCollections.list(tablesIter);
        for (int i = 0; i < tables.size(); ++i) {
            OlapBuilderBaseDataTable table1 = (OlapBuilderBaseDataTable)tables.get(i);
            for (int j = i + 1; j < tables.size(); ++j) {
                OlapBuilderBaseDataTable table2 = (OlapBuilderBaseDataTable)tables.get(j);
                UxCruncher.checkCoincidence(list, table1, table2);
            }
        }
        return list;
    }

    private static List<UxCruncherSameNames> checkCoincidence(List<UxCruncherSameNames> list, OlapBuilderBaseDataTable table1, OlapBuilderBaseDataTable table2) {
        List<IOlapBuilderDataColumnDef> cols1 = table1.getSelectedColumns();
        List<IOlapBuilderDataColumnDef> cols2 = table2.getSelectedColumns();
        for (int i = 0; i < cols1.size(); ++i) {
            IOlapBuilderDataColumnDef col1 = cols1.get(i);
            for (int j = 0; j < cols2.size(); ++j) {
                String bigName;
                IOlapBuilderDataColumnDef col2 = cols2.get(j);
                String smallName = col1.getName().length() > col2.getName().length() ? col2.getName() : col1.getName();
                String string = bigName = col1.getName().length() > col2.getName().length() ? col1.getName() : col2.getName();
                if (!bigName.equalsIgnoreCase(smallName)) continue;
                list.add(new UxCruncherSameNames(table1, table2, col1, col2));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UxCruncherTableAnalyzerFlat.Coincidence> fullCrunchTable(OlapEngineRequestContext engineRequestContext, Iterable<OlapBuilderBaseDataTable> tables) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            ArrayList<UxCruncherTableAnalyzerFlat> crunchers = new ArrayList<UxCruncherTableAnalyzerFlat>();
            HashMap<OlapBuilderBaseDataTable, Set> aliasColumns = new HashMap<OlapBuilderBaseDataTable, Set>();
            for (OlapBuilderBaseDataTable table2 : tables) {
                UxCruncherTableAnalyzerFlat hierarchical = new UxCruncherTableAnalyzerFlat(table2);
                UxCruncherTableAnalyzerHierarchical toto = new UxCruncherTableAnalyzerHierarchical(table2);
                MutableInt rowCount = new MutableInt(0);
                UxCruncher.browseTable(engineRequestContext, table2, row -> {
                    rowCount.increment();
                    toto.analyse((IOlapBuilderTableRow)row);
                    return hierarchical.analyse((IOlapBuilderTableRow)row);
                }, connectionPool);
                aliasColumns.computeIfAbsent(table2, t -> new HashSet()).addAll(UxCruncherHierarchicalReport.build(toto).getAliasOf());
                crunchers.add(hierarchical);
            }
            ArrayList<UxCruncherTableAnalyzerFlat.Coincidence> items = new ArrayList<UxCruncherTableAnalyzerFlat.Coincidence>();
            for (int i = 0; i < crunchers.size(); ++i) {
                UxCruncherTableAnalyzerFlat cr1 = (UxCruncherTableAnalyzerFlat)crunchers.get(i);
                for (int j = i + 1; j < crunchers.size(); ++j) {
                    UxCruncherTableAnalyzerFlat cr2 = (UxCruncherTableAnalyzerFlat)crunchers.get(j);
                    items.addAll(cr1.link(cr2, (table, col) -> aliasColumns.getOrDefault(table, Collections.emptySet()).contains(col)));
                }
            }
            ArrayList<UxCruncherTableAnalyzerFlat.Coincidence> arrayList = items;
            return arrayList;
        }
    }

    private static void browseTable(OlapEngineRequestContext context, OlapBuilderBaseDataTable table, Predicate<IOlapBuilderTableRow> visitor, OlapBuilderConnectionPool connectionPool) {
        OlapBuilderTableHelper.readTabularData(context, null, connectionPool, null, table, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxCruncherResult crunchTable(OlapEngineRequestContext context, @Nullable String snapshot, @Nullable IOlapBuilderSchemaDef schemaDef, IOlapBuilderTabularDataDef tabularData, UxCruncherConfiguration configuration) {
        if (!configuration.distincts && !configuration.relations) {
            return null;
        }
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            int limit = configuration.maxRowCount;
            MutableObject relations = new MutableObject();
            MutableObject distincts = new MutableObject();
            MutableInt rowCount = new MutableInt(0);
            OlapBuilderTableHelper.readTabularData(context, snapshot, connectionPool, schemaDef, tabularData, row -> {
                if (rowCount.intValue() == 0) {
                    if (configuration.relations) {
                        relations.setValue((Object)new UxCruncherTableAnalyzerHierarchical(tabularData));
                    }
                    if (configuration.distincts) {
                        distincts.setValue((Object)new UxCruncherTableAnalyzerFlat(tabularData));
                    }
                }
                rowCount.increment();
                if (limit == -1 || rowCount.intValue() < limit) {
                    UxCruncherTableAnalyzerHierarchical relationsValue = (UxCruncherTableAnalyzerHierarchical)relations.get();
                    boolean res1 = relationsValue != null && relationsValue.analyse((IOlapBuilderTableRow)row);
                    UxCruncherTableAnalyzerFlat distinctsValue = (UxCruncherTableAnalyzerFlat)distincts.get();
                    boolean res2 = distinctsValue != null && distinctsValue.analyse((IOlapBuilderTableRow)row);
                    return res1 || res2;
                }
                return false;
            }, limit);
            UxCruncherTableAnalyzerHierarchical relationsValue = (UxCruncherTableAnalyzerHierarchical)relations.get();
            UxCruncherTableAnalyzerFlat distinctsValue = (UxCruncherTableAnalyzerFlat)distincts.get();
            if (relationsValue == null && distinctsValue == null) {
                UxCruncherResult uxCruncherResult = null;
                return uxCruncherResult;
            }
            UxCruncherResult uxCruncherResult = new UxCruncherResult(UxCruncherFlatReport.build(distinctsValue), UxCruncherHierarchicalReport.build(relationsValue));
            return uxCruncherResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CdPair<UxCruncherSchemaScriptReport, UxCruncherFlatReport> crunchTableForHierarchical(OlapEngineRequestContext context, @Nullable IOlapBuilderSchemaDef schemaDef, IOlapBuilderTabularDataDef tabularData, int limit) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            UxCruncherTableAnalyzerHierarchical hierarchical = new UxCruncherTableAnalyzerHierarchical(tabularData);
            UxCruncherTableAnalyzerFlat relations = new UxCruncherTableAnalyzerFlat(tabularData);
            MutableInt rowCount = new MutableInt(0);
            OlapBuilderTableHelper.readTabularData(context, null, connectionPool, schemaDef, tabularData, row -> {
                rowCount.increment();
                return (limit == -1 || rowCount.intValue() <= limit) && hierarchical.analyse((IOlapBuilderTableRow)row) && relations.analyse((IOlapBuilderTableRow)row);
            });
            CdPair cdPair = new CdPair((Object)UxCruncherSchemaScriptReport.build(hierarchical), (Object)UxCruncherFlatReport.build(relations));
            return cdPair;
        }
    }
}

