/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.ux.meta.facts.wizard;

import crazydev.common.collection.CdCollections;
import crazydev.common.utils.CdClassUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizard;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardProps;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.facts.wizard.UxBuilderCreateMeasureGroupWizardSteps;
import crazydev.iccube.builder.ux.meta.facts.wizard.UxBuilderMeasureGroupSetupType;
import crazydev.iccube.builder.ux.meta.facts.wizard.UxBuilderMeasureGroupSetupTypeForm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UxBuilderCreateMeasureGroupWizard
extends UxBuilderWizard {
    @Nullable
    private String cubeName;

    public UxBuilderCreateMeasureGroupWizard(@Nullable UxBuilderWizardProps props, List<UxBuilderWizardStep> steps) {
        super(props, steps);
        this.cubeName = props != null ? props.getStringProperty("cubeName") : null;
    }

    public static UxBuilderCreateMeasureGroupWizard create(@Nullable String cubeName) {
        UxBuilderWizardProps props = null;
        if (CdStringUtils.isNotNullAndNotBlank((String)cubeName)) {
            props = new UxBuilderWizardProps();
            props.addProperty("cubeName", cubeName);
        }
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        steps.add(UxBuilderCreateMeasureGroupWizardSteps.setupType());
        steps.add(UxBuilderCreateMeasureGroupWizardSteps.more());
        return new UxBuilderCreateMeasureGroupWizard(props, steps);
    }

    private int STEP_TYPE() {
        return 0;
    }

    private int STEP_CUBE_NAME() {
        return 1;
    }

    private int STEP_NAME() {
        return CdStringUtils.isNullOrBlank((String)this.cubeName) ? 2 : 1;
    }

    private int STEP_MEASURES() {
        return CdStringUtils.isNullOrBlank((String)this.cubeName) ? 3 : 2;
    }

    private int STEP_MAPPINGS() {
        return CdStringUtils.isNullOrBlank((String)this.cubeName) ? 4 : 3;
    }

    public boolean isMeasureFast() {
        int stepNB = this.STEP_TYPE();
        if (stepNB < this.steps.size()) {
            UxBuilderMeasureGroupSetupTypeForm setupTypeFORM = (UxBuilderMeasureGroupSetupTypeForm)((UxBuilderWizardStep)this.steps.get(stepNB)).getModel();
            UxBuilderMeasureGroupSetupType setupType = setupTypeFORM.getSetupType();
            return setupType == UxBuilderMeasureGroupSetupType.FAST;
        }
        return false;
    }

    public UxBuilderWizardValidation validate(OlapBuilderSchema schema, int activeStep) {
        if (activeStep == this.STEP_TYPE()) {
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            if (CdStringUtils.isNullOrBlank((String)this.cubeName)) {
                newSteps.add(UxBuilderCreateMeasureGroupWizardSteps.cubeName());
            }
            newSteps.add(UxBuilderCreateMeasureGroupWizardSteps.name());
            newSteps.add(UxBuilderCreateMeasureGroupWizardSteps.more());
            return new UxBuilderWizardValidation(activeStep, newSteps);
        }
        if (activeStep == this.STEP_NAME()) {
            UxBuilderMeasureGroupSetupTypeForm setupTypeFORM = (UxBuilderMeasureGroupSetupTypeForm)((UxBuilderWizardStep)this.steps.get(this.STEP_TYPE())).getModel();
            UxBuilderMeasureGroupSetupType setupType = setupTypeFORM.getSetupType();
            OlapBuilderFacts measureGroup = (OlapBuilderFacts)((UxBuilderWizardStep)this.steps.get(this.STEP_NAME())).getModel();
            switch (setupType) {
                case DETAILED: {
                    return new UxBuilderWizardValidation(activeStep, UxBuilderCreateMeasureGroupWizard.createDetailedSetupSteps(schema, measureGroup));
                }
                case FAST: {
                    return new UxBuilderWizardValidation(activeStep, UxBuilderCreateMeasureGroupWizard.createFastSetupSteps(schema, measureGroup));
                }
            }
            return new UxBuilderWizardValidation(activeStep);
        }
        if (activeStep == this.STEP_MAPPINGS()) {
            OlapBuilderFacts mappings = (OlapBuilderFacts)((UxBuilderWizardStep)this.steps.get(this.STEP_MAPPINGS())).getModel();
            this.validateMappings(schema, mappings);
        }
        return new UxBuilderWizardValidation(activeStep);
    }

    private void validateMappings(OlapBuilderSchema schema, OlapBuilderFacts<?> measureGroup) {
        List notMapped = measureGroup.getLinks().stream().filter(l -> l == null || l.getLink().getType() == OlapBuilderDataViewLinksType.NOT_SPECIFIED).collect(Collectors.toList());
        if (!notMapped.isEmpty()) {
            String notSpecified = CdCollections.toString(notMapped, (String)"", (String)", ", link -> (String)CdClassUtils.coales((Object)schema.getDimensionByUUID(link.getDimensionId()), IOlapBuilderNamedDef::getName, (Object)""));
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_LINKS_MISSING, new Serializable[]{"", notSpecified});
        }
    }

    private static List<UxBuilderWizardStep> createDetailedSetupSteps(OlapBuilderSchema schema, OlapBuilderFacts measureGroup) {
        ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
        newSteps.add(UxBuilderCreateMeasureGroupWizardSteps.measures(schema, measureGroup, false));
        newSteps.add(UxBuilderCreateMeasureGroupWizardSteps.mappings(measureGroup));
        return newSteps;
    }

    private static List<UxBuilderWizardStep> createFastSetupSteps(OlapBuilderSchema schema, OlapBuilderFacts measureGroup) {
        ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
        newSteps.add(UxBuilderCreateMeasureGroupWizardSteps.measures(schema, measureGroup, true));
        newSteps.add(UxBuilderCreateMeasureGroupWizardSteps.mappings(measureGroup));
        return newSteps;
    }

    @Nullable
    public IOlapBuilderBaseFactsDef getCreatedMeasureGroupFromUI() {
        UxBuilderMeasureGroupSetupTypeForm setupTypeFORM = (UxBuilderMeasureGroupSetupTypeForm)((UxBuilderWizardStep)this.steps.get(this.STEP_TYPE())).getModel();
        UxBuilderMeasureGroupSetupType setupType = setupTypeFORM.getSetupType();
        OlapBuilderFacts measureGroup = (OlapBuilderFacts)((UxBuilderWizardStep)this.steps.get(this.STEP_NAME())).getModel();
        switch (setupType) {
            case DETAILED: {
                return this.getCreatedMeasureGroupFromDetailedSetup(measureGroup);
            }
            case FAST: {
                return this.getCreatedMeasureGroupFromFastSetup(measureGroup);
            }
        }
        return null;
    }

    private IOlapBuilderBaseFactsDef getCreatedMeasureGroupFromDetailedSetup(OlapBuilderFacts measureGroup) {
        return this.getCreatedMeasureGroupFromSetup(measureGroup);
    }

    private IOlapBuilderBaseFactsDef getCreatedMeasureGroupFromFastSetup(OlapBuilderFacts measureGroup) {
        OlapBuilderFacts facts = (OlapBuilderFacts)this.getCreatedMeasureGroupFromSetup(measureGroup);
        facts.fixForSelectedMeasures();
        return facts;
    }

    private IOlapBuilderBaseFactsDef getCreatedMeasureGroupFromSetup(OlapBuilderFacts measureGroup) {
        OlapBuilderFacts measures = (OlapBuilderFacts)((UxBuilderWizardStep)this.steps.get(this.STEP_MEASURES())).getModel();
        OlapBuilderFacts mappings = (OlapBuilderFacts)((UxBuilderWizardStep)this.steps.get(this.STEP_MAPPINGS())).getModel();
        if (CdStringUtils.isNullOrBlank((String)this.cubeName)) {
            OlapBuilderFacts wCubeName = (OlapBuilderFacts)((UxBuilderWizardStep)this.steps.get(this.STEP_CUBE_NAME())).getModel();
            measureGroup.setCubeName(wCubeName.getCubeName());
        } else {
            measureGroup.setCubeName(this.cubeName);
        }
        measureGroup.setDefinedMeasures(measures.getDefinedMeasures());
        measureGroup.setUxMappings(mappings.getUxMappings());
        return measureGroup;
    }
}

