/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.ux.meta.dimension.wizard;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.collection.CdPair;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.common.utils.CdUiEnums;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifier;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderMultiLevelDimension;
import crazydev.iccube.builder.ux.meta.common.model.UxAutomodel;
import crazydev.iccube.builder.ux.meta.common.model.UxSchemaInfoReadI;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.dimension.wizard.UxBuilderCreateDimensionWizard;
import crazydev.iccube.builder.ux.meta.dimension.wizard.UxBuilderCreateDimensionWizardSteps;
import crazydev.iccube.builder.ux.meta.dimension.wizard.UxBuilderSingleHierarchy;
import crazydev.iccube.builder.ux.meta.dimension.wizard.UxBuilderSingleHierarchyMultiTables;
import crazydev.iccube.builder2.cruncher.UxCruncherFlatReport;
import crazydev.iccube.builder2.cruncher.UxCruncherSchemaScriptParser;
import crazydev.iccube.builder2.cruncher.UxCruncherSchemaScriptReport;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UxBuilderMultiLevelDimensionWizard
implements UxBuilderCreateDimensionWizard.UxTimeWizard {
    @Override
    public UxBuilderWizardValidation validate(OlapRuntimeContext context, CdBabylonService babylon, UxSchemaInfoReadI schemaInfoReadI, List<UxBuilderWizardStep> steps, int activeStep) {
        if (activeStep == 0) {
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            WizardOrNotChooser toto = new WizardOrNotChooser();
            newSteps.add(UxBuilderCreateDimensionWizardSteps.props("multiLevelDimWizard.step.chooser", toto, true, true).withFullWidth());
            newSteps.add(UxBuilderCreateDimensionWizardSteps.more());
            return new UxBuilderWizardValidation(activeStep, newSteps);
        }
        WizardOrNotChooser model = (WizardOrNotChooser)steps.get(1).getModel();
        switch (model.wizardChooserType.ordinal()) {
            case 0: {
                return this.singleHierarchyMultiTablesWizard(context, babylon, schemaInfoReadI, steps, activeStep);
            }
            case 1: {
                return this.singleHierarchyWizard(context, babylon, schemaInfoReadI, steps, activeStep);
            }
            case 2: {
                return this.oneTableWizard(context, babylon, schemaInfoReadI, steps, activeStep);
            }
            case 3: {
                return this.letMeDecide(context, schemaInfoReadI, steps, activeStep);
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    private UxBuilderWizardValidation singleHierarchyWizard(OlapRuntimeContext context, CdBabylonService babylon, UxSchemaInfoReadI schemaInfoReadI, List<UxBuilderWizardStep> steps, int activeStep) {
        ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
        UxBuilderSingleHierarchy model = new UxBuilderSingleHierarchy();
        newSteps.add(UxBuilderCreateDimensionWizardSteps.props("multiLevelDimWizard.step.singleHierarchy", (Object)model));
        return new UxBuilderWizardValidation(activeStep, newSteps);
    }

    private UxBuilderWizardValidation singleHierarchyMultiTablesWizard(OlapRuntimeContext context, CdBabylonService babylon, UxSchemaInfoReadI schemaInfoReadI, List<UxBuilderWizardStep> steps, int activeStep) {
        ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
        UxBuilderSingleHierarchyMultiTables model = new UxBuilderSingleHierarchyMultiTables();
        newSteps.add(UxBuilderCreateDimensionWizardSteps.props("multiLevelDimWizard.step.singleHierarchyMultipleTables", (Object)model));
        return new UxBuilderWizardValidation(activeStep, newSteps);
    }

    private UxBuilderWizardValidation letMeDecide(OlapRuntimeContext context, UxSchemaInfoReadI schemaInfoReadI, List<UxBuilderWizardStep> steps, int activeStep) {
        ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
        OlapBuilderMultiLevelDimension dimension = new OlapBuilderMultiLevelDimension();
        newSteps.add(UxBuilderCreateDimensionWizardSteps.dimension(dimension));
        return new UxBuilderWizardValidation(activeStep, newSteps);
    }

    private UxBuilderWizardValidation oneTableWizard(OlapRuntimeContext context, CdBabylonService babylon, UxSchemaInfoReadI schemaInfoReadI, List<UxBuilderWizardStep> steps, int activeStep) {
        if (activeStep == 1) {
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            WizardType toto = new WizardType();
            newSteps.add(UxBuilderCreateDimensionWizardSteps.props("multiLevelDimWizard.step.type", toto, true, true).withFullWidth());
            newSteps.add(UxBuilderCreateDimensionWizardSteps.more());
            return new UxBuilderWizardValidation(activeStep, newSteps);
        }
        WizardType model = (WizardType)steps.get(2).getModel();
        switch (model.wizardType.ordinal()) {
            case 0: {
                return this.oneAnalyzeTable(context, babylon, schemaInfoReadI, steps, activeStep);
            }
            case 1: {
                return this.onFlatView(context, babylon, schemaInfoReadI, steps, activeStep);
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    private UxBuilderWizardValidation onFlatView(OlapRuntimeContext context, CdBabylonService babylon, UxSchemaInfoReadI schemaInfoReadI, List<UxBuilderWizardStep> steps, int activeStep) {
        if (activeStep == 2) {
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            FlatTableModel toto = new FlatTableModel();
            newSteps.add(UxBuilderCreateDimensionWizardSteps.props("multiLevelDimWizard.step.flatTable", (Object)toto, true));
            newSteps.add(UxBuilderCreateDimensionWizardSteps.more());
            return new UxBuilderWizardValidation(activeStep, newSteps);
        }
        if (activeStep == 3) {
            FlatTableModel model = (FlatTableModel)steps.get(3).getModel();
            String script = UxCruncherSchemaScriptParser.flatScript(schemaInfoReadI.getTableOrView(model.dataTableId), model.addDoubleAsMeasures);
            return this.tableDimensionBuilderStep(steps, activeStep, schemaInfoReadI, script);
        }
        if (activeStep == 4) {
            this.getModel(babylon, schemaInfoReadI, steps);
            return new UxBuilderWizardValidation(activeStep, Collections.emptyList());
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    private UxBuilderWizardValidation oneAnalyzeTable(OlapRuntimeContext context, CdBabylonService babylon, UxSchemaInfoReadI schemaInfoReadI, List<UxBuilderWizardStep> steps, int activeStep) {
        if (activeStep == 2) {
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            TableScanRowCount toto = new TableScanRowCount(10000);
            newSteps.add(UxBuilderCreateDimensionWizardSteps.props("multiLevelDimWizard.step.tableAnalyze", (Object)toto, true));
            newSteps.add(UxBuilderCreateDimensionWizardSteps.more());
            return new UxBuilderWizardValidation(activeStep, newSteps);
        }
        if (activeStep == 3) {
            TableScanRowCount model = (TableScanRowCount)steps.get(3).getModel();
            CdPair<UxCruncherSchemaScriptReport, UxCruncherFlatReport> pair = schemaInfoReadI.crunchTableOrView(model.dataTableId, model.size);
            UxCruncherSchemaScriptReport dimensionsReport = (UxCruncherSchemaScriptReport)pair.fst;
            UxCruncherFlatReport flatReport = (UxCruncherFlatReport)pair.snd;
            return this.tableDimensionBuilderStep(steps, activeStep, schemaInfoReadI, dimensionsReport.toUxStructure() + flatReport.toUxStructure());
        }
        if (activeStep == 4) {
            this.getModel(babylon, schemaInfoReadI, steps);
            return new UxBuilderWizardValidation(activeStep, Collections.emptyList());
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    private UxBuilderWizardValidation tableDimensionBuilderStep(List<UxBuilderWizardStep> steps, int activeStep, UxSchemaInfoReadI schemaInfoReadI, String script) {
        ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
        WizardScript toto = new WizardScript(script);
        newSteps.add(UxBuilderCreateDimensionWizardSteps.props("multiLevelDimWizard.step.dimensionBuilder", (Object)toto, true));
        return new UxBuilderWizardValidation(activeStep, newSteps);
    }

    @Override
    public List<IOlapBuilderNamedDef> getModel(CdBabylonService babylon, UxSchemaInfoReadI schemaInfoR, List<UxBuilderWizardStep> steps) {
        WizardOrNotChooser chooser = (WizardOrNotChooser)steps.get(1).getModel();
        if (chooser.wizardChooserType == WizardChooserEnum.LetMeDecide) {
            return Collections.singletonList((IOlapBuilderDimensionDef)steps.get(2).getModel());
        }
        if (chooser.wizardChooserType == WizardChooserEnum.SingleHierarchy) {
            UxBuilderSingleHierarchy props = (UxBuilderSingleHierarchy)steps.get(2).getModel();
            return Collections.singletonList(props.toDimension());
        }
        if (chooser.wizardChooserType == WizardChooserEnum.SingleHierarchyMultiTable) {
            UxBuilderSingleHierarchyMultiTables props = (UxBuilderSingleHierarchyMultiTables)steps.get(2).getModel();
            return Collections.singletonList(props.toDimension());
        }
        Table table = (Table)steps.get(3).getModel();
        WizardScript model = (WizardScript)steps.get(4).getModel();
        return UxCruncherSchemaScriptParser.getWizardModel(babylon, schemaInfoR, table.dataTableId, model.script);
    }

    public static class WizardOrNotChooser
    implements UxAutomodel {
        public static final CdProperty type = new CdReadWriteProperty(WizardOrNotChooser.class, "wizardChooserType", true){

            public Class<?> getTypeForDefaultEditor() {
                return CdUiEnums.CdEnumActionable.class;
            }
        };
        private WizardChooserEnum wizardChooserType;
    }

    public static enum WizardChooserEnum {
        SingleHierarchyMultiTable,
        SingleHierarchy,
        TableWizard,
        LetMeDecide;

    }

    public static class WizardType
    implements UxAutomodel {
        public static final CdProperty type = new CdReadWriteProperty(WizardType.class, "wizardType", true){

            public Class<?> getTypeForDefaultEditor() {
                return CdUiEnums.CdEnumActionable.class;
            }
        };
        private KindWizardEnum wizardType;
    }

    public static enum KindWizardEnum {
        AnalyzeTableAndProposeHierarchies,
        ProposeFlatWithoutTableAnalyze;

    }

    public static class FlatTableModel
    extends Table {
        public static final CdProperty ADDDOUBLEASMEASURES = new CdReadWriteProperty(FlatTableModel.class, "addDoubleAsMeasures", true);
        private boolean addDoubleAsMeasures;
    }

    public static class TableScanRowCount
    extends Table {
        public static final CdProperty SIZE = new CdReadWriteProperty(TableScanRowCount.class, "size", true);
        private int size;

        public TableScanRowCount() {
        }

        public TableScanRowCount(int size) {
            this.size = size;
        }
    }

    public static class WizardScript
    implements UxAutomodel {
        public static final CdProperty type = new CdReadWriteProperty(WizardScript.class, "script", true){

            public Class<?> getTypeForDefaultEditor() {
                return CdJson.class;
            }
        };
        private String script;

        public WizardScript(String script) {
            this.script = script;
        }

        public WizardScript() {
        }
    }

    public static abstract class Table
    implements UxAutomodel {
        public static final CdProperty DATA_VIEW = new CdReadWriteProperty(Table.class, "dataTableId"){

            public Class<?> getType() {
                return OlapBuilderTabularDataXmlIdentifier.class;
            }
        };
        protected String dataTableId;
    }
}

