/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.ux.meta;

import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroup;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewType;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroup;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroupId;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class UxBuilderMetaInfo {
    public static boolean TEST_IGNORE_SET_DATASOURCE = false;
    private final OlapBuilderMetaInformationRepository underlying;
    private final List<UxBuilderDataSourceTypeGroup> dataSourceTypeGroups = new ArrayList<UxBuilderDataSourceTypeGroup>();
    private final List<UxBuilderDataViewTypeGroup> dataViewTypeGroups = new ArrayList<UxBuilderDataViewTypeGroup>();

    public UxBuilderMetaInfo(OlapBuilderMetaInformationRepository underlying) {
        this.underlying = underlying;
        this.dataSourceTypeGroups.add(new UxBuilderDataSourceTypeGroup(UxBuilderDataSourceTypeGroupId.dsTypeGroupFiles));
        this.dataSourceTypeGroups.add(new UxBuilderDataSourceTypeGroup(UxBuilderDataSourceTypeGroupId.dsTypeGroupSql));
        this.dataSourceTypeGroups.add(new UxBuilderDataSourceTypeGroup(UxBuilderDataSourceTypeGroupId.dsTypeGroupNoSql));
        this.dataSourceTypeGroups.add(new UxBuilderDataSourceTypeGroup(UxBuilderDataSourceTypeGroupId.dsTypeGroupGoogle));
        this.dataSourceTypeGroups.add(new UxBuilderDataSourceTypeGroup(UxBuilderDataSourceTypeGroupId.dsTypeGroupOthers));
        this.dataViewTypeGroups.add(new UxBuilderDataViewTypeGroup(UxBuilderDataViewTypeGroupId.dvTypeGroupClassic));
        this.dataViewTypeGroups.add(new UxBuilderDataViewTypeGroup(UxBuilderDataViewTypeGroupId.dvTypeGroupSourceCode));
        this.dataViewTypeGroups.add(new UxBuilderDataViewTypeGroup(UxBuilderDataViewTypeGroupId.dvTypeGroupOthers));
    }

    public void setupDataSourceTypes(Set<Class<OlapBuilderBaseDataSource>> dataSources) {
        for (Class<OlapBuilderBaseDataSource> dataSource : dataSources) {
            try {
                OlapBuilderBaseDataSource ds;
                try {
                    Constructor<OlapBuilderBaseDataSource> ctor = dataSource.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    ds = ctor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    OlapLoggers.BUILDER.error((Object)"[meta] datasource setup error", (Throwable)ex);
                    throw new RuntimeException("internal error: could not create datasource [" + dataSource.getSimpleName() + "]", ex);
                }
                if (ds.isExcludedFromUI()) continue;
                UxBuilderDataSourceTypeGroupId groupId = ds.getUxGroupId();
                UxBuilderDataSourceTypeGroup group = this.getDataSourceTypeGroup(groupId);
                ds.setupUxType(group);
            }
            catch (NoClassDefFoundError ex) {
                if (TEST_IGNORE_SET_DATASOURCE) continue;
                throw ex;
            }
        }
    }

    private UxBuilderDataSourceTypeGroup getDataSourceTypeGroup(UxBuilderDataSourceTypeGroupId groupId) {
        for (UxBuilderDataSourceTypeGroup group : this.dataSourceTypeGroups) {
            if (!group.getId().equals((Object)groupId)) continue;
            return group;
        }
        throw new RuntimeException("internal error: missing datasource group [" + String.valueOf((Object)groupId) + "]");
    }

    public void setupDataViewTypes(Set<Class<OlapBuilderBaseDataView>> dataViews) {
        for (Class<OlapBuilderBaseDataView> dataView : dataViews) {
            OlapBuilderBaseDataView ds;
            try {
                Constructor<OlapBuilderBaseDataView> ctor = dataView.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                ds = ctor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                OlapLoggers.BUILDER.error((Object)"[meta] dataview setup error", (Throwable)ex);
                throw new RuntimeException("internal error: could not create dataview [" + dataView.getSimpleName() + "]", ex);
            }
            UxBuilderDataViewTypeGroupId groupId = ds.getUxGroupId();
            UxBuilderDataViewTypeGroup group = this.getDataViewTypeGroup(groupId);
            ds.setupUxType(group);
        }
    }

    private UxBuilderDataViewTypeGroup getDataViewTypeGroup(UxBuilderDataViewTypeGroupId groupId) {
        for (UxBuilderDataViewTypeGroup group : this.dataViewTypeGroups) {
            if (!group.getId().equals((Object)groupId)) continue;
            return group;
        }
        throw new RuntimeException("internal error: missing dataview group [" + String.valueOf((Object)groupId) + "]");
    }

    public List<UxBuilderDataSourceTypeGroup> getDataSourceTypeGroups() {
        return this.dataSourceTypeGroups;
    }

    @Nullable
    public UxBuilderDataSourceType getDataSourceType(String typeId) {
        for (UxBuilderDataSourceTypeGroup group : this.dataSourceTypeGroups) {
            for (UxBuilderDataSourceType type : group.getTypes()) {
                if (!type.getId().equals(typeId)) continue;
                return type;
            }
        }
        return null;
    }

    public List<UxBuilderDataViewTypeGroup> getDataViewTypeGroups() {
        return this.dataViewTypeGroups;
    }

    @Nullable
    public UxBuilderDataViewType getDataViewType(String classNameOrSimpleClassName) {
        for (UxBuilderDataViewTypeGroup group : this.dataViewTypeGroups) {
            for (UxBuilderDataViewType type : group.getTypes()) {
                if (!type.isOf(classNameOrSimpleClassName)) continue;
                return type;
            }
        }
        return null;
    }
}

