/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.type.converters;

import crazydev.iccube.builder.errors.OlapBuilderInputTypeConversionErrorException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder.type.converters.BaseOlapInputTypeConverter;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapDateScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;
import oracle.sql.Datum;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.format.ISODateTimeFormat;

public final class OlapBuilderDateTypeConverter
extends BaseOlapInputTypeConverter<org.joda.time.LocalDate> {
    public OlapBuilderDateTypeConverter() {
        super(org.joda.time.LocalDate.class);
    }

    @Override
    public OlapScalarEntityFactColumn createScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        return new OlapDateScalarEntityFactColumn(listFactory, id, valueInputType);
    }

    @Override
    public Object toJdbcForPartitionKey(String value) {
        return Date.valueOf(value);
    }

    @Override
    public String toStringForPartitionKey(Object value) {
        org.joda.time.LocalDate value_ = this.toJavaNativeValueInternally("partition-column", value);
        String strValue = value_.toString();
        return strValue;
    }

    @Override
    public org.joda.time.LocalDate toJavaNativeValueInternally(String columnName, Object inputValue) {
        if (inputValue instanceof org.joda.time.LocalDate) {
            return (org.joda.time.LocalDate)inputValue;
        }
        if (inputValue instanceof LocalDate) {
            return CdJodaTimeUtil.toDate((LocalDate)((LocalDate)inputValue));
        }
        if (inputValue instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)inputValue;
            return dateTime.toLocalDate();
        }
        if (inputValue instanceof java.time.LocalDateTime) {
            return CdJodaTimeUtil.toDate((java.time.LocalDateTime)((java.time.LocalDateTime)inputValue));
        }
        if (inputValue instanceof String) {
            String dataAsString = (String)inputValue;
            if (StringUtils.isNumeric((CharSequence)dataAsString)) {
                try {
                    double epoch = Double.parseDouble(dataAsString);
                    return OlapBuilderDateTypeConverter.toLocalDate(epoch);
                }
                catch (NumberFormatException epoch) {
                    // empty catch block
                }
            }
            org.joda.time.LocalDate dateAsTime = new org.joda.time.LocalDate((Object)dataAsString);
            return dateAsTime;
        }
        if (inputValue instanceof Number) {
            double epoch = ((Number)inputValue).doubleValue();
            return OlapBuilderDateTypeConverter.toLocalDate(epoch);
        }
        try {
            if (inputValue instanceof Datum) {
                Datum datum = (Datum)inputValue;
                org.joda.time.LocalDate date = new org.joda.time.LocalDate(datum.toJdbc());
                return date;
            }
            org.joda.time.LocalDate date = new org.joda.time.LocalDate(inputValue);
            return date;
        }
        catch (RuntimeException | SQLException ex) {
            throw new OlapBuilderInputTypeConversionErrorException(columnName, this, inputValue, ex);
        }
    }

    private static org.joda.time.LocalDate toLocalDate(double epochInSeconds) {
        java.util.Date jDate = new java.util.Date((long)(epochInSeconds * 1000.0));
        return new org.joda.time.LocalDate((Object)jDate, DateTimeZone.UTC);
    }

    @Override
    @Nullable
    public Comparable parseJavaNativeValue(String inputValue) {
        try {
            org.joda.time.LocalDate date = ISODateTimeFormat.localDateOptionalTimeParser().parseLocalDate(inputValue);
            return date;
        }
        catch (IllegalArgumentException | UnsupportedOperationException ignored) {
            return null;
        }
    }
}

