/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.type;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.builder.type.IOlapBuilderInputTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderBooleanTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderDateTimeTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderDateTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderDbUnsupportedTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderDoubleTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderFloatTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderIntegerTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderJavaObjectTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderLongTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderShortTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderStringTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderUStringTypeConverter;
import crazydev.iccube.builder.type.converters.OlapBuilderUnknownTypeConverter;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import jakarta.xml.bind.annotation.XmlEnum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.Strings;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@XmlEnum
public enum OlapBuilderInputType {
    DB_TYPE_UNSUPPORTED("<Type.Unsupported>", CdXmlaSchemaType.DBTYPE_VARIANT, new OlapBuilderDbUnsupportedTypeConverter(), new int[0]),
    DB_TYPE_UNKNOWN("<Type.Unknown>", CdXmlaSchemaType.DBTYPE_WSTR, new OlapBuilderUnknownTypeConverter(), new int[0]),
    DATE("<Type.Date>", CdXmlaSchemaType.DBTYPE_DATE, new OlapBuilderDateTypeConverter(), 91),
    DATETIME("<Type.DateTime>", CdXmlaSchemaType.DBTYPE_DBTIMESTAMP, new OlapBuilderDateTimeTypeConverter(), 93),
    BOOLEAN("<Type.Boolean>", CdXmlaSchemaType.DBTYPE_BOOL, new OlapBuilderBooleanTypeConverter(), -7, 16),
    DOUBLE("<Type.Double>", CdXmlaSchemaType.DBTYPE_R8, new OlapBuilderDoubleTypeConverter(), 6, 8, 2, 3),
    FLOAT("<Type.Float>", CdXmlaSchemaType.DBTYPE_R4, new OlapBuilderFloatTypeConverter(), 7),
    SHORT("<Type.Short>", CdXmlaSchemaType.DBTYPE_I2, new OlapBuilderShortTypeConverter(), -6, 5),
    INTEGER("<Type.Integer>", CdXmlaSchemaType.DBTYPE_I4, new OlapBuilderIntegerTypeConverter(), 4),
    LONG("<Type.Long>", CdXmlaSchemaType.DBTYPE_I8, new OlapBuilderLongTypeConverter(), -5, -8),
    STRING("<Type.String>", CdXmlaSchemaType.DBTYPE_WSTR, new OlapBuilderStringTypeConverter(), 12, -1, -9, -16, 1, -15),
    UPPERCASE_STRING("<Type.UString>", CdXmlaSchemaType.DBTYPE_WSTR, new OlapBuilderUStringTypeConverter(), new int[0]),
    JAVA_OBJECT("<Type.JavaObject>", CdXmlaSchemaType.DBTYPE_BYREF, new OlapBuilderJavaObjectTypeConverter(), 2000);

    private final String name;
    private final CdXmlaSchemaType type;
    private final IOlapBuilderInputTypeConverter typeConverter;
    private final int[] dbTypes;

    private OlapBuilderInputType(String name, CdXmlaSchemaType type, IOlapBuilderInputTypeConverter typeConverter, int ... dbTypes) {
        this.name = name;
        this.type = type;
        this.typeConverter = typeConverter;
        this.dbTypes = dbTypes;
        if (!type.isCompatible(typeConverter.getType())) {
            throw new CdProgrammingException("Unexpected converter type for XMLA type!");
        }
    }

    public String getName() {
        return this.name;
    }

    public CdXmlaSchemaType getXmlaType() {
        return this.type;
    }

    public int[] getDbTypes() {
        return this.dbTypes != null ? this.dbTypes : new int[]{};
    }

    public OlapScalarEntityFactColumn createScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id) {
        return this.typeConverter.createScalarEntityFactColumn(listFactory, id, this);
    }

    public OlapScalarEntityFactColumn createScalarEntityVectorFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id) {
        return this.typeConverter.createScalarEntityVectorFactColumn(listFactory, id, this);
    }

    public Object toJdbcForPartitionKey(String value) {
        return this.typeConverter.toJdbcForPartitionKey(value);
    }

    public String toStringForPartitionKey(Object value) {
        return this.typeConverter.toStringForPartitionKey(value);
    }

    public OlapScalarEntity toScalarEntity(Object inputValue) {
        return this.typeConverter.toScalarEntity(inputValue);
    }

    public Comparable toJavaNativeValue(String columnName, Object inputValue) {
        return this.typeConverter.toJavaNativeValue(columnName, inputValue);
    }

    @Nullable
    public Comparable parseJavaNativeValue(String inputValue) {
        return this.typeConverter.parseJavaNativeValue(inputValue);
    }

    @Nullable
    public static OlapBuilderInputType findByXmlaType(CdXmlaSchemaType xmlaType) {
        for (OlapBuilderInputType type : OlapBuilderInputType.values()) {
            if (type.getXmlaType() != xmlaType) continue;
            return type;
        }
        return null;
    }

    public static boolean isFastMeasure(@Nullable OlapBuilderInputType type) {
        return type == DOUBLE || type == FLOAT || type == LONG || type == INTEGER || type == SHORT;
    }

    @Nullable
    public static OlapBuilderInputType findByFullName(String fullName) {
        for (OlapBuilderInputType type : OlapBuilderInputType.values()) {
            if (!Strings.CI.endsWith((CharSequence)fullName, (CharSequence)type.name)) continue;
            return type;
        }
        return null;
    }

    public static OlapBuilderInputType findByDBType(int dbType, int columnSize, int decimalDigits) {
        if (2 == dbType && columnSize == 0 && decimalDigits == 0) {
            return DOUBLE;
        }
        if ((2 == dbType || 3 == dbType) && decimalDigits == 0) {
            if (columnSize < 10) {
                return INTEGER;
            }
            if (columnSize < 20) {
                return LONG;
            }
            return LONG;
        }
        for (OlapBuilderInputType type : OlapBuilderInputType.values()) {
            int[] dbTypes = type.getDbTypes();
            if (dbTypes == null) continue;
            for (int currentType : dbTypes) {
                if (currentType != dbType) continue;
                return type;
            }
        }
        if (dbType == 2014) {
            return DATETIME;
        }
        return DB_TYPE_UNKNOWN;
    }

    public boolean sameUnderlyingType(OlapBuilderInputType type) {
        return this == type || this.typeConverter.getType() == type.typeConverter.getType();
    }

    public Class getJavaNativeValueType() {
        return this.typeConverter.getType();
    }

    public IOlapBuilderInputTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public boolean isDateType() {
        return this == DATE || this == DATETIME;
    }

    public boolean isNumber() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        throw new CdProgrammingException("missing switch case [" + String.valueOf((Object)this) + "]");
    }

    public boolean isFloatDouble() {
        return this == DOUBLE || this == FLOAT;
    }

    public boolean isInteger() {
        return this == LONG || this == INTEGER || this == SHORT;
    }

    public boolean isString() {
        return this == STRING || this == UPPERCASE_STRING;
    }

    public boolean isLookupTable() {
        return this == INTEGER;
    }

    public String getShortName() {
        return this.getName().replace("Type.", "");
    }

    public boolean supportsArrayFactColumn() {
        switch (this.ordinal()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static OlapBuilderInputType findByJavaClass(Class type) {
        if (type == String.class || type.isEnum()) {
            return STRING;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (type == Double.class || type == Double.TYPE || type == BigDecimal.class) {
            return DOUBLE;
        }
        if (type == Float.class || type == Float.TYPE) {
            return FLOAT;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return INTEGER;
        }
        if (type == Long.class || type == Long.TYPE) {
            return LONG;
        }
        if (type == Short.class || type == Short.TYPE) {
            return SHORT;
        }
        if (type == Calendar.class || type == Timestamp.class || type == LocalDateTime.class) {
            return DATETIME;
        }
        if (type == LocalDate.class || type == Date.class) {
            return DATE;
        }
        return null;
    }
}

