/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.offline.write;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineHelper;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderOfflineWriteRowReader
implements IOlapBuilderTableRowReader<IOlapBuilderConnection> {
    private final File directory;
    private final IOlapEngineLoadSchemaParams params;
    private final IOlapBuilderTableRowReader underlying;
    private final int partitionIdx;
    @Nullable
    private DataOutputStream out;

    public OlapBuilderOfflineWriteRowReader(OlapBuilderContext context, File directory, IOlapEngineLoadSchemaParams params, IOlapBuilderTableRowReader underlying, int partitionIdx) {
        this.directory = directory;
        this.params = params;
        this.underlying = underlying;
        this.partitionIdx = partitionIdx;
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[offline] setup a writing row-reader for table [" + underlying.getTableName() + "] partition [" + partitionIdx + "]"));
        }
    }

    @Override
    public String getName() {
        return "offline-write";
    }

    @Override
    public String getTableName() {
        return this.underlying.getTableName();
    }

    @Override
    public String getFullTableNameForEndUser() {
        return this.underlying.getFullTableNameForEndUser();
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.underlying.getPartitionKey();
    }

    @Override
    public IOlapBuilderDataTableDef<IOlapBuilderConnection> getTable() {
        return this.underlying.getTable();
    }

    @Override
    public void init() {
        this.underlying.init();
        this.createStream();
    }

    @Override
    public boolean isRowSafe() {
        return this.underlying.isRowSafe();
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow nextRow() {
        IOlapBuilderTableRow row = this.underlying.nextRow();
        if (row != null) {
            this.writeRow(row);
        }
        return row;
    }

    @Override
    public int rowNb() {
        return this.underlying.rowNb();
    }

    @Override
    public void done() {
        this.underlying.done();
        this.closeStream();
    }

    private void createStream() {
        boolean zip = this.params.getOfflineMode() == OlapEngineOfflineMode.WRITE_ZIP;
        String filename = OlapBuilderOfflineHelper.escapeTableIdForFileName(this.getTable()) + (String)(this.partitionIdx != -1 ? "-" + this.partitionIdx : "") + (zip ? ".zip" : "");
        File tableFile = new File(this.directory, filename);
        try {
            FilterOutputStream out_ = new BufferedOutputStream(new FileOutputStream(tableFile));
            if (zip) {
                out_ = new GZIPOutputStream(out_);
            }
            this.out = new DataOutputStream(out_);
            IOlapBuilderDataTableDef<IOlapBuilderConnection> table = this.getTable();
            List<IOlapBuilderDataColumnDef> selectedColumns = table.getSelectedColumns();
            int colCount = selectedColumns.size();
            this.out.writeInt(colCount);
            for (int ii = 0; ii < colCount; ++ii) {
                String colName = selectedColumns.get(ii).getName();
                this.out.writeUTF(colName);
            }
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[offline] could not create file for table [" + this.getTableName() + "]"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.OFFLINE_WRITE_TABLE_FILE_CREATE_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
        }
    }

    private void writeRow(IOlapBuilderTableRow row) {
        if (this.out == null) {
            return;
        }
        try {
            IOlapBuilderDataTableDef<IOlapBuilderConnection> table = this.getTable();
            List<IOlapBuilderDataColumnDef> selectedColumns = table.getSelectedColumns();
            for (IOlapBuilderDataColumnDef selectedColumn : selectedColumns) {
                Comparable nativeValue = row.getJavaNativeDataValue(selectedColumn);
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(nativeValue);
                serializer.write(this.out, nativeValue);
            }
            this.out.flush();
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[offline] could not write to the file for table [" + this.getTableName() + "] [row:" + this.rowNumberForEndUser() + "]"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.OFFLINE_WRITE_TABLE_FILE_WRITE_ERROR, new Serializable[]{this.getTableName(), this.rowNumberForEndUser(), ex.getMessage()});
        }
    }

    private void closeStream() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                OlapLoggers.BUILDER.error((Object)("[offline] could not properly flush/close the file for table [" + this.getTableName() + "]"), (Throwable)ex);
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.OFFLINE_WRITE_FILE_CLOSE_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
            }
        }
    }
}

